/*
 * Decompiled with CFR 0.152.
 */
package mp3;

import com.siemens.mp.io.File;
import mps.PlaylistItem;

public class MP3 {
    private File m_file = new File();
    private int m_file_desc;
    private int m_level;
    private int m_layer;
    public static final int MODE_STEREO = 0;
    public static final int MODE_JOINT_STEREO = 1;
    public static final int MODE_DUAL_CHANNEL = 2;
    public static final int MODE_MONO = 3;

    public static void getMP3Poperties(PlaylistItem a_pli) throws Exception {
        new MP3(a_pli);
    }

    private MP3(PlaylistItem a_pli) throws Exception {
        if (File.exists((String)(String.valueOf(a_pli.PATH) + a_pli.FILE)) == -1) {
            return;
        }
        this.m_file_desc = this.m_file.open(String.valueOf(a_pli.PATH) + a_pli.FILE);
        if (this.m_file_desc == -1) {
            return;
        }
        boolean is_parsed = this.parseID3(a_pli);
        if (!is_parsed) {
            this.parseID3v2(a_pli);
        }
        this.m_file.close(this.m_file_desc);
        a_pli.DID = 1;
    }

    private boolean parseID3(PlaylistItem a_pli) {
        int seek = this.m_file.length(this.m_file_desc) - 128;
        this.m_file.seek(this.m_file_desc, seek);
        byte[] tag = new byte[128];
        this.m_file.read(this.m_file_desc, tag, 0, tag.length);
        String s_tag = new String(tag);
        if (s_tag.substring(0, 3).equals("TAG")) {
            a_pli.SONG = s_tag.substring(3, 30).trim();
            a_pli.ARTIST = s_tag.substring(30, 60).trim();
            a_pli.ALBUM = s_tag.substring(60, 90).trim();
            int id3v2_size = this.getHeader();
            this.getParameters(a_pli, id3v2_size);
            return true;
        }
        this.m_file.seek(this.m_file_desc, 0);
        return false;
    }

    private void parseID3v2(PlaylistItem a_pli) {
        int id3v2_size = this.getHeader();
        if (id3v2_size > 0 && id3v2_size < 1000000) {
            this.getFrames(a_pli, id3v2_size);
        }
        this.getParameters(a_pli, id3v2_size);
    }

    private int getHeader() {
        byte[] head = new byte[10];
        this.m_file.seek(this.m_file_desc, 0);
        int get_head = this.m_file.read(this.m_file_desc, head, 0, head.length);
        if (!this.isHeader(head) || get_head == -1) {
            return 0;
        }
        return (head[9] & 0xFF) + ((head[8] & 0xFF) << 7) + ((head[7] & 0xFF) << 14) + ((head[6] & 0xFF) << 21);
    }

    private boolean isHeader(byte[] head) {
        if (head[0] != 73 || head[1] != 68 || head[2] != 51) {
            return false;
        }
        if (head[3] == -1 || head[4] == -1) {
            return false;
        }
        if (head[5] > 0) {
            return false;
        }
        return (head[6] & 0xFF) < 128 && (head[7] & 0xFF) < 128 && (head[8] & 0xFF) < 128 && (head[9] & 0xFF) < 128;
    }

    private void getFrames(PlaylistItem a_pli, int a_id3v2_size) {
        byte[] frames = new byte[a_id3v2_size];
        this.m_file.read(this.m_file_desc, frames, 0, frames.length);
        int length = frames.length;
        int i = 0;
        while (i < length) {
            byte[] b_name;
            String name;
            if (a_pli.ALBUM != null && a_pli.ARTIST != null && a_pli.SONG != null) {
                return;
            }
            if (length - i < 11) {
                return;
            }
            if ((name = new String(b_name = new byte[]{frames[i], frames[++i], frames[++i], frames[++i]})) == null) {
                return;
            }
            byte[] b_size = new byte[]{frames[++i], frames[++i], frames[++i], frames[++i]};
            long size = 0L;
            int j = 0;
            while (j < b_size.length) {
                size += (long)((b_size[j] & 0xFF) << (b_size.length - j - 1) * 8);
                ++j;
            }
            if (size == 0L) {
                return;
            }
            ++i;
            ++i;
            if (name.equals("TPE1")) {
                byte[] artist = new byte[(int)size];
                System.arraycopy(frames, ++i, artist, 0, artist.length);
                a_pli.ARTIST = new String(artist).trim();
                i += artist.length;
                continue;
            }
            if (name.equals("TIT2")) {
                byte[] song = new byte[(int)size];
                System.arraycopy(frames, ++i, song, 0, song.length);
                a_pli.SONG = new String(song).trim();
                i += song.length;
                continue;
            }
            if (name.equals("TALB")) {
                byte[] album = new byte[(int)size];
                System.arraycopy(frames, ++i, album, 0, album.length);
                a_pli.ALBUM = new String(album).trim();
                i += album.length;
                continue;
            }
            i = (int)((long)i + (size + 1L));
        }
    }

    private void getParameters(PlaylistItem a_pli, int a_id3v2_size) {
        byte second = 0;
        byte third = 0;
        byte fourth = 0;
        int length = 2048;
        byte[] search_frame = new byte[length];
        int file_size = this.m_file.length(this.m_file_desc);
        this.m_file.seek(this.m_file_desc, a_id3v2_size);
        int i = 0;
        while (file_size - a_id3v2_size - i * length >= length) {
            if (i == 1) {
                return;
            }
            this.m_file.read(this.m_file_desc, search_frame, 0, length);
            int j = 0;
            while (j < search_frame.length) {
                if ((search_frame[j] & 0xFF) == 255 && j + 1 < search_frame.length && (search_frame[j + 1] & 0xFF) >= 224) {
                    int bitrate;
                    second = search_frame[++j];
                    third = search_frame[++j];
                    fourth = search_frame[++j];
                    this.m_level = this.getBit(second, 3) == 1 ? 1 : 2;
                    this.m_layer = this.convertLayer(this.getBit(second, 2), this.getBit(second, 1));
                    a_pli.BITRATE = bitrate = this.convertBitrate(this.getBit(third, 7), this.getBit(third, 6), this.getBit(third, 5), this.getBit(third, 4));
                    a_pli.SAMPLERATE = this.convertSamplerate(this.getBit(third, 3), this.getBit(third, 2));
                    int mode = this.convertMode(this.getBit(fourth, 7), this.getBit(fourth, 6));
                    String string = a_pli.MODE = mode < 3 ? "stereo" : "mono";
                    if (bitrate != 0) {
                        a_pli.TIME = (int)Math.floor((double)((file_size - a_id3v2_size) / bitrate) * 0.008);
                    }
                    a_pli.TAG = a_id3v2_size;
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    private int getBit(int input, int bit) {
        if ((input & 1 << bit) > 0) {
            return 1;
        }
        return 0;
    }

    private int convertBitrate(int in1, int in2, int in3, int in4) {
        int[][] convert = new int[][]{new int[6], {32, 32, 32, 32, 32, 8}, {64, 48, 40, 64, 48, 16}, {96, 56, 48, 96, 56, 24}, {128, 64, 56, 128, 64, 32}, {160, 80, 64, 160, 80, 64}, {192, 96, 80, 192, 96, 80}, {224, 112, 96, 224, 112, 56}, {256, 128, 112, 256, 128, 64}, {288, 160, 128, 288, 160, 128}, {320, 192, 160, 320, 192, 160}, {352, 224, 192, 352, 224, 112}, {384, 256, 224, 384, 256, 128}, {416, 320, 256, 416, 320, 256}, {448, 384, 320, 448, 384, 320}, new int[6]};
        int index1 = in1 << 3 | in2 << 2 | in3 << 1 | in4;
        int index2 = (this.m_level - 1) * 3 + this.m_layer - 1;
        return convert[index1][index2];
    }

    private int convertSamplerate(int in1, int in2) {
        int sample = 0;
        switch (in1 << 1 | in2) {
            case 0: {
                sample = 44100;
                break;
            }
            case 1: {
                sample = 48000;
                break;
            }
            case 2: {
                sample = 32000;
                break;
            }
            case 3: {
                sample = 0;
            }
        }
        if (this.m_level == 1) {
            return sample;
        }
        return sample / 2;
    }

    private int convertMode(int in1, int in2) {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] convert = nArray;
        return convert[in1 << 1 | in2];
    }

    private int convertLayer(int in1, int in2) {
        if (in1 == 0 && in2 == 0) {
            return 0;
        }
        return 4 - ((in1 << 1) + in2);
    }
}

