/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;

public class UTF8Worker {
    public static String UTF8Decode(byte[] in, int offset, int length) {
        StringBuffer buff = new StringBuffer();
        int max = offset + length;
        for (int i = offset; i < max; ++i) {
            char c = '\u0000';
            if ((in[i] & 0x80) == 0) {
                c = (char)in[i];
            } else if ((in[i] & 0xE0) == 192) {
                c = (char)(c | (in[i] & 0x1F) << 6);
                c = (char)(c | (in[++i] & 0x3F) << 0);
            } else if ((in[i] & 0xF0) == 224) {
                c = (char)(c | (in[i] & 0xF) << 12);
                c = (char)(c | (in[++i] & 0x3F) << 6);
                c = (char)(c | (in[++i] & 0x3F) << 0);
            } else if ((in[i] & 0xF8) == 240) {
                c = (char)(c | (in[i] & 7) << 18);
                c = (char)(c | (in[++i] & 0x3F) << 12);
                c = (char)(c | (in[++i] & 0x3F) << 6);
                c = (char)(c | (in[++i] & 0x3F) << 0);
            } else {
                c = (char)63;
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static byte[] UTF8Encode(String str) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            int strlen = str.length();
            for (int i = 0; i < strlen; ++i) {
                char t = str.charAt(i);
                int c = 0;
                if ((c |= t & 0xFFFF) >= 0 && c < 128) {
                    bos.write((byte)(c & 0xFF));
                    continue;
                }
                if (c > 127 && c < 2048) {
                    bos.write((byte)(c >>> 6 & 0x1F | 0xC0));
                    bos.write((byte)(c >>> 0 & 0x3F | 0x80));
                    continue;
                }
                if (c > 2047 && c < 65536) {
                    bos.write((byte)(c >>> 12 & 0xF | 0x70));
                    bos.write((byte)(c >>> 6 & 0x3F | 0x80));
                    bos.write((byte)(c >>> 0 & 0x3F | 0x80));
                    continue;
                }
                if (c <= 65535 || c >= 1048575) continue;
                bos.write((byte)(c >>> 18 & 7 | 0xF0));
                bos.write((byte)(c >>> 12 & 0x3F | 0x80));
                bos.write((byte)(c >>> 6 & 0x3F | 0x80));
                bos.write((byte)(c >>> 0 & 0x3F | 0x80));
            }
            bos.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }
}

