/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char m = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c = this.delimiters.charAt(i);
            if (m >= c) continue;
            m = c;
        }
        this.maxDelimChar = m;
    }

    public StringTokenizer(String str, String delim, boolean returnDelims) {
        this.str = str;
        this.maxPosition = str.length();
        this.delimiters = delim;
        this.retDelims = returnDelims;
        this.setMaxDelimChar();
    }

    public StringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public StringTokenizer(String str) {
        this(str, " \t\n\r\f", false);
    }

    private int skipDelimiters(int startPos) {
        char c;
        int position;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (position = startPos; !this.retDelims && position < this.maxPosition && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++position) {
        }
        return position;
    }

    private int scanToken(int startPos) {
        char c;
        int position;
        for (position = startPos; position < this.maxPosition && ((c = this.str.charAt(position)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++position) {
        }
        if (this.retDelims && startPos == position && (c = this.str.charAt(position)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0) {
            ++position;
        }
        return position;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int start = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(start, this.currentPosition);
    }

    public String nextToken(String delim) {
        this.delimiters = delim;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int count = 0;
        int currpos = this.currentPosition;
        while (currpos < this.maxPosition && (currpos = this.skipDelimiters(currpos)) < this.maxPosition) {
            currpos = this.scanToken(currpos);
            ++count;
        }
        return count;
    }
}

