/*
 * Decompiled with CFR 0.152.
 */
package resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import radio.RadioMidlet;
import resource.LangFireChange;
import storage.StringStorage;
import util.Properties;

public class LanguageManager {
    private static LanguageManager lgm;
    private static boolean inited;
    private Properties prop = null;
    private static StringStorage sst;
    private String lang = null;
    private Properties lang_list = null;
    private static Vector eventerList;

    public static void init() {
        if (inited) {
            return;
        }
        lgm = new LanguageManager();
        if (!lgm.reload()) {
            lgm.reload();
        }
        inited = true;
    }

    private boolean reload() {
        Class<?> c = this.getClass();
        InputStream is = c.getResourceAsStream("/langlist.properties");
        this.lang_list = new Properties();
        try {
            this.lang_list.load(is);
        }
        catch (IOException e) {
            LanguageManager.raiseError(e);
        }
        try {
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        sst.load();
        this.lang = sst.getData();
        if (this.lang == null) {
            this.lang = System.getProperty("microedition.locale");
        }
        if ((is = c.getResourceAsStream("/lang/language_" + this.lang + ".properties")) == null) {
            is = c.getResourceAsStream("/lang/language_en.properties");
        }
        this.prop = new Properties();
        try {
            this.prop.load(is);
        }
        catch (Exception e) {
            LanguageManager.raiseError(e);
            sst.setData("en");
            sst.save();
            try {
                is.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
            return false;
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static void raiseError(Exception e) {
        RadioMidlet.error(e);
    }

    public static String getResource(String ident) {
        if (lgm != null) {
            return lgm.getString(ident);
        }
        return null;
    }

    private String getString(String ident) {
        return this.prop.getProperty(ident, ident);
    }

    public static void setLang(String lang) {
        sst.setData(lang);
        sst.save();
        if (!lgm.reload()) {
            lgm.reload();
        }
        LanguageManager.fireLangChanged();
    }

    public static String[] listLangs() {
        if (lgm != null) {
            return lgm.getLangList();
        }
        return null;
    }

    private String[] getLangList() {
        Enumeration en = this.lang_list.keys();
        Vector vc = new Vector();
        while (en.hasMoreElements()) {
            vc.addElement(en.nextElement());
        }
        String[] tr = new String[vc.size()];
        for (int i = 0; i < tr.length; ++i) {
            tr[i] = (String)vc.elementAt(i);
        }
        return tr;
    }

    public static String getLangDescr(String lang) {
        if (lgm != null) {
            return lgm.langDescr(lang);
        }
        return null;
    }

    private String langDescr(String lang) {
        return this.lang_list.getProperty(lang, lang);
    }

    public static void registerLangEvent(LangFireChange lafg) {
        eventerList.addElement(lafg);
    }

    private static void fireLangChanged() {
        Enumeration en = eventerList.elements();
        while (en.hasMoreElements()) {
            ((LangFireChange)en.nextElement()).langChanged();
        }
    }

    static {
        inited = false;
        sst = new StringStorage("lang");
        eventerList = new Vector();
    }
}

