/*
 * Decompiled with CFR 0.152.
 */
package radio.hardware;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import javax.microedition.media.Control;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import radio.RadioMidlet;
import radio.channels.RadioChannels;
import radio.hardware.AmmsTuner;
import radio.hardware.IdependedTuner;
import radio.hardware.SiemensTuner;

public class RadioHardware {
    public static final int FREQ_DIVIDER = 100000;
    private static int current_freq = -1;
    private static int minfreq = -1;
    private static int maxfreq = -1;
    private static Player radio = null;
    private static IdependedTuner tuner = null;
    private static VolumeControl volume = null;
    public static boolean DEBUG = true;
    private static boolean muted = false;
    public static int volume_level = 50;
    private static int currentMode = 3;

    public static void init() {
        int r = System.getProperty("microedition.platform").indexOf("SIE");
        if (r != -1) {
            DEBUG = false;
        }
        try {
            if (radio == null) {
                radio = Manager.createPlayer((String)"capture://radio");
                radio.realize();
                radio.prefetch();
            }
            if (radio != null) {
                if (tuner == null) {
                    tuner = RadioHardware.getTuner();
                }
                if (volume == null) {
                    volume = (VolumeControl)radio.getControl("VolumeControl");
                }
                maxfreq = tuner.getMaxFreq("fm") / 100000;
                current_freq = minfreq = tuner.getMinFreq("fm") / 100000;
                RadioHardware.initRadio();
            }
        }
        catch (Exception e) {
            if (DEBUG) {
                maxfreq = 1080;
                current_freq = minfreq = 875;
            }
            RadioMidlet.error(e);
        }
    }

    private static IdependedTuner getTuner() {
        try {
            if (Class.forName("javax.microedition.amms.control.tuner.TunerControl") != null) {
                return new AmmsTuner(radio);
            }
        }
        catch (Exception e) {
            return new SiemensTuner(radio);
        }
        return null;
    }

    public static void initRadio() {
        try {
            RadioHardware.setVolume(volume_level);
            radio.start();
            RadioHardware.setSquelch(true);
            RadioHardware.setFrequency(minfreq);
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
    }

    public static void setVolume(int value) {
        if (!muted) {
            volume.setLevel(value);
        }
    }

    public static void setMute(boolean value) {
        muted = value;
        volume.setMute(value);
    }

    private static void setFrequency(int freq) {
        if (DEBUG) {
            if (tuner != null) {
                tuner.setFrequency(freq * 100000, "fm");
            }
        } else {
            tuner.setFrequency(freq * 100000, "fm");
        }
    }

    public static int radioSeek(int startFreq, boolean upwards) {
        int frq = tuner.seek(startFreq * 100000, "fm", upwards);
        frq /= 100000;
        RadioHardware.setCurrent_freq(++frq);
        return frq;
    }

    public static boolean simpleSearch(boolean upwards) {
        int freq = RadioHardware.radioSeek(current_freq, upwards);
        if (freq == maxfreq) {
            freq = RadioHardware.radioSeek(minfreq, upwards);
        }
        if (freq != 0) {
            current_freq = freq;
            return true;
        }
        return false;
    }

    public static boolean searchForward() {
        return RadioHardware.simpleSearch(true);
    }

    public static boolean searchBackward() {
        return RadioHardware.simpleSearch(false);
    }

    public static void stepForward() {
        if (current_freq + 1 < maxfreq) {
            RadioHardware.setCurrent_freq(current_freq + 1);
        }
    }

    public static void stepBackward() {
        if (current_freq - 1 > minfreq) {
            RadioHardware.setCurrent_freq(current_freq - 1);
        }
    }

    public static void setSquelch(boolean squelch) {
        tuner.setSquelch(squelch);
    }

    public static int getCurrent_freq() {
        if (DEBUG) {
            if (tuner != null) {
                current_freq = tuner.getFrequency() / 100000;
            }
        } else {
            current_freq = tuner.getFrequency() / 100000;
        }
        return current_freq;
    }

    public static void setCurrent_freq(int current_freq) {
        RadioHardware.current_freq = current_freq;
        RadioHardware.setFrequency(RadioHardware.current_freq);
    }

    public static String getFrequency() {
        if (current_freq != -1) {
            return current_freq / 10 + "." + current_freq % 10;
        }
        return "--";
    }

    public static void start() {
        try {
            if (radio != null) {
                radio.start();
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
    }

    public static void stop() {
        try {
            RadioChannels.save();
            if (radio != null) {
                radio.stop();
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
    }

    public static void close() {
        if (tuner != null) {
            tuner.setFrequency(minfreq, "fm");
        }
        try {
            if (radio != null) {
                radio.deallocate();
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
        try {
            if (radio != null) {
                radio.close();
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
    }

    public static void showControls() {
        String ht = "";
        Control[] cc = radio.getControls();
        for (int i = 0; i < cc.length; ++i) {
            Control control = cc[i];
            ht = ht + control.toString() + "\r";
        }
        RadioMidlet.setDisplayable((Displayable)new Alert(null, ht, null, AlertType.INFO));
    }

    public static void volumeUp() {
        if (volume_level < 100) {
            volume_level += 5;
        }
        RadioHardware.setVolume(volume_level);
    }

    public static void volumeDown() {
        if (volume_level > 0) {
            volume_level -= 5;
        }
        RadioHardware.setVolume(volume_level);
    }

    public static int getVolume() {
        return volume_level;
    }

    public static String getSteroModeStr() {
        int rr = RadioHardware.getSteroMode();
        switch (rr) {
            case 1: {
                return "\u041c\u043e\u043d\u043e";
            }
            case 2: {
                return "\u0421\u0442\u0435\u0440\u0435\u043e";
            }
            case 3: {
                return "\u0410\u0432\u0442\u043e";
            }
        }
        return "";
    }

    public static int getSteroMode() {
        if (tuner != null) {
            return tuner.getStereoMode();
        }
        return -1;
    }

    public static int getSignalStrength() {
        if (tuner != null) {
            return tuner.getSignalStrength();
        }
        return -1;
    }

    public static void switchStereoMode() {
        if (tuner != null) {
            switch (currentMode) {
                case 1: {
                    tuner.setStereoMode(2);
                }
                case 2: {
                    tuner.setStereoMode(3);
                }
                case 3: {
                    tuner.setStereoMode(1);
                }
            }
        }
    }
}

