/*
 * Decompiled with CFR 0.152.
 */
package radio.hardware;

import javax.microedition.amms.control.tuner.TunerControl;
import javax.microedition.media.Player;
import radio.hardware.IdependedTuner;

public class AmmsTuner
implements IdependedTuner {
    TunerControl tc = null;

    public AmmsTuner(Player pl) {
        this.tc = (TunerControl)pl.getControl("TunerControl");
    }

    public int getFrequency() {
        return this.tc.getFrequency();
    }

    public int getMaxFreq(String modulation) {
        return this.tc.getMaxFreq(modulation);
    }

    public int getMinFreq(String modulation) {
        return this.tc.getMinFreq(modulation);
    }

    public String getModulation() {
        return this.tc.getModulation();
    }

    public int getNumberOfPresets() {
        return this.tc.getNumberOfPresets();
    }

    public int getPresetFrequency(int preset) {
        return this.tc.getPresetFrequency(preset);
    }

    public String getPresetModulation(int preset) {
        return this.tc.getPresetModulation(preset);
    }

    public String getPresetName(int preset) {
        return this.tc.getPresetName(preset);
    }

    public int getPresetStereoMode(int preset) {
        try {
            return this.tc.getPresetStereoMode(preset);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getSignalStrength() {
        try {
            return this.tc.getSignalStrength();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public boolean getSquelch() {
        return this.tc.getSquelch();
    }

    public int getStereoMode() {
        return this.tc.getStereoMode();
    }

    public int seek(int startFreq, String modulation, boolean upwards) {
        try {
            return this.tc.seek(startFreq, modulation, upwards);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int setFrequency(int freq, String modulation) {
        return this.tc.setFrequency(freq, modulation);
    }

    public void setPreset(int preset) {
        this.tc.setPreset(preset);
    }

    public void setPreset(int preset, int freq, String mod, int stereoMode) {
        this.tc.setPreset(preset, freq, mod, stereoMode);
    }

    public void setPresetName(int preset, String name) {
        this.tc.setPresetName(preset, name);
    }

    public void setSquelch(boolean squelch) {
        try {
            this.tc.setSquelch(squelch);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStereoMode(int mode) {
        this.tc.setStereoMode(mode);
    }

    public void usePreset(int preset) {
        this.tc.usePreset(preset);
    }
}

