/*
 * Decompiled with CFR 0.152.
 */
package radio.gui.settings;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import radio.RadioMidlet;
import radio.channels.RadioChannels;
import radio.gui.GuiResource;
import radio.gui.RadioCanvas;
import radio.gui.settings.FileBrowserListener;
import radio.gui.settings.LanguageSettings;
import radio.gui.settings.PopupInterface;
import radio.gui.settings.SettingsFileBrowser;
import radio.gui.settings.StandartDialog;
import resource.LangFireChange;
import resource.LanguageManager;

public class Settings
extends List
implements CommandListener,
FileBrowserListener,
LangFireChange,
PopupInterface {
    static Settings st = null;
    Command select = null;
    Command back = null;
    SettingsFileBrowser sfb = null;
    LanguageSettings ls = null;
    private int indx = -1;
    private static final String STANDART_FILENAME = "0:/misc/channels.csv";

    public Settings() {
        super("", 3);
        this.initSettings();
        this.sfb = new SettingsFileBrowser((Displayable)this);
        this.ls = new LanguageSettings();
        LanguageManager.registerLangEvent(this);
    }

    private void initSettings() {
        this.setTitle(LanguageManager.getResource("settings.caption"));
        this.deleteAll();
        this.append(LanguageManager.getResource("settings.language"), null);
        this.append(LanguageManager.getResource("settings.skin"), null);
        this.append(LanguageManager.getResource("settings.background"), null);
        this.append(LanguageManager.getResource("settings.exportchannels"), null);
        this.append(LanguageManager.getResource("settings.importchannels"), null);
        this.setCommandListener(this);
        if (this.select != null) {
            this.removeCommand(this.select);
        }
        if (this.back != null) {
            this.removeCommand(this.back);
        }
        this.select = new Command(LanguageManager.getResource("select"), 4, 1);
        this.back = new Command(LanguageManager.getResource("back"), 2, 2);
        this.addCommand(this.select);
        this.addCommand(this.back);
        this.setSelectCommand(this.select);
    }

    public static void init() {
        st = new Settings();
    }

    public static Displayable getSettings() {
        return st;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.select) {
            this.indx = this.getSelectedIndex();
            switch (this.indx) {
                case 0: {
                    RadioMidlet.setDisplayable((Displayable)this.ls);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    StandartDialog.popup((Displayable)this);
                    break;
                }
                case 3: {
                    try {
                        RadioChannels.saveToFile(STANDART_FILENAME);
                    }
                    catch (Exception e) {
                        RadioMidlet.error(e);
                    }
                    break;
                }
                case 4: {
                    StandartDialog.popup((Displayable)this);
                    break;
                }
            }
        } else {
            RadioMidlet.setDisplayable(RadioCanvas.me());
        }
    }

    public void selectFile(String fn) {
        if (this.indx == 2) {
            if (GuiResource.setBkImage(fn)) {
                RadioMidlet.setDisplayable(RadioCanvas.me());
            }
        } else if (this.indx == 4 && RadioChannels.loadFromFile(fn)) {
            RadioMidlet.setDisplayable(RadioCanvas.me());
        }
    }

    public void langChanged() {
        this.initSettings();
    }

    public void setResult(int selectedIndex) {
        if (this.indx == 2) {
            if (selectedIndex == 1) {
                this.sfb.reset();
                RadioMidlet.setDisplayable((Displayable)this.sfb);
            } else {
                this.selectFile(null);
            }
        } else if (this.indx == 4) {
            if (selectedIndex == 1) {
                this.sfb.reset();
                this.sfb.setFilter(".csv");
                RadioMidlet.setDisplayable((Displayable)this.sfb);
            } else {
                this.selectFile(STANDART_FILENAME);
            }
        }
    }
}

