/*
 * Decompiled with CFR 0.152.
 */
package radio.gui.settings;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import radio.RadioMidlet;
import radio.gui.settings.Settings;
import resource.LanguageManager;

public class LanguageSettings
extends List
implements CommandListener {
    String[] langList = null;
    String[] langDescrList = null;
    Command select = null;
    Command back = null;

    public LanguageSettings() {
        super("", 3);
        this.init();
        this.langList = LanguageManager.listLangs();
        this.langDescrList = new String[this.langList.length];
        for (int i = 0; i < this.langList.length; ++i) {
            this.langDescrList[i] = LanguageManager.getLangDescr(this.langList[i]);
            this.append(this.langDescrList[i], null);
        }
        this.setCommandListener(this);
    }

    public void init() {
        this.setTitle(LanguageManager.getResource("settings.language"));
        if (this.select != null) {
            this.removeCommand(this.select);
        }
        if (this.back != null) {
            this.removeCommand(this.back);
        }
        this.select = new Command(LanguageManager.getResource("select"), 4, 1);
        this.back = new Command(LanguageManager.getResource("back"), 2, 2);
        this.addCommand(this.select);
        this.addCommand(this.back);
        this.setSelectCommand(this.select);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.select) {
            if (this.getSelectedIndex() != -1) {
                String lang = this.langList[this.getSelectedIndex()];
                System.out.println("lang = " + lang);
                LanguageManager.setLang(lang);
                RadioMidlet.getDisplay().setCurrent(Settings.getSettings());
            }
        } else if (command == this.back) {
            RadioMidlet.getDisplay().setCurrent(Settings.getSettings());
        }
    }
}

