/*
 * Decompiled with CFR 0.152.
 */
package radio.gui;

import com.siemens.mp.resource.Resource;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import radio.RadioMidlet;
import radio.channels.Channel;
import radio.channels.RadioChannels;
import radio.gui.ChannelForm;
import radio.gui.ChannelsLister;
import radio.gui.DoubleClick;
import radio.gui.GarnitureThread;
import radio.gui.GuiResource;
import radio.gui.RefreshDynamicTask;
import radio.gui.RepeatThread;
import radio.gui.menu.MenuItem;
import radio.gui.settings.Settings;
import radio.hardware.RadioHardware;
import resource.LangFireChange;
import resource.LanguageManager;

public class RadioCanvas
extends Canvas
implements LangFireChange {
    private static MenuItem[] menuItems = null;
    private static MenuItem[] mainMenu = null;
    private static MenuItem[] editMenu = null;
    private static String[] mainMenuItems = null;
    private static String[] editMenuItems = null;
    private static String menu = null;
    private static String cancel = null;
    private static String select = null;
    private static final int topLeftAnchor = 20;
    private static final int leftBottomAnchor = 36;
    private static final int topCenterAnchor = 17;
    private static final int rightBottomAnchor = 40;
    private static final int rightTopAnchor = 24;
    private static int[] headerArray = null;
    private static int[] whiteArray = null;
    private static int[] blackArray = null;
    private static int[] strongBlackArray = null;
    private static int[] headerLine = null;
    public static int headerWidth = 240;
    public static int headerHeight = 10;
    public static Font timeFont = Font.getFont((int)32, (int)2, (int)8);
    public static Font menuFont = Font.getFont((int)32, (int)1, (int)8);
    public static Font freqFont = Font.getFont((int)32, (int)1, (int)16);
    private static final int OUTLINE_COLOR = 986895;
    private static final int FONT_COLOR = 0xF0F0F0;
    public static final int MENU_COLOR = 0xF0F0F0;
    private int back_color = 0;
    private static boolean muted = false;
    private RepeatThread rt = null;
    private static RadioCanvas rc = null;
    private static ChannelsLister channels_lister = null;
    private Channel rchannel = null;
    private boolean drawMenu = false;
    private int menuWidth = -1;
    private int menuHeight = -1;
    private int menuY = 295;
    private int currMenuItem = 0;
    private String index = "";
    private boolean searching = false;
    private int press_ctr = 0;
    private boolean lock;
    private boolean garniture_lock = false;
    private boolean key_lock = false;
    private boolean sound_lock = false;
    private boolean channel_list_mode = false;
    private GarnitureThread gt;
    private boolean double_click = false;
    private Timer ref_timer = null;
    private RefreshDynamicTask rdt = null;

    public RadioCanvas() {
        int i;
        rc = this;
        this.setFullScreenMode(true);
        this.initMenus();
        LanguageManager.registerLangEvent(this);
        whiteArray = new int[headerWidth * headerHeight];
        for (i = 0; i < whiteArray.length; ++i) {
            RadioCanvas.whiteArray[i] = 0x50F0F0F0;
        }
        blackArray = new int[headerWidth * headerHeight];
        for (i = 0; i < blackArray.length; ++i) {
            RadioCanvas.blackArray[i] = 0x500F0F0F;
        }
        strongBlackArray = new int[headerWidth * headerHeight];
        for (i = 0; i < strongBlackArray.length; ++i) {
            RadioCanvas.strongBlackArray[i] = -1609625841;
        }
        headerLine = new int[headerWidth];
        for (i = 0; i < headerLine.length; ++i) {
            RadioCanvas.headerLine[i] = -1594822416;
        }
        MenuItem.init(menuFont);
        mainMenu = MenuItem.constructMenu(mainMenuItems);
        editMenu = MenuItem.constructMenu(editMenuItems);
        this.menuHeight = menuFont.getHeight() * 3;
        menuItems = mainMenu;
        this.rchannel = RadioChannels.getChannelByFreq(RadioHardware.getCurrent_freq());
        channels_lister = new ChannelsLister();
        channels_lister.initChannels();
        channels_lister.setFont(Font.getFont((int)64, (int)0, (int)8));
        try {
            channels_lister.setWindow(0, 130, 239, 150);
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
    }

    public void startTimer() {
        this.rdt = new RefreshDynamicTask();
        this.ref_timer = new Timer();
        this.ref_timer.scheduleAtFixedRate((TimerTask)this.rdt, 500L, 500L);
    }

    public void stopTimer() {
        this.ref_timer.cancel();
    }

    protected void paint(Graphics graphics) {
        if (GuiResource.getBkImage() != null) {
            graphics.drawImage(GuiResource.getBkImage(), 0, 0, 20);
        } else {
            graphics.setColor(this.back_color);
            graphics.fillRect(0, 0, this.getHeight(), this.getWidth());
        }
        headerArray = whiteArray;
        RadioCanvas.drawBackground(graphics, 0, 0, 240, timeFont.getHeight() + 5);
        graphics.setFont(timeFont);
        int ypos = graphics.getFont().getHeight();
        Calendar cc = RadioCanvas.getCalendar();
        String date = RadioCanvas.getDate(cc);
        String time = RadioCanvas.getTime(cc);
        RadioCanvas.drawOutlineString(graphics, date, 15, 3, 20);
        RadioCanvas.drawOutlineString(graphics, time, headerWidth - 15, 3, 24);
        graphics.drawRGB(headerLine, 0, headerWidth, 0, timeFont.getHeight() + 5, headerWidth, 1, true);
        ypos += 30;
        graphics.setFont(freqFont);
        headerArray = blackArray;
        int t = freqFont.getHeight();
        String freq = RadioHardware.getFrequency();
        int xFreq = 45;
        int dataXpos = freqFont.stringWidth(freq) + xFreq;
        if (freq.charAt(0) != '1') {
            dataXpos += freqFont.stringWidth("1");
        }
        if (this.rchannel != null) {
            int hg = t + menuFont.getHeight() + 23;
            RadioCanvas.drawBackground(graphics, 0, ypos - 10, 240, hg);
        } else {
            RadioCanvas.drawBackground(graphics, 0, ypos - 10, 240, t + 12);
        }
        t = ypos;
        ypos += RadioCanvas.drawOutlineString(graphics, freq, dataXpos, ypos, 24);
        graphics.drawRGB(headerLine, 0, headerWidth, 0, ypos + 5, 240, 1, true);
        ypos += 5;
        graphics.setFont(timeFont);
        int rr = RadioHardware.getVolume();
        int volWidth = 70;
        int volHeight = 20;
        int vol_x = dataXpos += 10;
        int vol_y = t + 30;
        double et = 0.0;
        int el = 0;
        if (rr != 0) {
            et = (double)rr / 100.0;
        }
        el = (int)((double)volWidth * et);
        graphics.drawRGB(headerLine, 0, headerWidth, vol_x, vol_y, el, 1, true);
        graphics.drawRGB(headerLine, 0, headerWidth, vol_x, vol_y + 1, el, 1, true);
        graphics.drawRGB(headerLine, 0, headerWidth, vol_x, vol_y + 2, el, 1, true);
        graphics.drawRGB(headerLine, 0, headerWidth, vol_x, vol_y + 3, el, 1, true);
        graphics.drawRGB(headerLine, 0, headerWidth, vol_x, vol_y + 4, el, 1, true);
        if (this.rchannel != null) {
            String ind = "" + this.rchannel.index;
            if (ind.length() == 1) {
                ind = "0" + ind;
            }
            RadioCanvas.drawOutlineString(graphics, ind, 15, t + 3, 20);
            RadioCanvas.drawOutlineString(graphics, this.rchannel.name, 15, ypos, 20);
        }
        if (!this.lock) {
            headerArray = whiteArray;
            graphics.setFont(menuFont);
            RadioCanvas.drawBackground(graphics, 0, this.menuY, 240, 45);
            if (!this.drawMenu) {
                if (!this.channel_list_mode) {
                    try {
                        char c = ' ';
                        c = muted ? (char)Resource.getCenterKeyIcon(7) : (char)Resource.getCenterKeyIcon(8);
                        graphics.drawChar(c, 110, 320, 36);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (this.channel_list_mode) {
                    RadioCanvas.drawOutlineString(graphics, select, 10, this.menuY + 17 + 5, 36);
                } else {
                    RadioCanvas.drawOutlineString(graphics, menu, 10, this.menuY + 17 + 5, 36);
                }
                graphics.drawRGB(headerLine, 0, headerWidth, 0, this.menuY, headerWidth, 1, true);
            } else {
                headerArray = strongBlackArray;
                RadioCanvas.drawBackground(graphics, 1, this.menuY - 100, 240, this.menuHeight);
                RadioCanvas.drawString(graphics, RadioCanvas.menuItems[this.currMenuItem].name, 120 - RadioCanvas.menuItems[this.currMenuItem].halflength, this.menuY - 100 + menuFont.getHeight(), 20);
                RadioCanvas.drawOutlineString(graphics, cancel, 230, this.menuY + 17 + 5, 40);
                graphics.drawRGB(headerLine, 0, headerWidth, 0, this.menuY, headerWidth, 1, true);
            }
        }
        if (this.channel_list_mode) {
            channels_lister.paint(graphics);
        }
    }

    public static void drawBackground(Graphics graphics, int x, int y, int width, int height) {
        int bar_count = height / headerHeight;
        if (height % headerHeight > 5) {
            ++bar_count;
        }
        for (int i = 0; i < bar_count; ++i) {
            graphics.drawRGB(headerArray, 0, headerWidth, x, y + headerHeight * i, width, headerHeight, true);
        }
    }

    public static int drawString(Graphics graphics, String text, int x, int y, int anchor) {
        graphics.setColor(0xF0F0F0);
        graphics.drawString(text, x, y, anchor);
        return graphics.getFont().getHeight();
    }

    public static int drawOutlineString(Graphics graphics, String text, int x, int y, int anchor) {
        graphics.setColor(986895);
        graphics.drawString(text, x, y + 1, anchor);
        graphics.drawString(text, x, y - 1, anchor);
        graphics.drawString(text, x + 1, y, anchor);
        graphics.drawString(text, x - 1, y, anchor);
        graphics.setColor(0xF0F0F0);
        graphics.drawString(text, x, y, anchor);
        return graphics.getFont().getHeight();
    }

    public static String getDate(Calendar c) {
        int m = c.get(2);
        int day = c.get(5);
        if (++m < 10 && day < 10) {
            return "0" + day + ".0" + m + "." + c.get(1);
        }
        if (m < 10) {
            return day + ".0" + m + "." + c.get(1);
        }
        return day + "." + m + "." + c.get(1);
    }

    public static String getTime(Calendar c) {
        int h = c.get(10);
        int m = c.get(12);
        String min = "";
        min = m < 10 ? "0" + m : Integer.toString(m);
        if (h < 10 && c.get(9) == 0) {
            return "0" + h + ":" + min;
        }
        if (h < 10 && c.get(9) == 1) {
            return 12 + h + ":" + min;
        }
        return h + ":" + min;
    }

    public static Calendar getCalendar() {
        Date date = new Date();
        date.setTime(date.getTime());
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(date);
        return calendar;
    }

    public void menuForward() {
        if (this.drawMenu) {
            this.currMenuItem = this.currMenuItem < menuItems.length - 1 ? ++this.currMenuItem : 0;
            RadioMidlet.redraw();
        }
    }

    public void menuBack() {
        if (this.drawMenu) {
            this.currMenuItem = this.currMenuItem > 0 ? --this.currMenuItem : menuItems.length - 1;
            RadioMidlet.redraw();
        }
    }

    public static int debugConvert(int key) {
        if (key == -6) {
            return -1;
        }
        if (key == -7) {
            return -4;
        }
        if (key == -5) {
            return -26;
        }
        if (key == -3) {
            return -61;
        }
        if (key == -4) {
            return -62;
        }
        if (key == -1) {
            return -59;
        }
        if (key == -2) {
            return -60;
        }
        return key;
    }

    protected void keyPressed(int key1) {
        int key = key1;
        if (RadioHardware.DEBUG) {
            key = RadioCanvas.debugConvert(key1);
        }
        if (key == -39) {
            this.garniture_lock = false;
            this.gt = new GarnitureThread();
            this.gt.setDoClick(true);
            this.gt.start();
        } else if (!this.lock) {
            if (key == -11) {
                if (!this.drawMenu && RadioChannels.hasData()) {
                    boolean bl = this.channel_list_mode = !this.channel_list_mode;
                    if (this.channel_list_mode) {
                        this.startTimer();
                    } else {
                        this.stopTimer();
                    }
                    RadioMidlet.redraw();
                }
            } else if (key == -26) {
                if (this.channel_list_mode) {
                    this.rchannel = channels_lister.getChannel();
                    RadioHardware.setCurrent_freq(this.rchannel.frequency);
                    RadioMidlet.redraw();
                } else if (this.drawMenu) {
                    rc.menuClick();
                } else {
                    this.switchMute();
                }
            } else if (key == -59) {
                if (this.channel_list_mode) {
                    channels_lister.up();
                    RadioMidlet.redraw();
                } else if (RadioChannels.hasData()) {
                    this.rchannel = RadioChannels.nextChannel();
                    if (this.rchannel != null) {
                        RadioHardware.setCurrent_freq(this.rchannel.frequency);
                        RadioMidlet.redraw();
                    }
                }
            } else if (key == -60) {
                if (this.channel_list_mode) {
                    channels_lister.down();
                    RadioMidlet.redraw();
                } else if (RadioChannels.hasData()) {
                    this.rchannel = RadioChannels.prevChannel();
                    if (this.rchannel != null) {
                        RadioHardware.setCurrent_freq(this.rchannel.frequency);
                        RadioMidlet.redraw();
                    }
                }
            } else if (key == -61) {
                if (this.drawMenu) {
                    rc.menuBack();
                } else {
                    this.key_lock = false;
                }
            } else if (key == -62) {
                if (this.drawMenu) {
                    rc.menuForward();
                } else {
                    this.key_lock = false;
                }
            } else if (key == -1) {
                if (this.channel_list_mode) {
                    this.rchannel = channels_lister.getChannel();
                    RadioHardware.setCurrent_freq(this.rchannel.frequency);
                    RadioMidlet.redraw();
                } else if (!this.drawMenu) {
                    this.drawMenu = true;
                    this.currMenuItem = 0;
                    menuItems = this.rchannel == null ? mainMenu : editMenu;
                    RadioMidlet.redraw();
                }
            } else if (key == -4) {
                if (this.drawMenu) {
                    this.drawMenu = false;
                }
                RadioMidlet.redraw();
            } else if (key == -13) {
                RadioHardware.volumeUp();
                RadioMidlet.redraw();
            } else if (key == -14) {
                RadioHardware.volumeDown();
                RadioMidlet.redraw();
            } else if (key >= 48 && key <= 57) {
                if (this.index.length() < 1) {
                    this.index = this.index + (char)key;
                } else {
                    this.index = this.index + (char)key;
                    Channel l = RadioChannels.getChannelByIndex(Integer.parseInt(this.index));
                    if (l != null) {
                        this.rchannel = RadioChannels.getChannelByIndex(Integer.parseInt(this.index));
                        RadioHardware.setCurrent_freq(this.rchannel.frequency);
                    }
                    RadioMidlet.redraw();
                    this.index = "";
                }
            } else if (key == 35) {
                this.sound_lock = false;
            } else if (key == 42) {
                this.key_lock = false;
            } else {
                RadioMidlet.setDisplayable((Displayable)new Alert("" + key));
            }
        } else if (key == 35) {
            this.sound_lock = false;
        }
    }

    private void switchMute() {
        muted = !muted;
        RadioHardware.setMute(muted);
        RadioMidlet.redraw();
    }

    private void menuClick() {
        if (this.currMenuItem == 1 && menuItems == editMenu) {
            RadioChannels.delChannel(this.rchannel);
            this.drawMenu = false;
            RadioCanvas.updateChannel();
            RadioMidlet.redraw();
        } else if (this.currMenuItem == 2 && menuItems == editMenu) {
            RadioChannels.clear();
            this.drawMenu = false;
            RadioCanvas.updateChannel();
            RadioMidlet.redraw();
        } else if (this.currMenuItem == 0) {
            if (this.rchannel == null) {
                ChannelForm.show(RadioHardware.getCurrent_freq());
            } else {
                ChannelForm.show(this.rchannel);
            }
        } else if (this.currMenuItem == menuItems.length - 4) {
            RadioMidlet.setDisplayable(Settings.getSettings());
        } else if (this.currMenuItem == menuItems.length - 1) {
            RadioHardware.stop();
            RadioMidlet.exit();
        } else if (this.currMenuItem == menuItems.length - 2) {
            RadioMidlet.exec("native://NAT_MAIN_MENU");
        } else if (this.currMenuItem == menuItems.length - 3) {
            this.switchLock();
            this.drawMenu = false;
            RadioMidlet.redraw();
        }
    }

    private void switchLock() {
        this.lock = !this.lock;
    }

    protected void keyReleased(int key1) {
        int key = key1;
        if (RadioHardware.DEBUG) {
            key = RadioCanvas.debugConvert(key);
        }
        DoubleClick.setKey(key);
        if (key == -39 && !this.garniture_lock) {
            this.gt.setDoClick(false);
            this.switchMute();
            RadioMidlet.redraw();
        }
        if (!this.lock && !this.channel_list_mode) {
            if (key == -61) {
                if (!this.drawMenu && !this.key_lock) {
                    RadioHardware.stepBackward();
                    this.rchannel = RadioChannels.getChannelByFreq(RadioHardware.getCurrent_freq());
                    RadioMidlet.redraw();
                }
            } else if (key == -62) {
                if (!this.drawMenu && !this.key_lock) {
                    RadioHardware.stepForward();
                    ++this.press_ctr;
                    this.rchannel = RadioChannels.getChannelByFreq(RadioHardware.getCurrent_freq());
                    RadioMidlet.redraw();
                }
            } else if (key == 42 && !this.drawMenu && !this.key_lock) {
                RadioHardware.switchStereoMode();
                RadioMidlet.redraw();
            }
        }
        if (key == 35) {
            this.sound_lock = false;
        }
        if (key != 35) {
            this.press_ctr = 0;
        }
    }

    protected void keyRepeated(int key) {
        if (!this.channel_list_mode) {
            if (this.lock) {
                if (!this.sound_lock && key == 35) {
                    this.switchLock();
                    RadioMidlet.redraw();
                    this.sound_lock = true;
                }
            } else {
                if (key == -61) {
                    if (this.press_ctr != -1) {
                        this.press_ctr = -1;
                        this.key_lock = true;
                        this.searching = true;
                        RadioMidlet.redraw();
                        RadioHardware.searchBackward();
                        RadioCanvas.updateChannel();
                        RadioMidlet.redraw();
                        this.searching = false;
                    }
                } else if (key == -62) {
                    if (this.press_ctr != -1) {
                        this.press_ctr = -1;
                        this.searching = true;
                        this.key_lock = true;
                        RadioMidlet.redraw();
                        RadioHardware.searchForward();
                        RadioCanvas.updateChannel();
                        RadioMidlet.redraw();
                        this.searching = false;
                    }
                } else if (key == 35) {
                    if (!this.drawMenu && !this.sound_lock) {
                        this.sound_lock = true;
                        this.switchLock();
                        RadioMidlet.redraw();
                    }
                } else if (key == 42 && !this.drawMenu && this.press_ctr != -1) {
                    this.key_lock = true;
                    this.press_ctr = -1;
                    this.switchMute();
                }
                if (key == -13 || key == -14) {
                    this.keyPressed(key);
                }
            }
        }
    }

    public static void pressKey(int key, int cntr) {
        if (key == -39 && !RadioCanvas.rc.drawMenu) {
            RadioCanvas.rc.garniture_lock = true;
            if (RadioChannels.hasData()) {
                RadioCanvas.rc.rchannel = RadioChannels.nextChannel();
                if (RadioCanvas.rc.rchannel != null) {
                    RadioHardware.setCurrent_freq(RadioCanvas.rc.rchannel.frequency);
                    RadioMidlet.redraw();
                }
            }
        }
    }

    public static void updateChannel() {
        rc.readChannel();
    }

    private void readChannel() {
        this.rchannel = RadioChannels.getChannelByFreq(RadioHardware.getCurrent_freq());
    }

    public static Displayable me() {
        return rc;
    }

    private void initMenus() {
        mainMenuItems = new String[]{LanguageManager.getResource("channel.save"), LanguageManager.getResource("channel.autoscan"), LanguageManager.getResource("settings"), LanguageManager.getResource("keyboardlock"), LanguageManager.getResource("phonemenu"), LanguageManager.getResource("exit")};
        editMenuItems = new String[]{LanguageManager.getResource("channel.edit"), LanguageManager.getResource("channel.delete"), LanguageManager.getResource("channel.deleteall"), LanguageManager.getResource("settings"), LanguageManager.getResource("keyboardlock"), LanguageManager.getResource("phonemenu"), LanguageManager.getResource("exit")};
        menu = LanguageManager.getResource("menu");
        cancel = LanguageManager.getResource("cancel");
        select = LanguageManager.getResource("select");
    }

    public void langChanged() {
        this.initMenus();
        int t_indx = -1;
        if (menuItems == mainMenu) {
            t_indx = 0;
        } else if (menuItems == editMenu) {
            t_indx = 1;
        }
        mainMenu = MenuItem.constructMenu(mainMenuItems);
        editMenu = MenuItem.constructMenu(editMenuItems);
        if (t_indx == 0) {
            menuItems = mainMenu;
        } else if (t_indx == 1) {
            menuItems = editMenu;
        }
    }

    public static void channelsChanged() {
        channels_lister.initChannels();
    }
}

