/*
 * Decompiled with CFR 0.152.
 */
package radio.gui;

import file.FileProcessor;
import javax.microedition.lcdui.Image;
import radio.RadioMidlet;
import storage.StringStorage;

public class GuiResource {
    private static Image bkImage = null;
    private static boolean inited = false;
    private static StringStorage sst = new StringStorage("backImage");

    public static void initResource() {
        if (inited) {
            return;
        }
        bkImage = null;
        try {
            sst.load();
            String file = sst.getData();
            if (file != null && (bkImage = FileProcessor.getImage(file)) != null && (bkImage.getWidth() > 240 || bkImage.getHeight() > 320)) {
                bkImage = GuiResource.resizeImage(bkImage, 240, 320);
            }
            if (bkImage == null) {
                bkImage = Image.createImage((String)"/27289874.png");
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
        inited = true;
    }

    public static boolean setBkImage(String sdt) {
        if (sdt == null) {
            sst.setData(null);
            sst.save();
            inited = false;
            GuiResource.initResource();
            return true;
        }
        try {
            bkImage = FileProcessor.getImage(sdt);
            if (bkImage != null) {
                sst.setData(sdt);
                sst.save();
                inited = false;
                GuiResource.initResource();
                return true;
            }
        }
        catch (Exception e) {
            RadioMidlet.error(e);
        }
        return false;
    }

    public static Image getBkImage() {
        return bkImage;
    }

    private static Image resizeImage(Image src, int newX, int newY) {
        int[] rgb = new int[src.getWidth() * src.getHeight()];
        src.getRGB(rgb, 0, src.getWidth(), 0, 0, src.getWidth(), src.getHeight());
        int[] rgb2 = GuiResource.reescalaArray(rgb, src.getWidth(), src.getHeight(), newX, newY);
        return Image.createRGBImage((int[])rgb2, (int)newX, (int)newY, (boolean)true);
    }

    private static int[] reescalaArray(int[] ini, int x, int y, int x2, int y2) {
        int[] out = new int[x2 * y2];
        for (int yy = 0; yy < y2; ++yy) {
            int dy = yy * y / y2;
            for (int xx = 0; xx < x2; ++xx) {
                int dx = xx * x / x2;
                out[x2 * yy + xx] = ini[x * dy + dx];
            }
        }
        return out;
    }
}

