/*
 * Decompiled with CFR 0.152.
 */
package radio.channels;

import file.FileProcessor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Displayable;
import radio.RadioMidlet;
import radio.channels.Channel;
import radio.channels.ChannelStorage;
import radio.hardware.RadioHardware;
import storage.OneIntStorage;
import util.StringTokenizer;
import util.UTF8Worker;

public class RadioChannels {
    public static final String volumeStore = "VolStore";
    public static final String freqStore = "FreqStore";
    public static final String oldFreqData = "OldFreqData";
    private static Vector channels = null;
    private static int channelIndx = -1;
    private static int oldFreq = -1;
    private static OneIntStorage volumStore;
    private static OneIntStorage oldFreqStore;
    private static ChannelStorage channelsStorage;

    public static void init() {
        volumStore = new OneIntStorage(volumeStore);
        oldFreqStore = new OneIntStorage(oldFreqData);
        channelsStorage = new ChannelStorage();
        RadioChannels.load();
    }

    public static void clear() {
        channels.removeAllElements();
    }

    private static void load() {
        oldFreqStore.load();
        if (oldFreqStore.getValue() != -1) {
            RadioHardware.setCurrent_freq(oldFreqStore.getValue());
        }
        volumStore.load();
        if (volumStore.getValue() != -1) {
            if (volumStore.getValue() > -1 && volumStore.getValue() < 101) {
                RadioHardware.volume_level = volumStore.getValue();
                RadioHardware.setVolume(volumStore.getValue());
            } else {
                RadioHardware.setVolume(50);
            }
        }
        channelsStorage.load();
        channels = channelsStorage.getChannels();
    }

    public static void save() {
        oldFreqStore.setValue(RadioHardware.getCurrent_freq());
        oldFreqStore.save();
        volumStore.setValue(RadioHardware.getVolume());
        volumStore.save();
        channelsStorage.setChannels(channels);
        channelsStorage.save();
    }

    public static void saveToFile(String filename) throws IOException {
        Enumeration en = channels.elements();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(239);
        bos.write(187);
        bos.write(191);
        bos.write("### List Channels\r\n".getBytes());
        while (en.hasMoreElements()) {
            Channel chl = (Channel)en.nextElement();
            bos.write(Integer.toString(chl.index).getBytes());
            bos.write(59);
            bos.write(Integer.toString(chl.frequency).getBytes());
            bos.write(59);
            bos.write(UTF8Worker.UTF8Encode(chl.name));
            bos.write(13);
            bos.write(10);
        }
        FileProcessor.write(filename, bos.toByteArray());
    }

    public static boolean loadFromFile(String filename) {
        block7: {
            try {
                byte[] bb = FileProcessor.readFile(filename);
                if (bb == null) break block7;
                String ds = null;
                try {
                    ds = bb[0] == -17 && bb[1] == -69 && bb[2] == -65 ? UTF8Worker.UTF8Decode(bb, 3, bb.length - 3) : UTF8Worker.UTF8Decode(bb, 0, bb.length);
                }
                catch (Exception e) {
                    RadioMidlet.setDisplayable((Displayable)new Alert("Error 1", e.getMessage() + "\r" + e, null, AlertType.ERROR));
                }
                if (ds != null) {
                    StringTokenizer st = new StringTokenizer(ds, "\r\n");
                    RadioChannels.clear();
                    while (st.hasMoreTokens()) {
                        String line = st.nextToken();
                        if (line == null || (line = line.trim()).indexOf("#") == 0) continue;
                        StringTokenizer stz = new StringTokenizer(line, ";");
                        String index_str = stz.nextToken();
                        String freq_str = stz.nextToken();
                        String name = stz.nextToken();
                        if (index_str != null && freq_str != null && name != null) {
                            Channel chl = new Channel();
                            chl.index = Integer.parseInt(index_str);
                            chl.frequency = Integer.parseInt(freq_str);
                            chl.name = name;
                            channels.addElement(chl);
                            continue;
                        }
                        Alert al = new Alert("Test", index_str + "\r" + freq_str + "\r" + name, null, AlertType.ERROR);
                        RadioMidlet.getDisplay().setCurrent((Displayable)al);
                    }
                    RadioChannels.save();
                    return true;
                }
            }
            catch (Exception e) {
                RadioMidlet.error(e);
            }
        }
        return false;
    }

    public static Channel getChannelByFreq(int freq) {
        try {
            if (channels != null) {
                Enumeration en = channels.elements();
                while (en.hasMoreElements()) {
                    Channel ch = (Channel)en.nextElement();
                    if (ch.frequency != freq) continue;
                    return ch;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Channel getChannelByIndex(int index) {
        try {
            if (channels != null) {
                Enumeration en = channels.elements();
                while (en.hasMoreElements()) {
                    Channel ch = (Channel)en.nextElement();
                    if (ch.index != index) continue;
                    return ch;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static void addChannel(Channel ca) {
        channels.addElement(ca);
        RadioChannels.save();
    }

    public static void delChannel(Channel ca) {
        channels.removeElement(ca);
        channelIndx = 0;
        RadioChannels.save();
    }

    public static void editChannel(Channel ca) {
        RadioChannels.save();
    }

    public static boolean hasData() {
        return channels != null && channels.size() > 0;
    }

    public static Channel nextChannel() {
        channelIndx = channelIndx < channels.size() - 1 ? ++channelIndx : 0;
        return (Channel)channels.elementAt(channelIndx);
    }

    public static Channel prevChannel() {
        channelIndx = channelIndx > 0 ? --channelIndx : channels.size() - 1;
        return (Channel)channels.elementAt(channelIndx);
    }

    public static Channel[] getChannelList() {
        if (RadioChannels.hasData()) {
            Channel[] ret = new Channel[channels.size()];
            Enumeration en = channels.elements();
            int r = 0;
            while (en.hasMoreElements()) {
                ret[r++] = (Channel)en.nextElement();
            }
            return ret;
        }
        return null;
    }
}

