/*
 * Decompiled with CFR 0.152.
 */
package radio.channels;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import radio.channels.Channel;
import storage.RDSStorage;

public class ChannelStorage
extends RDSStorage {
    private Vector channels = new Vector();

    public ChannelStorage() {
        super("FreqStore");
    }

    public void load() {
        this.channels.removeAllElements();
        super.load();
    }

    public void parceData(DataInputStream data_in) throws IOException {
        Channel ca = new Channel();
        ca.index = data_in.readInt();
        ca.frequency = data_in.readInt();
        ca.name = data_in.readUTF();
        this.channels.addElement(ca);
    }

    public void save() {
        if (this.channels != null && this.channels.size() == 0) {
            return;
        }
        super.save();
    }

    public void saveData(RecordStore store) {
        DataOutputStream dos = null;
        Enumeration enu = this.channels.elements();
        while (enu.hasMoreElements()) {
            Channel ch = (Channel)enu.nextElement();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            try {
                dos.writeInt(ch.index);
                dos.writeInt(ch.frequency);
                dos.writeUTF(ch.name);
                byte[] dd = baos.toByteArray();
                store.addRecord(dd, 0, dd.length);
                baos.close();
                dos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Vector getChannels() {
        return this.channels;
    }

    public void setChannels(Vector channels) {
        this.channels = channels;
    }
}

