/*
 * Decompiled with CFR 0.152.
 */
package radio;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import radio.channels.RadioChannels;
import radio.gui.ChannelForm;
import radio.gui.GuiResource;
import radio.gui.RadioCanvas;
import radio.gui.RefreshDynamicTask;
import radio.gui.WaitThread;
import radio.gui.settings.Settings;
import radio.hardware.RadioHardware;
import resource.LanguageManager;

public class RadioMidlet
extends MIDlet {
    public static final int NONE = 0;
    public static final int OK = 1;
    public static final int PHOTO = 2;
    public static final int PHONE = 4;
    public static final int MENU = 5;
    public static final int ZOOM = 6;
    public static final int PLAY = 7;
    public static final int PAUSE = 8;
    public static final int CALC = 9;
    private static RadioMidlet radioMidlet = null;
    private static Display display = null;
    private static RadioCanvas rc = null;
    private Timer tt;
    private boolean paused = false;
    private boolean inited = false;

    protected void startApp() throws MIDletStateChangeException {
        radioMidlet = this;
        if (display == null) {
            display = Display.getDisplay((MIDlet)this);
        }
        if (!this.inited) {
            LanguageManager.init();
            GuiResource.initResource();
            Settings.init();
            System.gc();
            System.gc();
            System.gc();
            try {
                RadioHardware.init();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                RadioChannels.init();
                ChannelForm.init();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        try {
            if (rc == null) {
                rc = new RadioCanvas();
                display.setCurrent((Displayable)rc);
                this.tt = new Timer();
                RefreshDynamicTask dt = new RefreshDynamicTask();
                this.tt.scheduleAtFixedRate((TimerTask)dt, 30000L, 30000L);
            } else {
                rc.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.inited = true;
    }

    protected void pauseApp() {
        this.paused = true;
    }

    protected void destroyApp(boolean b) throws MIDletStateChangeException {
        RadioHardware.close();
    }

    public static void redraw() {
        rc.repaint();
    }

    public static void resetDisplay() {
        RadioMidlet.setDisplayable((Displayable)rc);
    }

    public static void setDisplayable(Displayable d) {
        display.setCurrent(d);
    }

    public static void wait(int period) throws InterruptedException {
        WaitThread th = new WaitThread();
        th.waitFor(period);
    }

    public static void error(Exception e) {
        display.setCurrent((Displayable)new Alert("Error", e.getMessage() + "\r" + e, null, AlertType.ERROR));
        try {
            RadioMidlet.wait(1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exit() {
        try {
            radioMidlet.destroyApp(true);
            radioMidlet.notifyDestroyed();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void exec(String s) {
        try {
            radioMidlet.platformRequest(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void light() {
        display.flashBacklight(5000);
    }

    public static Display getDisplay() {
        return display;
    }
}

