/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ScrolledItem;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class CanvasLister {
    private static final int OUTLINE_COLOR = 0x8F8F8F;
    private static final int FONT_COLOR = 0xF0F0F0;
    public static final int BACK_COLOR = 0;
    private String[] items = null;
    private boolean[] is_scrolled_items = null;
    private String[] constant_items = null;
    private ScrolledItem[] scrolled_items = null;
    private int index = -1;
    private int x = -1;
    private int y = -1;
    private int width = -1;
    private int height = -1;
    private Font font = null;
    private boolean is_init = false;
    private boolean is_draw = false;
    private int item_height = -1;
    private int items_per_one_window = -1;
    private int start_indx = -1;
    private int end_indx = -1;
    private int[] items_width = null;
    private int color_frame = 0x8F8F8F;
    private int color_back = 0;
    private int color_font = 0xF0F0F0;
    private int color_selected_font = 986895;

    public CanvasLister(String[] items) {
        this.items = items;
    }

    public String[] getItems() {
        return this.items;
    }

    public void setItems(String[] items) {
        this.items = items;
        this.init();
    }

    public int getIndex() {
        return this.index;
    }

    private void upd_position() {
        int half_window = this.items_per_one_window / 2;
        if (this.index == 0) {
            this.start_indx = 0;
            this.end_indx = this.items_per_one_window;
        } else if (this.index > half_window) {
            if (this.items.length - this.index > half_window) {
                this.start_indx = this.index - half_window;
                this.end_indx = this.index + half_window;
            } else {
                this.end_indx = this.items.length;
                this.start_indx = this.end_indx - this.items_per_one_window;
            }
        }
        if (this.start_indx < 0) {
            this.start_indx = 0;
        }
        if (this.end_indx > this.items.length) {
            this.end_indx = this.items.length;
        }
    }

    public void setIndex(int index) {
        this.index = index;
        this.upd_position();
    }

    public void up() {
        this.index = this.index != 0 ? --this.index : this.items.length - 1;
        this.upd_position();
    }

    public void down() {
        this.index = this.index != this.items.length - 1 ? ++this.index : 0;
        this.upd_position();
    }

    public void setWindow(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.init();
        if (this.is_draw) {
            this.is_init = true;
        }
    }

    private String cutString(String s) {
        for (int i = s.length(); i > 0; --i) {
            if (this.font.substringWidth(s, 0, i) >= this.width - 10) continue;
            return s.substring(0, i);
        }
        return s;
    }

    private void init() {
        if (this.x == -1) {
            return;
        }
        if (this.items != null && this.font != null) {
            this.item_height = this.font.getHeight() + 3;
            this.items_width = new int[this.items.length];
            this.is_scrolled_items = new boolean[this.items.length];
            for (int i = 0; i < this.items.length; ++i) {
                String item = this.items[i];
                if (item == null) continue;
                this.items_width[i] = this.font.stringWidth(item);
                int rm = item.indexOf(62);
                if (rm == -1) {
                    if (this.items_width[i] > this.width) {
                        this.items[i] = this.cutString(item);
                    }
                    this.is_scrolled_items[i] = false;
                    continue;
                }
                if (this.constant_items == null) {
                    this.constant_items = new String[this.items.length];
                }
                if (this.scrolled_items == null) {
                    this.scrolled_items = new ScrolledItem[this.items.length];
                }
                this.is_scrolled_items[i] = true;
                this.constant_items[i] = item.substring(0, rm);
                int constant_leng = this.font.stringWidth(this.constant_items[i]);
                ScrolledItem si = new ScrolledItem(item.substring(rm + 1));
                int scrollable_max_leng = this.width - constant_leng;
                si.x_pos = constant_leng;
                si.max_left_char = this.getCharCut(si.text, scrollable_max_leng);
                if (si.max_left_char > 0) {
                    ++si.max_left_char;
                }
                si.max_len_in_char = si.text.length() - si.max_left_char;
                si.time = -1L;
                si.curr_char = 0;
                this.scrolled_items[i] = si;
            }
            this.items_per_one_window = this.height / this.item_height;
            this.setIndex(0);
            this.is_draw = true;
        } else {
            this.is_draw = false;
        }
    }

    private int getCharCut(String text, int scrollable_max_leng) {
        for (int i = 0; i < text.length(); ++i) {
            if (this.font.stringWidth(text.substring(i)) >= scrollable_max_leng) continue;
            return i;
        }
        return 0;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setDecoration(int color_frame, int color_font, int color_back) {
        this.color_frame = color_frame;
        this.color_back = color_back;
        this.color_font = color_font;
        this.color_selected_font = color_font ^ 0xFFFFFF;
    }

    public void paint(Graphics g) {
        if (!this.is_init) {
            this.x = 0;
            this.y = 0;
            this.height = g.getClipHeight();
            this.width = g.getClipWidth();
            this.font = g.getFont();
            this.init();
            if (this.is_draw) {
                this.is_init = true;
            }
        }
        if (!this.is_draw) {
            return;
        }
        int t_color = g.getColor();
        g.setColor(this.color_back);
        g.fillRect(this.x, this.y, this.width, this.height);
        g.setColor(this.color_frame);
        g.drawRect(this.x, this.y, this.width, this.height);
        g.drawRect(this.x + 1, this.y + 1, this.width - 1, this.height - 1);
        g.setColor(this.color_font);
        for (int i = this.start_indx; i < this.end_indx; ++i) {
            int r = i - this.start_indx;
            if (i != this.index) {
                g.drawString(this.getTextItem(i), this.x + 5, this.y + this.item_height * r, 20);
                continue;
            }
            g.fillRect(this.x, this.y + this.item_height * r, this.width, this.item_height);
            g.setColor(this.color_selected_font);
            g.drawString(this.getTextItem(i, true), this.x + 5, this.y + this.item_height * r, 20);
            g.setColor(this.color_font);
        }
        g.setColor(t_color);
    }

    private String getTextItem(int index) {
        return this.getTextItem(index, false);
    }

    private String getTextItem(int index, boolean selected) {
        if (this.is_scrolled_items[index]) {
            String part = this.constant_items[index];
            ScrolledItem si = this.scrolled_items[index];
            if (si.max_left_char == 0) {
                return part + si.text;
            }
            if (!selected) {
                return part + si.text.substring(0, si.max_len_in_char - 2) + "...";
            }
            if (System.currentTimeMillis() - si.time > 200L) {
                ++si.curr_char;
                if (si.curr_char > si.max_left_char) {
                    si.curr_char = 0;
                }
            }
            return part + si.text.substring(si.curr_char, si.curr_char + si.max_len_in_char);
        }
        return this.items[index];
    }
}

