/*
 * Decompiled with CFR 0.152.
 */
package file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Image;
import radio.RadioMidlet;

public class FileProcessor {
    private static final String[] siemens_roots = new String[]{"0:/", "4:/"};

    public static String[] listRoots() {
        return siemens_roots;
    }

    public static String[] listFiles(String dir) {
        return FileProcessor.listFiles(dir, "*", false);
    }

    public static String[] listFiles(String dir, String mask, boolean include_path) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + dir), (int)1);
            String[] filesList = null;
            if (fc.isDirectory()) {
                Enumeration en = fc.list(mask, true);
                Vector vc = new Vector();
                if (en != null) {
                    while (en.hasMoreElements()) {
                        vc.addElement(en.nextElement());
                    }
                    filesList = new String[vc.size()];
                    for (int i = 0; i < filesList.length; ++i) {
                        filesList[i] = include_path ? dir + (String)vc.elementAt(i) : (String)vc.elementAt(i);
                    }
                }
            }
            fc.close();
            return filesList;
        }
        catch (IOException e) {
            FileProcessor.raiseError(e);
            return null;
        }
    }

    public static byte[] readFile(String file) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + file), (int)1);
            byte[] data = null;
            if (!fc.isDirectory()) {
                data = new byte[(int)fc.fileSize()];
                InputStream is = fc.openInputStream();
                is.read(data);
                is.close();
            }
            fc.close();
            return data;
        }
        catch (IOException e) {
            FileProcessor.raiseError(e);
            return null;
        }
    }

    private static void raiseError(Exception e) {
        RadioMidlet.error(e);
    }

    public static Image getImage(String file) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + file), (int)1);
            Image retImage = null;
            if (!fc.isDirectory()) {
                InputStream is = fc.openInputStream();
                retImage = Image.createImage((InputStream)is);
            }
            fc.close();
            return retImage;
        }
        catch (IOException e) {
            FileProcessor.raiseError(e);
            return null;
        }
    }

    public static void write(String filename, byte[] data) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + filename), (int)3);
            if (!fc.isDirectory()) {
                if (fc.exists()) {
                    fc.delete();
                }
                fc.create();
                OutputStream os = fc.openOutputStream();
                os.write(data);
            }
            fc.close();
        }
        catch (IOException e) {
            FileProcessor.raiseError(e);
        }
    }
}

