/*
 * Decompiled with CFR 0.152.
 */
package file;

import file.FileProcessor;
import file.FileThread;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import resource.LangFireChange;
import resource.LanguageManager;

public abstract class FileBrowser
extends List
implements CommandListener,
LangFireChange {
    String[] currentDir = null;
    int dir_indx = -1;
    Command selectCommand = null;
    Command backCommand = null;
    FileThread ft = null;
    private String filter = null;

    public FileBrowser(String caption) {
        super(caption, 3);
        this.init();
        this.setCommandListener(this);
        this.setFitPolicy(1);
        this.redraw();
        this.ft = new FileThread(this);
        this.ft.start();
    }

    void redraw() {
        this.deleteAll();
        if (this.dir_indx == -1) {
            String[] roots = FileProcessor.listRoots();
            for (int i = 0; i < roots.length; ++i) {
                String root = roots[i];
                this.append(root, null);
            }
        } else {
            String[] files = FileProcessor.listFiles(this.currentDir[this.dir_indx]);
            for (int i = 0; i < files.length; ++i) {
                String file = files[i];
                if (this.filter == null) {
                    this.append(file, null);
                    continue;
                }
                if (this.isFile(file)) {
                    if (file.indexOf(this.filter) == -1) continue;
                    this.append(file, null);
                    continue;
                }
                this.append(file, null);
            }
        }
    }

    public void init() {
        this.currentDir = new String[20];
        this.dir_indx = -1;
        this.initLang();
    }

    public void initLang() {
        if (this.selectCommand != null) {
            this.removeCommand(this.selectCommand);
        }
        if (this.backCommand != null) {
            this.removeCommand(this.backCommand);
        }
        this.selectCommand = new Command(LanguageManager.getResource("select"), 4, 1);
        this.backCommand = new Command(LanguageManager.getResource("back"), 2, 2);
        this.addCommand(this.selectCommand);
        this.addCommand(this.backCommand);
        this.setSelectCommand(this.selectCommand);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.selectCommand) {
            if (this.getSelectedIndex() != -1) {
                String dir = this.getString(this.getSelectedIndex());
                if (this.isFile(dir)) {
                    this.selectFile(this.currentDir[this.dir_indx] + dir);
                } else {
                    if (this.dir_indx == -1) {
                        this.dir_indx = 0;
                        this.currentDir[0] = dir;
                    } else {
                        this.currentDir[this.dir_indx + 1] = this.currentDir[this.dir_indx] + dir;
                        ++this.dir_indx;
                    }
                    this.redraw();
                }
            }
        } else if (command == this.backCommand) {
            if (this.dir_indx == -1) {
                this.exit();
            }
            if (this.dir_indx != -1) {
                --this.dir_indx;
            }
            this.redraw();
        }
    }

    public abstract void exit();

    private boolean isFile(String dir) {
        return dir.indexOf(46) != -1;
    }

    public void langChanged() {
        this.initLang();
    }

    public void reset() {
        this.dir_indx = -1;
        this.filter = null;
        this.redraw();
    }

    public void setFilter(String s) {
        this.filter = s;
    }

    public abstract void selectFile(String var1);
}

