/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.midlet.MIDlet;

public class MobileMap
extends MIDlet {
    static final Command QUIT_CMD = new Command("\u0412\u044b\u0445\u043e\u0434", 2, 2);
    static final Command BACK_CMD = new Command("\u041d\u0430\u0437\u0430\u0434", 2, 2);
    static final Command SEARCH_CMD = new Command("\u041f\u043e\u0438\u0441\u043a", 1, 1);
    static final Command DISTRICT_CMD = new Command("\u0420\u0430\u0439\u043e\u043d\u043d\u044b\u0435 \u0446\u0435\u043d\u0442\u0440\u044b", 1, 1);
    static final Command SELECT_CMD = new Command("\u0412\u044b\u0431\u0440\u0430\u0442\u044c", 1, 1);
    static final Command ZOOM_IN_CMD = new Command("\u0423\u0432\u0435\u043b\u0438\u0447\u0438\u0442\u044c", 1, 2);
    static final Command ZOOM_OUT_CMD = new Command("\u0423\u043c\u0435\u043d\u044c\u0448\u0438\u0442\u044c", 1, 2);
    static final Command RESET_CMD = new Command("\u041e\u0431\u0449\u0438\u0439 \u043f\u043b\u0430\u043d", 1, 2);
    static final Command HELP_CMD = new Command("\u041f\u043e\u043c\u043e\u0449\u044c", 1, 3);
    static final Command ABOUT_CMD = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 1, 4);
    static final String MAP_FILE = "/city";
    static final String MAP_FILE_STR = "/str.map";
    static final int CELL_BITS = 3;
    static final int N_CELLS = 8;
    int nLevels;
    int[] nLevelStreets;
    Street[] streets;
    Segment[][][] cells;

    String toLowerCaseRUS(String prefix) {
        char[] str = prefix.toCharArray();
        for (int i = 0; i < str.length; ++i) {
            if (str[i] < '\u0410' || str[i] > '\u042f') continue;
            str[i] = (char)(str[i] + 32);
        }
        return String.valueOf(str);
    }

    int findStreet(String prefix) {
        int l = 0;
        int r = this.streets.length;
        while (l < r) {
            int m = Math.abs((l + r) / 2);
            if (prefix.compareTo(this.streets[m].name) > 0) {
                l = m + 1;
                continue;
            }
            r = m;
        }
        return r;
    }

    public MobileMap() throws Exception {
        int j;
        int i;
        DataInputStream in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(MAP_FILE_STR));
        int nStreets = in.readShort();
        this.streets = new Street[nStreets];
        for (i = 0; i < nStreets; ++i) {
            Street street = new Street();
            street.segments = new Segment[in.readShort()];
            int len = in.readByte();
            byte[] name = new byte[len];
            for (j = 0; j < len; ++j) {
                name[j] = in.readByte();
            }
            byte TpLine = in.readByte();
            street.name = this.toLowerCaseRUS(Locale.decodeString(name));
            street.TypeLine = TpLine;
            this.streets[i] = street;
        }
        this.cells = new Segment[8][8][];
        for (i = 0; i < 8; ++i) {
            for (int j2 = 0; j2 < 8; ++j2) {
                this.cells[i][j2] = new Segment[in.readShort()];
            }
        }
        this.nLevels = in.readByte();
        this.nLevelStreets = new int[this.nLevels];
        int[][] cellPos = new int[8][8];
        short[] segmentPos = new short[nStreets];
        for (int i2 = 0; i2 < this.nLevels; ++i2) {
            in.close();
            in = new DataInputStream(((Object)((Object)this)).getClass().getResourceAsStream(MAP_FILE + i2 + ".map"));
            short nSegments = in.readShort();
            this.nLevelStreets[i2] = nSegments;
            for (j = 0; j < nSegments; ++j) {
                Segment s = new Segment();
                short s2 = s.streetIndex = in.readShort();
                short s3 = segmentPos[s2];
                segmentPos[s2] = (short)(s3 + 1);
                this.streets[s.streetIndex].segments[s3] = s;
                s.level = (byte)i2;
                int nPoints = in.readByte() & 0xFF;
                s.x = new short[nPoints];
                s.y = new short[nPoints];
                int minX = Integer.MAX_VALUE;
                int minY = Integer.MAX_VALUE;
                int maxX = Integer.MIN_VALUE;
                int maxY = Integer.MIN_VALUE;
                for (int k = 0; k < nPoints; ++k) {
                    int x = in.readShort() & 0xFFFF;
                    int y = in.readShort() & 0xFFFF;
                    if (x < minX) {
                        minX = x;
                    }
                    if (x > maxX) {
                        maxX = x;
                    }
                    if (y < minY) {
                        minY = y;
                    }
                    if (y > maxY) {
                        maxY = y;
                    }
                    s.x[k] = (short)x;
                    s.y[k] = (short)y;
                }
                maxX >>>= 13;
                minY >>>= 13;
                maxY >>>= 13;
                for (int cx = minX >>>= 13; cx <= maxX; ++cx) {
                    for (int cy = minY; cy <= maxY; ++cy) {
                        int[] nArray = cellPos[cx];
                        int n = cy;
                        int n2 = nArray[n];
                        nArray[n] = n2 + 1;
                        this.cells[cx][cy][n2] = s;
                    }
                }
            }
        }
    }

    protected void destroyApp(boolean unconditional) {
    }

    protected void pauseApp() {
    }

    protected void startApp() {
        new MapCanvas(this);
    }

    public void quit() {
        this.destroyApp(true);
        this.notifyDestroyed();
    }
}

