/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import java.io.IOException;
import telnet.Dimension;

public abstract class TelnetProtocolHandler {
    private byte[] tempbuf = new byte[0];
    private byte[] crlf = new byte[2];
    private byte[] cr = new byte[2];
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte TELOPT_BINARY = 0;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_SGA = 3;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;

    public TelnetProtocolHandler() {
        this.reset();
        this.crlf[0] = 13;
        this.crlf[1] = 10;
        this.cr[0] = 13;
        this.cr[1] = 0;
    }

    protected abstract String getTerminalType();

    protected abstract Dimension getWindowSize();

    protected abstract void setLocalEcho(boolean var1);

    protected abstract void notifyEndOfRecord();

    protected abstract void write(byte[] var1) throws IOException;

    public void reset() {
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
    }

    public void sendTelnetControl(byte by) throws IOException {
        byte[] byArray = new byte[]{-1, by};
        this.write(byArray);
    }

    private void handle_sb(byte by, byte[] byArray, int n) throws IOException {
        switch (by) {
            case 24: {
                if (n <= 0 || byArray[0] != 1) break;
                this.write(new byte[]{-1, -6, 24, 0});
                String string = this.getTerminalType();
                this.write(string.getBytes());
                this.write(IACSE);
            }
        }
    }

    public void startup() throws IOException {
    }

    public void transpose(byte[] byArray) throws IOException {
        byte[] byArray2;
        int n = 0;
        byte[] byArray3 = new byte[byArray.length * 2];
        int n2 = 0;
        while (n2 < byArray.length) {
            switch (byArray[n2]) {
                case -1: {
                    byArray3[n++] = -1;
                    byArray3[n++] = -1;
                    break;
                }
                case 10: {
                    int n3;
                    if (this.receivedDX[128] != -3) {
                        while (byArray3.length - n < this.crlf.length) {
                            byArray2 = new byte[byArray3.length * 2];
                            System.arraycopy(byArray3, 0, byArray2, 0, n);
                            byArray3 = byArray2;
                        }
                        n3 = 0;
                        while (n3 < this.crlf.length) {
                            byArray3[n++] = this.crlf[n3];
                            ++n3;
                        }
                        break;
                    }
                    byArray3[n++] = byArray[n2];
                    break;
                }
                case 13: {
                    int n3;
                    if (this.receivedDX[128] != -3) {
                        while (byArray3.length - n < this.cr.length) {
                            byArray2 = new byte[byArray3.length * 2];
                            System.arraycopy(byArray3, 0, byArray2, 0, n);
                            byArray3 = byArray2;
                        }
                        n3 = 0;
                        while (n3 < this.cr.length) {
                            byArray3[n++] = this.cr[n3];
                            ++n3;
                        }
                        break;
                    }
                    byArray3[n++] = byArray[n2];
                    break;
                }
                default: {
                    byArray3[n++] = byArray[n2];
                }
            }
            ++n2;
        }
        byArray2 = new byte[n];
        System.arraycopy(byArray3, 0, byArray2, 0, n);
        this.write(byArray2);
    }

    public void setCRLF(String string) {
        this.crlf = string.getBytes();
    }

    public void setCR(String string) {
        this.cr = string.getBytes();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public int negotiate(byte[] var1_1) throws IOException {
        var2_2 = new byte[this.tempbuf.length];
        var3_3 = this.tempbuf.length;
        var4_4 = this.tempbuf;
        var5_5 = new byte[3];
        var8_6 = 0;
        var9_7 = 0;
        var10_8 = 0;
        var11_9 = false;
        if (var3_3 != 0) ** GOTO lbl210
        return -1;
lbl-1000:
        // 1 sources

        {
            if ((var6_10 = var4_4[var9_7++]) >= 128) {
                var6_10 = (byte)(var6_10 - 256);
            }
            block0 : switch (this.neg_state) {
                case 0: {
                    if (var6_10 == -1) {
                        this.neg_state = 1;
                        var11_9 = true;
                        break;
                    }
                    var1_1[var10_8++] = var6_10;
                    break;
                }
                case 1: {
                    switch (var6_10) {
                        case -1: {
                            this.neg_state = 0;
                            var1_1[var10_8++] = -1;
                            break block0;
                        }
                        case -5: {
                            this.neg_state = (byte)3;
                            break block0;
                        }
                        case -4: {
                            this.neg_state = (byte)5;
                            break block0;
                        }
                        case -2: {
                            this.neg_state = (byte)6;
                            break block0;
                        }
                        case -3: {
                            this.neg_state = (byte)4;
                            break block0;
                        }
                        case -17: {
                            this.notifyEndOfRecord();
                            var11_9 = true;
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.neg_state = (byte)2;
                            var8_6 = 0;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                case 3: {
                    switch (var6_10) {
                        case 1: {
                            var7_11 = -3;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            var7_11 = -3;
                            break;
                        }
                        case 25: {
                            var7_11 = -3;
                            break;
                        }
                        case 0: {
                            var7_11 = -3;
                            break;
                        }
                        default: {
                            var7_11 = -2;
                        }
                    }
                    if (var7_11 != this.sentDX[var6_10 + 128] || -5 != this.receivedWX[var6_10 + 128]) {
                        var5_5[0] = -1;
                        var5_5[1] = var7_11;
                        var5_5[2] = var6_10;
                        this.write(var5_5);
                        this.sentDX[var6_10 + 128] = var7_11;
                        this.receivedWX[var6_10 + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 5: {
                    switch (var6_10) {
                        case 1: {
                            this.setLocalEcho(true);
                            var7_11 = -2;
                            break;
                        }
                        case 3: {
                            var7_11 = -2;
                            break;
                        }
                        case 25: {
                            var7_11 = -2;
                            break;
                        }
                        case 0: {
                            var7_11 = -2;
                            break;
                        }
                        default: {
                            var7_11 = -2;
                        }
                    }
                    if (var7_11 != this.sentDX[var6_10 + 128] || -4 != this.receivedWX[var6_10 + 128]) {
                        var5_5[0] = -1;
                        var5_5[1] = var7_11;
                        var5_5[2] = var6_10;
                        this.write(var5_5);
                        this.sentDX[var6_10 + 128] = var7_11;
                        this.receivedWX[var6_10 + 128] = -5;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 4: {
                    switch (var6_10) {
                        case 1: {
                            var7_11 = -5;
                            this.setLocalEcho(true);
                            break;
                        }
                        case 3: {
                            var7_11 = -5;
                            break;
                        }
                        case 24: {
                            var7_11 = -5;
                            break;
                        }
                        case 0: {
                            var7_11 = -5;
                            break;
                        }
                        case 31: {
                            var12_12 /* !! */  = (byte[])this.getWindowSize();
                            this.receivedDX[var6_10] = -3;
                            if (var12_12 /* !! */  == null) {
                                this.write(new byte[]{-1, -4, 31});
                                var7_11 = -4;
                                this.sentWX[var6_10] = -4;
                                break;
                            }
                            var7_11 = -5;
                            this.sentWX[var6_10] = -5;
                            var5_5[0] = -1;
                            var5_5[1] = -5;
                            var5_5[2] = 31;
                            this.write(var5_5);
                            this.write(new byte[]{-1, -6, 31, (byte)(var12_12 /* !! */ .width >> 8), (byte)(var12_12 /* !! */ .width & 255), (byte)(var12_12 /* !! */ .height >> 8), (byte)(var12_12 /* !! */ .height & 255), -1, -16});
                            break;
                        }
                        default: {
                            var7_11 = -4;
                        }
                    }
                    if (var7_11 != this.sentWX[128 + var6_10] || -3 != this.receivedDX[128 + var6_10]) {
                        var5_5[0] = -1;
                        var5_5[1] = var7_11;
                        var5_5[2] = var6_10;
                        this.write(var5_5);
                        this.sentWX[var6_10 + 128] = var7_11;
                        this.receivedDX[var6_10 + 128] = -3;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 6: {
                    switch (var6_10) {
                        case 1: {
                            var7_11 = -4;
                            this.setLocalEcho(false);
                            break;
                        }
                        case 3: {
                            var7_11 = -4;
                            break;
                        }
                        case 31: {
                            var7_11 = -4;
                            break;
                        }
                        case 0: {
                            var7_11 = -4;
                            break;
                        }
                        default: {
                            var7_11 = -4;
                        }
                    }
                    if (var7_11 != this.sentWX[var6_10 + 128] || -2 != this.receivedDX[var6_10 + 128]) {
                        this.write(new byte[]{-1, var7_11, var6_10});
                        this.sentWX[var6_10 + 128] = var7_11;
                        this.receivedDX[var6_10 + 128] = -2;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 7: {
                    if (var6_10 == -1) {
                        var8_6 = 0;
                        this.current_sb = var6_10;
                        this.neg_state = (byte)8;
                        break;
                    }
                    this.neg_state = 0;
                    break;
                }
                case 2: {
                    switch (var6_10) {
                        case -1: {
                            this.neg_state = (byte)7;
                            break block0;
                        }
                    }
                    this.current_sb = var6_10;
                    var8_6 = 0;
                    this.neg_state = (byte)8;
                    break;
                }
                case 8: {
                    switch (var6_10) {
                        case -1: {
                            this.neg_state = (byte)9;
                            break block0;
                        }
                    }
                    var2_2[var8_6++] = var6_10;
                    break;
                }
                case 9: {
                    switch (var6_10) {
                        case -1: {
                            this.neg_state = (byte)8;
                            var2_2[var8_6++] = -1;
                            break block0;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, var2_2, var8_6);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            break block0;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, var2_2, var8_6);
                            this.neg_state = (byte)2;
                            break block0;
                        }
                    }
                    this.neg_state = 0;
                    break;
                }
                default: {
                    this.neg_state = 0;
                }
            }
lbl210:
            // 26 sources

            ** while (!var11_9 && var9_7 < var3_3 && var10_8 < var1_1.length)
        }
lbl211:
        // 1 sources

        var12_12 /* !! */  = new byte[var3_3 - var9_7];
        System.arraycopy(this.tempbuf, var9_7, var12_12 /* !! */ , 0, var3_3 - var9_7);
        this.tempbuf = var12_12 /* !! */ ;
        return var10_8;
    }

    public void inputfeed(byte[] byArray, int n) {
        byte[] byArray2 = new byte[this.tempbuf.length + n];
        System.arraycopy(this.tempbuf, 0, byArray2, 0, this.tempbuf.length);
        System.arraycopy(byArray, 0, byArray2, this.tempbuf.length, n);
        this.tempbuf = byArray2;
    }
}

