/*
 * Decompiled with CFR 0.152.
 */
package telnet;

import telnet.KeyEvent;
import telnet.VDUBuffer;

public abstract class vt320
extends VDUBuffer {
    public static final int KEY_CONTROL = 1;
    public static final int KEY_SHIFT = 2;
    public static final int KEY_ALT = 4;
    public static final int KEY_ACTION = 8;
    public boolean localecho = false;
    private String terminalID = "vt320";
    private String answerBack = "Use Terminal.answerback to set ...\n";
    public int R;
    public int C;
    int attributes = 0;
    int Sc;
    int Sr;
    int Sa;
    int Stm;
    int Sbm;
    char Sgr;
    char Sgl;
    char[] Sgx;
    int insertmode = 0;
    int statusmode = 0;
    boolean vt52mode = false;
    boolean keypadmode = false;
    boolean output8bit = false;
    int normalcursor = 0;
    boolean moveoutsidemargins = true;
    boolean wraparound = true;
    boolean sendcrlf = true;
    boolean capslock = false;
    boolean numlock = false;
    int mouserpt = 0;
    byte mousebut = 0;
    boolean useibmcharset = false;
    int lastwaslf = 0;
    boolean usedcharsets = false;
    private static final char ESC = '\u001b';
    private static final char IND = '\u0084';
    private static final char NEL = '\u0085';
    private static final char RI = '\u008d';
    private static final char SS2 = '\u008e';
    private static final char SS3 = '\u008f';
    private static final char DCS = '\u0090';
    private static final char HTS = '\u0088';
    private static final char CSI = '\u009b';
    private static final char OSC = '\u009d';
    private static final int TSTATE_DATA = 0;
    private static final int TSTATE_ESC = 1;
    private static final int TSTATE_CSI = 2;
    private static final int TSTATE_DCS = 3;
    private static final int TSTATE_DCEQ = 4;
    private static final int TSTATE_ESCSQUARE = 5;
    private static final int TSTATE_OSC = 6;
    private static final int TSTATE_SETG0 = 7;
    private static final int TSTATE_SETG1 = 8;
    private static final int TSTATE_SETG2 = 9;
    private static final int TSTATE_SETG3 = 10;
    private static final int TSTATE_CSI_DOLLAR = 11;
    private static final int TSTATE_CSI_EX = 12;
    private static final int TSTATE_ESCSPACE = 13;
    private static final int TSTATE_VT52X = 14;
    private static final int TSTATE_VT52Y = 15;
    private static final int TSTATE_CSI_TICKS = 16;
    char[] gx = new char[]{'B', '0', 'B', 'B'};
    char gl = '\u0000';
    char gr = (char)2;
    int onegl = -1;
    private static final String scoansi_acs = "Tm7k3x4u?kZl@mYjEnB\u2566DqCtAvM\u2550:\u2551N\u2557I\u2554;\u2557H\u255a0a<\u255d";
    private static char[] DECSPECIAL = new char[]{'@', '\u2666', '\u2592', '\u2409', '\u240c', '\u240d', '\u240a', '\u00ba', '\u00b1', '\u2424', '\u240b', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '\u2594', '\u2580', '\u2500', '\u25ac', '_', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265', '\u00b6', '\u2260', '\u00a3', '\u00b7'};
    private String[] Numpad;
    private String[] FunctionKey;
    private String[] FunctionKeyShift;
    private String[] FunctionKeyCtrl;
    private String[] FunctionKeyAlt;
    private String[] TabKey;
    private String[] KeyUp;
    private String[] KeyDown;
    private String[] KeyLeft;
    private String[] KeyRight;
    private String KPMinus;
    private String KPComma;
    private String KPPeriod;
    private String KPEnter;
    private String PF1;
    private String PF2;
    private String PF3;
    private String PF4;
    private String Help;
    private String Do;
    private String Find;
    private String Select;
    private String[] KeyHome;
    private String[] KeyEnd;
    private String[] Insert;
    private String[] Remove;
    private String[] PrevScn;
    private String[] NextScn;
    private String[] Escape;
    private String[] BackSpace;
    private String[] NUMDot;
    private String[] NUMPlus;
    private String osc;
    private String dcs;
    private int term_state = 0;
    private boolean vms = false;
    private byte[] Tabs;
    private int[] DCEvars = new int[30];
    private int DCEvar;
    private static final char[] unimap = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00a2', '\u00a3', '\u00a5', '\u20a7', '\u0192', '\u00e1', '\u00ed', '\u00f3', '\u00fa', '\u00f1', '\u00d1', '\u00aa', '\u00ba', '\u00bf', '\u2310', '\u00ac', '\u00bd', '\u00bc', '\u00a1', '\u00ab', '\u00bb', '\u2591', '\u2592', '\u2593', '\u2502', '\u2524', '\u2561', '\u2562', '\u2556', '\u2555', '\u2563', '\u2551', '\u2557', '\u255d', '\u255c', '\u255b', '\u2510', '\u2514', '\u2534', '\u252c', '\u251c', '\u2500', '\u253c', '\u255e', '\u255f', '\u255a', '\u2554', '\u2569', '\u2566', '\u2560', '\u2550', '\u256c', '\u2567', '\u2568', '\u2564', '\u2565', '\u2559', '\u2558', '\u2552', '\u2553', '\u256b', '\u256a', '\u2518', '\u250c', '\u2588', '\u2584', '\u258c', '\u2590', '\u2580', '\u03b1', '\u00df', '\u0393', '\u03c0', '\u03a3', '\u03c3', '\u00b5', '\u03c4', '\u03a6', '\u0398', '\u03a9', '\u03b4', '\u221e', '\u03c6', '\u03b5', '\u2229', '\u2261', '\u00b1', '\u2265', '\u2264', '\u2320', '\u2321', '\u00f7', '\u2248', '\u00b0', '\u2219', '\u00b7', '\u221a', '\u207f', '\u00b2', '\u25a0', '\u00a0'};

    public abstract void write(byte[] var1);

    public void beep() {
    }

    public void putString(String string) {
        int n = string.length();
        if (n > 0) {
            this.markLine(this.R, 1);
            int n2 = 0;
            while (n2 < n) {
                this.putChar(string.charAt(n2), false);
                ++n2;
            }
            this.setCursorPosition(this.C, this.R);
            this.redraw();
        }
    }

    protected void sendTelnetCommand(byte by) {
    }

    public vt320(int n, int n2) {
        super(n, n2);
        this.setVMS(false);
        this.setIBMCharset(false);
        this.setBufferSize(n2);
        int n3 = this.getColumns();
        if (n3 < 132) {
            n3 = 132;
        }
        this.Tabs = new byte[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.Tabs[n4] = 1;
            n4 += 8;
        }
        this.PF1 = "\u001bOP";
        this.PF2 = "\u001bOQ";
        this.PF3 = "\u001bOR";
        this.PF4 = "\u001bOS";
        this.Insert = new String[4];
        this.Remove = new String[4];
        this.KeyHome = new String[4];
        this.KeyEnd = new String[4];
        this.NextScn = new String[4];
        this.PrevScn = new String[4];
        this.Escape = new String[4];
        this.BackSpace = new String[4];
        this.TabKey = new String[4];
        this.Insert[3] = "\u001b[2~";
        this.Insert[2] = "\u001b[2~";
        this.Insert[1] = "\u001b[2~";
        this.Insert[0] = "\u001b[2~";
        this.Remove[3] = "\u001b[3~";
        this.Remove[2] = "\u001b[3~";
        this.Remove[1] = "\u001b[3~";
        this.Remove[0] = "\u001b[3~";
        this.PrevScn[3] = "\u001b[5~";
        this.PrevScn[2] = "\u001b[5~";
        this.PrevScn[1] = "\u001b[5~";
        this.PrevScn[0] = "\u001b[5~";
        this.NextScn[3] = "\u001b[6~";
        this.NextScn[2] = "\u001b[6~";
        this.NextScn[1] = "\u001b[6~";
        this.NextScn[0] = "\u001b[6~";
        this.KeyHome[3] = "\u001b[H";
        this.KeyHome[2] = "\u001b[H";
        this.KeyHome[1] = "\u001b[H";
        this.KeyHome[0] = "\u001b[H";
        this.KeyEnd[3] = "\u001b[F";
        this.KeyEnd[2] = "\u001b[F";
        this.KeyEnd[1] = "\u001b[F";
        this.KeyEnd[0] = "\u001b[F";
        this.Escape[3] = "\u001b";
        this.Escape[2] = "\u001b";
        this.Escape[1] = "\u001b";
        this.Escape[0] = "\u001b";
        if (this.vms) {
            this.BackSpace[1] = "\n";
            this.BackSpace[2] = "\u0018";
            this.BackSpace[3] = "\u007f";
            this.BackSpace[0] = "\u007f";
        } else {
            this.BackSpace[3] = "\b";
            this.BackSpace[2] = "\b";
            this.BackSpace[1] = "\b";
            this.BackSpace[0] = "\b";
        }
        this.Find = "\u001b[1~";
        this.Select = "\u001b[4~";
        this.Help = "\u001b[28~";
        this.Do = "\u001b[29~";
        this.FunctionKey = new String[21];
        this.FunctionKey[0] = "";
        this.FunctionKey[1] = this.PF1;
        this.FunctionKey[2] = this.PF2;
        this.FunctionKey[3] = this.PF3;
        this.FunctionKey[4] = this.PF4;
        this.FunctionKey[5] = "\u001b[15~";
        this.FunctionKey[6] = "\u001b[17~";
        this.FunctionKey[7] = "\u001b[18~";
        this.FunctionKey[8] = "\u001b[19~";
        this.FunctionKey[9] = "\u001b[20~";
        this.FunctionKey[10] = "\u001b[21~";
        this.FunctionKey[11] = "\u001b[23~";
        this.FunctionKey[12] = "\u001b[24~";
        this.FunctionKey[13] = "\u001b[25~";
        this.FunctionKey[14] = "\u001b[26~";
        this.FunctionKey[15] = this.Help;
        this.FunctionKey[16] = this.Do;
        this.FunctionKey[17] = "\u001b[31~";
        this.FunctionKey[18] = "\u001b[32~";
        this.FunctionKey[19] = "\u001b[33~";
        this.FunctionKey[20] = "\u001b[34~";
        this.FunctionKeyShift = new String[21];
        this.FunctionKeyAlt = new String[21];
        this.FunctionKeyCtrl = new String[21];
        int n5 = 0;
        while (n5 < 20) {
            this.FunctionKeyShift[n5] = "";
            this.FunctionKeyAlt[n5] = "";
            this.FunctionKeyCtrl[n5] = "";
            ++n5;
        }
        this.FunctionKeyShift[15] = this.Find;
        this.FunctionKeyShift[16] = this.Select;
        this.TabKey[0] = "\t";
        this.TabKey[1] = "\u001bOP\t";
        this.TabKey[3] = "";
        this.TabKey[2] = "";
        this.KeyUp = new String[4];
        this.KeyUp[0] = "\u001b[A";
        this.KeyDown = new String[4];
        this.KeyDown[0] = "\u001b[B";
        this.KeyRight = new String[4];
        this.KeyRight[0] = "\u001b[C";
        this.KeyLeft = new String[4];
        this.KeyLeft[0] = "\u001b[D";
        this.Numpad = new String[10];
        this.Numpad[0] = "\u001bOp";
        this.Numpad[1] = "\u001bOq";
        this.Numpad[2] = "\u001bOr";
        this.Numpad[3] = "\u001bOs";
        this.Numpad[4] = "\u001bOt";
        this.Numpad[5] = "\u001bOu";
        this.Numpad[6] = "\u001bOv";
        this.Numpad[7] = "\u001bOw";
        this.Numpad[8] = "\u001bOx";
        this.Numpad[9] = "\u001bOy";
        this.KPMinus = this.PF4;
        this.KPComma = "\u001bOl";
        this.KPPeriod = "\u001bOn";
        this.KPEnter = "\u001bOM";
        this.NUMPlus = new String[4];
        this.NUMPlus[0] = "+";
        this.NUMDot = new String[4];
        this.NUMDot[0] = ".";
    }

    public vt320() {
        this(80, 24);
    }

    public void mousePressed(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = n3;
        this.mousebut = (byte)3;
        if ((n4 & 0x10) == 16) {
            this.mousebut = 0;
        }
        if ((n4 & 8) == 8) {
            this.mousebut = 1;
        }
        if ((n4 & 4) == 4) {
            this.mousebut = (byte)2;
        }
        int n5 = this.mouserpt == 9 ? 0x20 | this.mousebut : this.mousebut | 0x20 | (n4 & 7) << 2;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n5, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray);
    }

    public void mouseReleased(int n, int n2, int n3) {
        if (this.mouserpt == 0) {
            return;
        }
        int n4 = this.mouserpt == 9 ? 32 + this.mousebut : 35;
        byte[] byArray = new byte[]{27, 91, 77, (byte)n4, (byte)(32 + n + 1), (byte)(32 + n2 + 1)};
        this.write(byArray);
        this.mousebut = 0;
    }

    public void setLocalEcho(boolean bl) {
        this.localecho = bl;
    }

    public void setVMS(boolean bl) {
        this.vms = bl;
    }

    public void setIBMCharset(boolean bl) {
        this.useibmcharset = bl;
    }

    public void setTerminalID(String string) {
        this.terminalID = string;
    }

    public void setAnswerBack(String string) {
        this.answerBack = vt320.unEscape(string);
    }

    public String getTerminalID() {
        return this.terminalID;
    }

    private boolean write(String string, boolean bl) {
        if (string == null) {
            return true;
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < string.length()) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        this.write(byArray);
        if (bl) {
            this.putString(string);
        }
        return true;
    }

    private boolean write(String string) {
        return this.write(string, this.localecho);
    }

    /*
     * Unable to fully structure code
     */
    static String unEscape(String var0) {
        var1_1 = 0;
        var2_2 = 0;
        var3_3 = "";
        if (true) ** GOTO lbl43
        do {
            var3_3 = var3_3 + var0.substring(var2_2, var1_1 - 1);
            if (var1_1 == var0.length()) {
                return var3_3;
            }
            switch (var0.charAt(var1_1)) {
                case 'b': {
                    var3_3 = var3_3 + "\b";
                    break;
                }
                case 'e': {
                    var3_3 = var3_3 + "\u001b";
                    break;
                }
                case 'n': {
                    var3_3 = var3_3 + "\n";
                    break;
                }
                case 'r': {
                    var3_3 = var3_3 + "\r";
                    break;
                }
                case 't': {
                    var3_3 = var3_3 + "\t";
                    break;
                }
                case 'v': {
                    var3_3 = var3_3 + "\u000b";
                    break;
                }
                case 'a': {
                    var3_3 = var3_3 + "\u0012";
                    break;
                }
                default: {
                    if (var0.charAt(var1_1) >= '0' && var0.charAt(var1_1) <= '9') {
                        var4_4 = var1_1;
                        while (var4_4 < var0.length()) {
                            if (var0.charAt(var4_4) < '0' || var0.charAt(var4_4) > '9') break;
                            ++var4_4;
                        }
                        var3_3 = var3_3 + (char)Integer.parseInt(var0.substring(var1_1, var4_4));
                        var1_1 = var4_4 - 1;
                        break;
                    }
                    var3_3 = var3_3 + var0.substring(var1_1++, var1_1);
                }
            }
            var2_2 = ++var1_1;
lbl43:
            // 2 sources

            var1_1 = var0.indexOf(92, var2_2);
        } while (var1_1 >= 0 && ++var1_1 <= var0.length());
        if (var2_2 <= var0.length()) {
            var3_3 = var3_3 + var0.substring(var2_2);
        }
        return var3_3;
    }

    private boolean writeSpecial(String string) {
        if (string == null) {
            return true;
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == 'O') {
            if (this.vt52mode) {
                string = string.charAt(2) >= 'P' && string.charAt(2) <= 'S' ? "\u001b" + string.substring(2) : "\u001b?" + string.substring(2);
            } else if (this.output8bit) {
                string = "\u008f" + string.substring(2);
            }
        }
        if (string.length() >= 3 && string.charAt(0) == '\u001b' && string.charAt(1) == '[' && this.output8bit) {
            string = "\u009b" + string.substring(2);
        }
        return this.write(string, false);
    }

    public void keyPressed(int n, char c, int n2) {
        boolean bl = (n2 & 1) != 0;
        boolean bl2 = (n2 & 2) != 0;
        boolean bl3 = (n2 & 4) != 0;
        char c2 = c;
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl2) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl3) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        switch (n) {
            case 19: {
                if (!bl2 && !bl) break;
                this.sendTelnetCommand((byte)-13);
                break;
            }
            case 112: {
                this.writeSpecial(stringArray[1]);
                break;
            }
            case 113: {
                this.writeSpecial(stringArray[2]);
                break;
            }
            case 114: {
                this.writeSpecial(stringArray[3]);
                break;
            }
            case 115: {
                this.writeSpecial(stringArray[4]);
                break;
            }
            case 116: {
                this.writeSpecial(stringArray[5]);
                break;
            }
            case 117: {
                this.writeSpecial(stringArray[6]);
                break;
            }
            case 118: {
                this.writeSpecial(stringArray[7]);
                break;
            }
            case 119: {
                this.writeSpecial(stringArray[8]);
                break;
            }
            case 120: {
                this.writeSpecial(stringArray[9]);
                break;
            }
            case 121: {
                this.writeSpecial(stringArray[10]);
                break;
            }
            case 122: {
                this.writeSpecial(stringArray[11]);
                break;
            }
            case 123: {
                this.writeSpecial(stringArray[12]);
                break;
            }
            case 38: {
                this.writeSpecial(this.KeyUp[n3]);
                break;
            }
            case 40: {
                this.writeSpecial(this.KeyDown[n3]);
                break;
            }
            case 37: {
                this.writeSpecial(this.KeyLeft[n3]);
                break;
            }
            case 39: {
                this.writeSpecial(this.KeyRight[n3]);
                break;
            }
            case 34: {
                this.writeSpecial(this.NextScn[n3]);
                break;
            }
            case 33: {
                this.writeSpecial(this.PrevScn[n3]);
                break;
            }
            case 155: {
                this.writeSpecial(this.Insert[n3]);
                break;
            }
            case 127: {
                this.writeSpecial(this.Remove[n3]);
                break;
            }
            case 8: {
                this.writeSpecial(this.BackSpace[n3]);
                if (!this.localecho) break;
                if (this.BackSpace[n3] == "\b") {
                    this.putString("\b \b");
                    break;
                }
                this.putString(this.BackSpace[n3]);
                break;
            }
            case 36: {
                this.writeSpecial(this.KeyHome[n3]);
                break;
            }
            case 35: {
                this.writeSpecial(this.KeyEnd[n3]);
                break;
            }
            case 144: {
                if (this.vms && bl) {
                    this.writeSpecial(this.PF1);
                }
                if (bl) break;
                this.numlock = !this.numlock;
                break;
            }
            case 20: {
                this.capslock = !this.capslock;
                return;
            }
            case 16: 
            case 17: 
            case 18: {
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(int n, char c, int n2) {
        boolean bl;
        boolean bl2 = (n2 & 1) != 0;
        boolean bl3 = (n2 & 2) != 0;
        boolean bl4 = bl = (n2 & 4) != 0;
        if (c == '\t') {
            if (bl3) {
                this.write(this.TabKey[1], false);
            } else if (bl2) {
                this.write(this.TabKey[2], false);
            } else if (bl) {
                this.write(this.TabKey[3], false);
            } else {
                this.write(this.TabKey[0], false);
            }
            return;
        }
        if (bl) {
            this.write("" + (char)(c | 0x80));
            return;
        }
        if (!(n != 10 && c != '\n' || bl2)) {
            this.write("\r", false);
            if (this.localecho) {
                this.putString("\r\n");
            }
            return;
        }
        if (n == 10 && !bl2) {
            this.write("\r", false);
            return;
        }
        if ((!this.vms && c == '2' || c == ' ') && bl2) {
            this.write("\u0000");
        }
        if (this.vms) {
            if (c == '\u007f' && !bl2) {
                if (bl3) {
                    this.writeSpecial(this.Insert[0]);
                } else {
                    this.writeSpecial(this.Remove[0]);
                }
                return;
            }
            if (bl2) {
                switch (c) {
                    case '0': {
                        this.writeSpecial(this.Numpad[0]);
                        return;
                    }
                    case '1': {
                        this.writeSpecial(this.Numpad[1]);
                        return;
                    }
                    case '2': {
                        this.writeSpecial(this.Numpad[2]);
                        return;
                    }
                    case '3': {
                        this.writeSpecial(this.Numpad[3]);
                        return;
                    }
                    case '4': {
                        this.writeSpecial(this.Numpad[4]);
                        return;
                    }
                    case '5': {
                        this.writeSpecial(this.Numpad[5]);
                        return;
                    }
                    case '6': {
                        this.writeSpecial(this.Numpad[6]);
                        return;
                    }
                    case '7': {
                        this.writeSpecial(this.Numpad[7]);
                        return;
                    }
                    case '8': {
                        this.writeSpecial(this.Numpad[8]);
                        return;
                    }
                    case '9': {
                        this.writeSpecial(this.Numpad[9]);
                        return;
                    }
                    case '.': {
                        this.writeSpecial(this.KPPeriod);
                        return;
                    }
                    case '\u001f': 
                    case '-': {
                        this.writeSpecial(this.KPMinus);
                        return;
                    }
                    case '+': {
                        this.writeSpecial(this.KPComma);
                        return;
                    }
                    case '\n': {
                        this.writeSpecial(this.KPEnter);
                        return;
                    }
                    case '/': {
                        this.writeSpecial(this.PF2);
                        return;
                    }
                    case '*': {
                        this.writeSpecial(this.PF3);
                        return;
                    }
                }
            }
        }
        int n3 = 0;
        String[] stringArray = this.FunctionKey;
        if (bl3) {
            stringArray = this.FunctionKeyShift;
            n3 = 1;
        }
        if (bl2) {
            stringArray = this.FunctionKeyCtrl;
            n3 = 2;
        }
        if (bl) {
            stringArray = this.FunctionKeyAlt;
            n3 = 3;
        }
        if (n == 27) {
            this.writeSpecial(this.Escape[n3]);
            return;
        }
        if ((n2 & 8) != 0) {
            switch (n) {
                case 96: {
                    this.writeSpecial(this.Numpad[0]);
                    return;
                }
                case 97: {
                    this.writeSpecial(this.Numpad[1]);
                    return;
                }
                case 98: {
                    this.writeSpecial(this.Numpad[2]);
                    return;
                }
                case 99: {
                    this.writeSpecial(this.Numpad[3]);
                    return;
                }
                case 100: {
                    this.writeSpecial(this.Numpad[4]);
                    return;
                }
                case 101: {
                    this.writeSpecial(this.Numpad[5]);
                    return;
                }
                case 102: {
                    this.writeSpecial(this.Numpad[6]);
                    return;
                }
                case 103: {
                    this.writeSpecial(this.Numpad[7]);
                    return;
                }
                case 104: {
                    this.writeSpecial(this.Numpad[8]);
                    return;
                }
                case 105: {
                    this.writeSpecial(this.Numpad[9]);
                    return;
                }
                case 110: {
                    this.writeSpecial(this.NUMDot[n3]);
                    return;
                }
                case 107: {
                    this.writeSpecial(this.NUMPlus[n3]);
                    return;
                }
            }
        }
        if (c != '\b' && c != '\u007f' && c != '\r' && c != '\n') {
            this.write("" + c);
            return;
        }
    }

    private void handle_dcs(String string) {
    }

    private void handle_osc(String string) {
    }

    public char map_cp850_unicode(char c) {
        if (c >= '\u0100') {
            return c;
        }
        return unimap[c];
    }

    private void _SetCursor(int n, int n2) {
        int n3 = this.getRows();
        int n4 = this.getTopMargin();
        this.R = n < 0 ? 0 : n;
        int n5 = this.C = n2 < 0 ? 0 : n2;
        if (!this.moveoutsidemargins) {
            this.R += n4;
            n3 = this.getBottomMargin();
        }
        if (this.R > n3) {
            this.R = n3;
        }
    }

    private void putChar(char c, boolean bl) {
        int n = this.getRows();
        int n2 = this.getColumns();
        int n3 = this.getTopMargin();
        int n4 = this.getBottomMargin();
        boolean bl2 = false;
        this.markLine(this.R, 1);
        if (c > '\u00ff') {
            // empty if block
        }
        block0 : switch (this.term_state) {
            case 0: {
                int n5;
                if (!this.useibmcharset) {
                    n5 = 1;
                    switch (c) {
                        case '\u009d': {
                            this.osc = "";
                            this.term_state = 6;
                            break;
                        }
                        case '\u008d': {
                            if (this.R > n3) {
                                --this.R;
                                break;
                            }
                            this.insertLine(this.R, 1, true);
                            break;
                        }
                        case '\u0084': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                                break;
                            }
                            ++this.R;
                            break;
                        }
                        case '\u0085': {
                            if (this.R == n4 || this.R == n - 1) {
                                this.insertLine(this.R, 1, false);
                            } else {
                                ++this.R;
                            }
                            this.C = 0;
                            break;
                        }
                        case '\u0088': {
                            this.Tabs[this.C] = 1;
                            break;
                        }
                        case '\u0090': {
                            this.dcs = "";
                            this.term_state = 3;
                            break;
                        }
                        default: {
                            n5 = 0;
                        }
                    }
                    if (n5 != 0) break;
                }
                switch (c) {
                    case '\u008f': {
                        this.onegl = 3;
                        break;
                    }
                    case '\u008e': {
                        this.onegl = 2;
                        break;
                    }
                    case '\u009b': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case '\u001b': {
                        this.term_state = 1;
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\u0005': {
                        this.write(this.answerBack, false);
                        break;
                    }
                    case '\f': {
                        this.deleteArea(0, 0, n2, n, this.attributes);
                        this.R = 0;
                        this.C = 0;
                        break;
                    }
                    case '\b': {
                        --this.C;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\t': {
                        do {
                            ++this.C;
                        } while (this.C < n2 && this.Tabs[this.C] == 0);
                        this.lastwaslf = 0;
                        break;
                    }
                    case '\r': {
                        this.C = 0;
                        break;
                    }
                    case '\n': {
                        if (!this.vms) {
                            if (this.lastwaslf != 0 && this.lastwaslf != c) break block0;
                            this.lastwaslf = c;
                        }
                        if (this.R == n4 || this.R >= n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case '\u0007': {
                        this.beep();
                        break;
                    }
                    case '\u000e': {
                        this.gl = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case '\u000f': {
                        this.gl = '\u0000';
                        this.usedcharsets = true;
                        break;
                    }
                    default: {
                        n5 = this.gl;
                        if (this.onegl >= 0) {
                            n5 = this.onegl;
                            this.onegl = -1;
                        }
                        this.lastwaslf = 0;
                        if (c < ' ' && c != '\u0000' && c == '\u0000') break block0;
                        if (this.C >= n2) {
                            if (this.wraparound) {
                                if (this.R < n - 1) {
                                    ++this.R;
                                } else {
                                    this.insertLine(this.R, 1, false);
                                }
                                this.C = 0;
                            } else {
                                this.C = n2 - 1;
                            }
                        }
                        if (this.usedcharsets) {
                            if (c >= ' ' && c <= '\u007f') {
                                switch (this.gx[n5]) {
                                    case '0': {
                                        if (this.terminalID.equals("scoansi") || this.terminalID.equals("ansi")) {
                                            int n6 = 0;
                                            while (n6 < scoansi_acs.length()) {
                                                if (c == scoansi_acs.charAt(n6)) {
                                                    c = scoansi_acs.charAt(n6 + 1);
                                                    break;
                                                }
                                                n6 += 2;
                                            }
                                        }
                                        if (c < '_' || c > '~') break;
                                        c = DECSPECIAL[(short)c - 95];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': {
                                        c = (char)(c & 0x7F | 0x80);
                                        bl2 = true;
                                        break;
                                    }
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                }
                            }
                            if (!bl2 && c >= '\u0080' && c <= '\u00ff') {
                                switch (this.gx[this.gr]) {
                                    case '0': {
                                        if (c < '\u00df' || c > '\u00fe') break;
                                        c = DECSPECIAL[c - 223];
                                        bl2 = true;
                                        break;
                                    }
                                    case '<': 
                                    case 'A': 
                                    case 'B': {
                                        bl2 = true;
                                        break;
                                    }
                                }
                            }
                        }
                        if (!bl2 && this.useibmcharset) {
                            c = this.map_cp850_unicode(c);
                        }
                        if (this.insertmode == 1) {
                            this.insertChar(this.C, this.R, c, this.attributes);
                        } else {
                            this.putChar(this.C, this.R, c, this.attributes);
                        }
                        ++this.C;
                        break;
                    }
                }
                break;
            }
            case 6: {
                if (c < ' ' && c != '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                if (c == '\\' && this.osc.charAt(this.osc.length() - 1) == '\u001b') {
                    this.handle_osc(this.osc);
                    this.term_state = 0;
                    break;
                }
                this.osc = this.osc + c;
                break;
            }
            case 13: {
                this.term_state = 0;
                switch (c) {
                    case 'F': {
                        this.output8bit = false;
                        break block0;
                    }
                    case 'G': {
                        this.output8bit = true;
                        break block0;
                    }
                }
                break;
            }
            case 1: {
                this.term_state = 0;
                switch (c) {
                    case ' ': {
                        this.term_state = 13;
                        break;
                    }
                    case '#': {
                        this.term_state = 5;
                        break;
                    }
                    case 'c': {
                        this.gx[0] = 66;
                        this.gx[1] = 48;
                        this.gx[2] = 66;
                        this.gx[3] = 66;
                        this.gl = '\u0000';
                        this.gr = '\u0001';
                        int n7 = this.getColumns();
                        if (n7 < 132) {
                            n7 = 132;
                        }
                        this.Tabs = new byte[n7];
                        int n8 = 0;
                        while (n8 < n7) {
                            this.Tabs[n8] = 1;
                            n8 += 8;
                        }
                        break block0;
                    }
                    case '[': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.DCEvars[1] = 0;
                        this.DCEvars[2] = 0;
                        this.DCEvars[3] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case ']': {
                        this.osc = "";
                        this.term_state = 6;
                        break;
                    }
                    case 'P': {
                        this.dcs = "";
                        this.term_state = 3;
                        break;
                    }
                    case 'A': {
                        --this.R;
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'B': {
                        ++this.R;
                        if (this.R <= n - 1) break block0;
                        this.R = n - 1;
                        break;
                    }
                    case 'C': {
                        ++this.C;
                        if (this.C < n2) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'I': {
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'E': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                        } else {
                            ++this.R;
                        }
                        this.C = 0;
                        break;
                    }
                    case 'D': {
                        if (this.R == n4 || this.R == n - 1) {
                            this.insertLine(this.R, 1, false);
                            break;
                        }
                        ++this.R;
                        break;
                    }
                    case 'J': {
                        if (this.R < n - 1) {
                            this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                        }
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'K': {
                        if (this.C >= n2 - 1) break block0;
                        this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                        break;
                    }
                    case 'M': {
                        if (this.R > n4) break block0;
                        if (this.R > n3) {
                            --this.R;
                            break;
                        }
                        this.insertLine(this.R, 1, true);
                        break;
                    }
                    case 'H': {
                        if (this.C >= n2) {
                            this.C = n2 - 1;
                        }
                        this.Tabs[this.C] = 1;
                        break;
                    }
                    case 'N': {
                        this.onegl = 2;
                        break;
                    }
                    case 'O': {
                        this.onegl = 3;
                        break;
                    }
                    case '=': {
                        this.keypadmode = true;
                        break;
                    }
                    case '<': {
                        this.vt52mode = false;
                        break;
                    }
                    case '>': {
                        this.keypadmode = false;
                        break;
                    }
                    case '7': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sgl = this.gl;
                        this.Sgr = this.gr;
                        this.Sa = this.attributes;
                        this.Sgx = new char[4];
                        int n9 = 0;
                        while (n9 < 4) {
                            this.Sgx[n9] = this.gx[n9];
                            ++n9;
                        }
                        this.Stm = this.getTopMargin();
                        this.Sbm = this.getBottomMargin();
                        break;
                    }
                    case '8': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.gl = this.Sgl;
                        this.gr = this.Sgr;
                        int n10 = 0;
                        while (n10 < 4) {
                            this.gx[n10] = this.Sgx[n10];
                            ++n10;
                        }
                        this.setTopMargin(this.Stm);
                        this.setBottomMargin(this.Sbm);
                        this.attributes = this.Sa;
                        break;
                    }
                    case '(': {
                        this.term_state = 7;
                        this.usedcharsets = true;
                        break;
                    }
                    case ')': {
                        this.term_state = 8;
                        this.usedcharsets = true;
                        break;
                    }
                    case '*': {
                        this.term_state = 9;
                        this.usedcharsets = true;
                        break;
                    }
                    case '+': {
                        this.term_state = 10;
                        this.usedcharsets = true;
                        break;
                    }
                    case '~': {
                        this.gr = '\u0001';
                        this.usedcharsets = true;
                        break;
                    }
                    case 'n': {
                        this.gl = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case '}': {
                        this.gr = (char)2;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'o': {
                        this.gl = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case '|': {
                        this.gr = (char)3;
                        this.usedcharsets = true;
                        break;
                    }
                    case 'Y': {
                        this.term_state = 15;
                        break;
                    }
                }
                break;
            }
            case 14: {
                this.C = c - 37;
                this.term_state = 15;
                break;
            }
            case 15: {
                this.R = c - 37;
                this.term_state = 0;
                break;
            }
            case 7: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[0] = c;
                }
                this.term_state = 0;
                break;
            }
            case 8: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[1] = c;
                }
                this.term_state = 0;
                break;
            }
            case 9: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[2] = c;
                }
                this.term_state = 0;
                break;
            }
            case 10: {
                if (c == '0' || c == 'A' || c == 'B' || c == '<') {
                    this.gx[3] = c;
                }
                this.term_state = 0;
                break;
            }
            case 5: {
                switch (c) {
                    case '8': {
                        int n11 = 0;
                        while (n11 < n2) {
                            int n12 = 0;
                            while (n12 < n) {
                                this.putChar(n11, n12, 'E', 0);
                                ++n12;
                            }
                            ++n11;
                        }
                        break;
                    }
                }
                this.term_state = 0;
                break;
            }
            case 3: {
                if (c == '\\' && this.dcs.charAt(this.dcs.length() - 1) == '\u001b') {
                    this.handle_dcs(this.dcs);
                    this.term_state = 0;
                    break;
                }
                this.dcs = this.dcs + c;
                break;
            }
            case 4: {
                this.term_state = 0;
                block93 : switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 4;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case 's': {
                        break;
                    }
                    case 'r': {
                        int n13 = 0;
                        while (n13 <= this.DCEvar) {
                            switch (this.DCEvars[n13]) {
                                case 3: {
                                    this.setScreenSize(80, this.getRows());
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    break;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    break;
                                }
                                case 12: {
                                    break;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[n13];
                                    break;
                                }
                            }
                            ++n13;
                        }
                        break block0;
                    }
                    case 'h': {
                        int n14 = 0;
                        while (n14 <= this.DCEvar) {
                            switch (this.DCEvars[n14]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001bOA";
                                    this.KeyDown[0] = "\u001bOB";
                                    this.KeyRight[0] = "\u001bOC";
                                    this.KeyLeft[0] = "\u001bOD";
                                    break;
                                }
                                case 2: {
                                    this.vt52mode = false;
                                    break;
                                }
                                case 3: {
                                    this.setScreenSize(132, this.getRows());
                                    break;
                                }
                                case 6: {
                                    this.moveoutsidemargins = false;
                                    break;
                                }
                                case 7: {
                                    this.wraparound = true;
                                    break;
                                }
                                case 25: {
                                    this.showCursor(true);
                                    this.redraw();
                                    break;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = this.DCEvars[n14];
                                    break;
                                }
                            }
                            ++n14;
                        }
                        break block0;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 1: {
                                break block93;
                            }
                            case 4: {
                                break block93;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        int n15 = 0;
                        while (n15 <= this.DCEvar) {
                            switch (this.DCEvars[n15]) {
                                case 1: {
                                    this.KeyUp[0] = "\u001b[A";
                                    this.KeyDown[0] = "\u001b[B";
                                    this.KeyRight[0] = "\u001b[C";
                                    this.KeyLeft[0] = "\u001b[D";
                                    break;
                                }
                                case 2: {
                                    this.vt52mode = true;
                                    break;
                                }
                                case 3: {
                                    this.setScreenSize(80, this.getRows());
                                    break;
                                }
                                case 6: {
                                    this.moveoutsidemargins = true;
                                    break;
                                }
                                case 7: {
                                    this.wraparound = false;
                                    break;
                                }
                                case 25: {
                                    this.showCursor(false);
                                    this.redraw();
                                    break;
                                }
                                case 9: 
                                case 1000: 
                                case 1001: 
                                case 1002: 
                                case 1003: {
                                    this.mouserpt = 0;
                                    break;
                                }
                            }
                            ++n15;
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 15: {
                                this.write("\u001b[?13n", false);
                                break block93;
                            }
                        }
                        break;
                    }
                }
                break;
            }
            case 12: {
                this.term_state = 0;
                switch (c) {
                    case '\u001b': {
                        this.term_state = 1;
                        break block0;
                    }
                }
                break;
            }
            case 16: {
                this.term_state = 0;
                switch (c) {
                    case 'p': {
                        if (this.DCEvars[0] == 61) {
                            this.output8bit = false;
                            break block0;
                        }
                        if (this.DCEvars[1] == 1) {
                            this.output8bit = false;
                            break block0;
                        }
                        this.output8bit = true;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                this.term_state = 0;
                switch (c) {
                    case '}': {
                        this.statusmode = this.DCEvars[0];
                        break block0;
                    }
                    case '~': {
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                this.term_state = 0;
                block147 : switch (c) {
                    case '\"': {
                        this.term_state = 16;
                        break;
                    }
                    case '$': {
                        this.term_state = 11;
                        break;
                    }
                    case '!': {
                        this.term_state = 12;
                        break;
                    }
                    case '?': {
                        this.DCEvar = 0;
                        this.DCEvars[0] = 0;
                        this.term_state = 4;
                        break;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.DCEvars[this.DCEvar] = this.DCEvars[this.DCEvar] * 10 + c - 48;
                        this.term_state = 2;
                        break;
                    }
                    case ';': {
                        ++this.DCEvar;
                        this.DCEvars[this.DCEvar] = 0;
                        this.term_state = 2;
                        break;
                    }
                    case 'c': {
                        String string = "";
                        if (this.terminalID.equals("vt320")) {
                            string = "63;";
                        }
                        if (this.terminalID.equals("vt220")) {
                            string = "62;";
                        }
                        if (this.terminalID.equals("vt100")) {
                            string = "61;";
                        }
                        this.write("\u001b[?" + string + "1;2c", false);
                        break;
                    }
                    case 'q': {
                        break;
                    }
                    case 'g': {
                        switch (this.DCEvars[0]) {
                            case 3: {
                                this.Tabs = new byte[this.getColumns()];
                                break block147;
                            }
                            case 0: {
                                this.Tabs[this.C] = 0;
                            }
                        }
                        break;
                    }
                    case 'h': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 1;
                                break block147;
                            }
                            case 20: {
                                this.sendcrlf = true;
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'i': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                break block147;
                            }
                            case 4: {
                                break block147;
                            }
                            case 5: {
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'l': {
                        switch (this.DCEvars[0]) {
                            case 4: {
                                this.insertmode = 0;
                                break block147;
                            }
                            case 20: {
                                this.sendcrlf = false;
                                break block147;
                            }
                        }
                        break;
                    }
                    case 'A': {
                        int n16 = this.R > n4 ? n4 + 1 : (this.R >= n3 ? n3 : 0);
                        this.R = this.DCEvars[0] == 0 ? --this.R : (this.R -= this.DCEvars[0]);
                        if (this.R >= n16) break block0;
                        this.R = n16;
                        break;
                    }
                    case 'B': {
                        int n17 = this.R < n3 ? n3 - 1 : (this.R <= n4 ? n4 : n - 1);
                        this.R = this.DCEvars[0] == 0 ? ++this.R : (this.R += this.DCEvars[0]);
                        if (this.R <= n17) break block0;
                        this.R = n17;
                        break;
                    }
                    case 'C': {
                        this.C = this.DCEvars[0] == 0 ? ++this.C : (this.C += this.DCEvars[0]);
                        if (this.C <= n2 - 1) break block0;
                        this.C = n2 - 1;
                        break;
                    }
                    case 'd': {
                        this.R = this.DCEvars[0];
                        break;
                    }
                    case 'D': {
                        this.C = this.DCEvars[0] == 0 ? --this.C : (this.C -= this.DCEvars[0]);
                        if (this.C >= 0) break block0;
                        this.C = 0;
                        break;
                    }
                    case 'r': {
                        if (this.DCEvar > 0) {
                            this.R = this.DCEvars[1] - 1;
                            if (this.R < 0) {
                                this.R = n - 1;
                            } else if (this.R >= n) {
                                this.R = n - 1;
                            }
                        } else {
                            this.R = n - 1;
                        }
                        this.setBottomMargin(this.R);
                        if (this.R >= this.DCEvars[0]) {
                            this.R = this.DCEvars[0] - 1;
                            if (this.R < 0) {
                                this.R = 0;
                            }
                        }
                        this.setTopMargin(this.R);
                        this._SetCursor(0, 0);
                        break;
                    }
                    case 'G': {
                        this.C = this.DCEvars[0];
                        break;
                    }
                    case 'H': {
                        this._SetCursor(this.DCEvars[0] - 1, this.DCEvars[1] - 1);
                        break;
                    }
                    case 'f': {
                        this.R = this.DCEvars[0] - 1;
                        this.C = this.DCEvars[1] - 1;
                        if (this.C < 0) {
                            this.C = 0;
                        }
                        if (this.R >= 0) break block0;
                        this.R = 0;
                        break;
                    }
                    case 'S': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(n - 1, false);
                            break;
                        }
                        this.insertLine(n - 1, this.DCEvars[0], false);
                        break;
                    }
                    case 'L': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(this.R, true);
                            break;
                        }
                        this.insertLine(this.R, this.DCEvars[0], true);
                        break;
                    }
                    case 'T': {
                        if (this.DCEvars[0] == 0) {
                            this.insertLine(0, true);
                            break;
                        }
                        this.insertLine(0, this.DCEvars[0], true);
                        break;
                    }
                    case 'M': {
                        if (this.DCEvars[0] == 0) {
                            this.deleteLine(this.R);
                            break;
                        }
                        int n18 = 0;
                        while (n18 < this.DCEvars[0]) {
                            this.deleteLine(this.R);
                            ++n18;
                        }
                        break block0;
                    }
                    case 'K': {
                        switch (this.DCEvars[0]) {
                            case 0: 
                            case 6: {
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block147;
                            }
                            case 1: {
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block147;
                            }
                            case 2: {
                                this.deleteArea(0, this.R, n2, 1, this.attributes);
                            }
                        }
                        break;
                    }
                    case 'J': {
                        switch (this.DCEvars[0]) {
                            case 0: {
                                if (this.R < n - 1) {
                                    this.deleteArea(0, this.R + 1, n2, n - this.R - 1, this.attributes);
                                }
                                if (this.C >= n2 - 1) break;
                                this.deleteArea(this.C, this.R, n2 - this.C, 1, this.attributes);
                                break block147;
                            }
                            case 1: {
                                if (this.R > 0) {
                                    this.deleteArea(0, 0, n2, this.R, this.attributes);
                                }
                                if (this.C <= 0) break;
                                this.deleteArea(0, this.R, this.C + 1, 1, this.attributes);
                                break block147;
                            }
                            case 2: {
                                this.deleteArea(0, 0, n2, n, this.attributes);
                            }
                        }
                        break;
                    }
                    case '@': {
                        int n19 = 0;
                        while (n19 < this.DCEvars[0]) {
                            this.insertChar(this.C, this.R, ' ', this.attributes);
                            ++n19;
                        }
                        break block0;
                    }
                    case 'X': {
                        int n20 = this.DCEvars[0];
                        if (n20 == 0) {
                            n20 = 1;
                        }
                        if (n20 + this.C > n2) {
                            n20 = n2 - this.C;
                        }
                        this.deleteArea(this.C, this.R, n20, 1, this.attributes);
                        break;
                    }
                    case 'P': {
                        if (this.DCEvars[0] == 0) {
                            this.DCEvars[0] = 1;
                        }
                        int n21 = 0;
                        while (n21 < this.DCEvars[0]) {
                            this.deleteChar(this.C, this.R);
                            ++n21;
                        }
                        break block0;
                    }
                    case 'n': {
                        switch (this.DCEvars[0]) {
                            case 5: {
                                this.writeSpecial("\u001b[0n");
                                break block147;
                            }
                            case 6: {
                                this.writeSpecial("\u001b[" + this.R + ";" + this.C + "R");
                                break block147;
                            }
                        }
                        break;
                    }
                    case 's': {
                        this.Sc = this.C;
                        this.Sr = this.R;
                        this.Sa = this.attributes;
                        break;
                    }
                    case 'u': {
                        this.C = this.Sc;
                        this.R = this.Sr;
                        this.attributes = this.Sa;
                        break;
                    }
                    case 'm': {
                        if (this.DCEvar == 0 && this.DCEvars[0] == 0) {
                            this.attributes = 0;
                        }
                        int n22 = 0;
                        while (n22 <= this.DCEvar) {
                            switch (this.DCEvars[n22]) {
                                case 0: {
                                    if (this.DCEvar <= 0) break;
                                    if (this.terminalID.equals("scoansi")) {
                                        this.attributes &= 0xFF0;
                                        break;
                                    }
                                    this.attributes = 0;
                                    break;
                                }
                                case 1: {
                                    this.attributes |= 1;
                                    this.attributes &= 0xFFFFFFF7;
                                    break;
                                }
                                case 2: {
                                    if (this.terminalID.equals("scoansi") && this.DCEvar - n22 >= 2) {
                                        this.attributes &= 0xFFFFF00E;
                                        int n23 = this.DCEvars[n22 + 1];
                                        if ((n23 & 8) == 8) {
                                            this.attributes |= 1;
                                        }
                                        n23 = (n23 & 1) << 2 | n23 & 2 | (n23 & 4) >> 2;
                                        this.attributes |= n23 + 1 << 4;
                                        n23 = this.DCEvars[n22 + 2];
                                        n23 = (n23 & 1) << 2 | n23 & 2 | (n23 & 4) >> 2;
                                        this.attributes |= n23 + 1 << 8;
                                        n22 += 2;
                                        break;
                                    }
                                    this.attributes |= 8;
                                    break;
                                }
                                case 4: {
                                    this.attributes |= 2;
                                    break;
                                }
                                case 7: {
                                    this.attributes |= 4;
                                    break;
                                }
                                case 5: {
                                    break;
                                }
                                case 10: {
                                    this.gl = '\u0000';
                                    this.usedcharsets = true;
                                    break;
                                }
                                case 11: 
                                case 12: {
                                    this.gl = '\u0001';
                                    this.usedcharsets = true;
                                    break;
                                }
                                case 21: {
                                    this.attributes &= 0xFFFFFFF6;
                                    break;
                                }
                                case 25: {
                                    break;
                                }
                                case 27: {
                                    this.attributes &= 0xFFFFFFFB;
                                    break;
                                }
                                case 24: {
                                    this.attributes &= 0xFFFFFFFD;
                                    break;
                                }
                                case 22: {
                                    this.attributes &= 0xFFFFFFFE;
                                    break;
                                }
                                case 30: 
                                case 31: 
                                case 32: 
                                case 33: 
                                case 34: 
                                case 35: 
                                case 36: 
                                case 37: {
                                    this.attributes &= 0xFFFFFF0F;
                                    this.attributes |= this.DCEvars[n22] - 30 + 1 << 4;
                                    break;
                                }
                                case 39: {
                                    this.attributes &= 0xFFFFFF0F;
                                    break;
                                }
                                case 40: 
                                case 41: 
                                case 42: 
                                case 43: 
                                case 44: 
                                case 45: 
                                case 46: 
                                case 47: {
                                    this.attributes &= 0xFFFFF0FF;
                                    this.attributes |= this.DCEvars[n22] - 40 + 1 << 8;
                                    break;
                                }
                                case 49: {
                                    this.attributes &= 0xFFFFF0FF;
                                    break;
                                }
                            }
                            ++n22;
                        }
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.term_state = 0;
            }
        }
        if (this.C > n2) {
            this.C = n2;
        }
        if (this.R > n) {
            this.R = n;
        }
        if (this.C < 0) {
            this.C = 0;
        }
        if (this.R < 0) {
            this.R = 0;
        }
        if (bl) {
            this.setCursorPosition(this.C, this.R);
        }
        this.markLine(this.R, 1);
    }

    public void reset() {
        this.gx[0] = 66;
        this.gx[1] = 48;
        this.gx[2] = 66;
        this.gx[3] = 66;
        this.gl = '\u0000';
        this.gr = '\u0001';
        int n = this.getColumns();
        if (n < 132) {
            n = 132;
        }
        this.Tabs = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            this.Tabs[n2] = 1;
            n2 += 8;
        }
        this.term_state = 0;
    }
}

