/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class ReaderCanvas
extends Canvas {
    MobiBrowser browser;
    int screenWidth;
    int screenHeight;
    int fontHeight;
    int screenLines;
    int nLines;
    int[] linePos;
    char prevPageChar;
    Font font;
    Font linkFont;
    int spaceWidth;
    int hyphenWidth;
    Timer repeatTimer;
    RepeatTask repeatTask;
    byte[] text;
    int textLength;
    Tag currTag;
    Tag tags;
    int currPagePos;
    int currPageEnd;
    Hashtable index;
    String url;
    static final int BACKGROUND_COLOR = 0xFFFFFF;
    static final int FOREGROUND_COLOR = 0;
    static final int SLIDER_COLOR = 0x8080FF;
    static final int SLIDER_POS_COLOR = 0xFF0000;
    static final int VISITED_LINK_COLOR = 0x800040;
    static final int LINK_COLOR = 255;
    static final int CURRENT_LINK_BACKGROUND_COLOR = 0;
    static final int CURRENT_LINK_FOREGROUND_COLOR = 0xFFFFFF;
    static final int MIN_SLIDER_LENGTH = 3;
    static final int REPEAT_DELAY = 1000;
    static final int REPEAT_PERIOD = 100;
    static final int OVERLAP = 1;
    static final int INDENTATION = 2;
    static final String[] breakTags = new String[]{"li", "br", "tr", "p", "h1", "h2", "h3", "hr", "/p", "/h1", "/h2", "/h3"};
    static final String[] skipTags = new String[]{"form", "script", "style"};

    ReaderCanvas(String string, int n, byte[] byArray, int n2, MobiBrowser mobiBrowser) {
        this.setFullScreenMode(true);
        this.url = string;
        this.text = byArray;
        this.textLength = n2;
        this.browser = mobiBrowser;
        this.screenWidth = this.getWidth() - 1;
        this.screenHeight = this.getHeight();
        this.font = Font.getFont((int)64, (int)0, (int)8);
        this.linkFont = Font.getFont((int)64, (int)4, (int)8);
        this.fontHeight = this.font.getHeight() - 1;
        this.screenLines = this.screenHeight / this.fontHeight;
        this.spaceWidth = this.font.charWidth(' ');
        this.hyphenWidth = this.font.charWidth('-');
        this.linePos = new int[this.screenLines + 1];
        this.prevPageChar = (char)10;
        this.index = new Hashtable();
        this.tags = new Tag();
        this.convertText();
        this.currTag = this.tags;
        mobiBrowser.cache(string, this);
        this.setPosition(n);
        this.repeatTimer = new Timer();
        Display.getDisplay((MIDlet)mobiBrowser).setCurrent((Displayable)this);
    }

    void convertText() {
        byte[] byArray = this.text;
        int n = this.textLength;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: for (int i = 0; i < n; ++i) {
            int n5;
            String string;
            int n6;
            byte by = byArray[i];
            if (by == 60) {
                String string2;
                if (i + 3 < n && byArray[i + 1] == 33 && byArray[i + 2] == 45 && byArray[i + 3] == 45) {
                    i += 3;
                    while (++i + 3 < n && (byArray[i] != 45 || byArray[i + 1] != 45 || byArray[i + 2] != 62)) {
                    }
                    i += 2;
                    continue;
                }
                n6 = i + 1;
                while (++i < n && byArray[i] != 62) {
                    if (byArray[i] != 60) continue;
                    n6 = i + 1;
                }
                String string3 = new String(byArray, n6, i - n6);
                string = string3.toLowerCase();
                for (n5 = 0; n5 < skipTags.length; ++n5) {
                    string2 = skipTags[n5];
                    if (!string.equals(string2) && (!string.startsWith(string2) || string.charAt(string2.length()) != ' ')) continue;
                    ++n2;
                    break;
                }
                if (n2 > 0 && string.startsWith("/")) {
                    String string4 = string.substring(1);
                    for (int j = 0; j < skipTags.length; ++j) {
                        if (!string4.equals(skipTags[j])) continue;
                        --n2;
                        break;
                    }
                }
                if (n2 > 0) continue;
                if (string.startsWith("pre")) {
                    ++n3;
                    continue;
                }
                if (string.startsWith("/pre")) {
                    --n3;
                    continue;
                }
                if (string.startsWith("a href")) {
                    String string5 = ReaderCanvas.getUrl(string3);
                    if (string5.length() <= 0 || string5.equals("#")) continue;
                    this.tags.link(new Tag(string5, n4));
                    continue;
                }
                if (string.startsWith("a name")) {
                    this.index.put(ReaderCanvas.getUrl(string3), new Integer(n4));
                    continue;
                }
                if (string.equals("/a")) {
                    if (this.tags.prev.end >= 0) continue;
                    if (this.tags.prev.beg == n4) {
                        this.tags.prev.unlink();
                        continue;
                    }
                    this.tags.prev.end = n4;
                    continue;
                }
                for (n5 = 0; n5 < breakTags.length; ++n5) {
                    string2 = breakTags[n5];
                    if (!string.equals(string2) && (!string.startsWith(string2) || string.charAt(string2.length()) != ' ')) continue;
                    if (string2.equals("p")) {
                        for (int j = 0; j < 2; ++j) {
                            byArray[n4++] = 32;
                        }
                    } else if (n4 == 0 || byArray[n4 - 1] == 10) continue;
                    byArray[n4++] = 10;
                    continue block0;
                }
                continue;
            }
            if (n2 != 0) continue;
            if (by == 38) {
                int n7 = i + 8 < n ? i + 8 : n;
                for (n6 = i + 1; n6 < n7 && byArray[n6] != 59; ++n6) {
                }
                if (n6 < n7 && byArray[n6] == 59) {
                    string = new String(byArray, i + 1, n6 - i - 1).toLowerCase();
                    i = n6;
                    if (string.equals("amp")) {
                        n5 = 38;
                    } else if (string.equals("quot")) {
                        n5 = 34;
                    } else if (string.equals("lt")) {
                        n5 = 60;
                    } else if (string.equals("gt")) {
                        n5 = 62;
                    } else if (string.equals("nbsp")) {
                        n5 = 32;
                    } else {
                        if (!string.startsWith("#")) continue;
                        n5 = (char)Integer.parseInt(string.substring(1), 16);
                    }
                    byArray[n4++] = (byte)n5;
                    continue;
                }
                byArray[n4++] = 38;
                continue;
            }
            if (by == 10 || by == 32 || by == 9) {
                if (n3 != 0) {
                    byArray[n4++] = (byte)(by == 10 ? 13 : 32);
                    continue;
                }
                if (n4 == 0 || byArray[n4 - 1] == 32 || byArray[n4 - 1] == 10) continue;
                byArray[n4++] = 32;
                continue;
            }
            if (by == 13) continue;
            byArray[n4++] = by;
        }
        this.textLength = n4;
    }

    public boolean search(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        int n = cArray.length;
        char[] cArray2 = new char[n];
        char c = '\u0000';
        int n2 = 0;
        int n3 = this.currPagePos;
        block0: while (++n3 < this.textLength) {
            char c2 = Locale.getChar(this.text[n3]);
            if (c2 == ' ' && c == ' ') continue;
            c = c2;
            if (n2 == n) {
                n2 = 0;
            }
            cArray2[n2++] = Character.toLowerCase(c2);
            int n4 = 0;
            int n5 = n2;
            while (n5 < n) {
                if (cArray[n4] != cArray2[n5]) continue block0;
                ++n5;
                ++n4;
            }
            n5 = 0;
            while (n4 < n) {
                if (cArray[n4] != cArray2[n5]) continue block0;
                ++n5;
                ++n4;
            }
            this.setPosition(n3 - n + 1);
            return true;
        }
        return false;
    }

    static void insertSpaces(StringBuffer stringBuffer, int n) {
        if (n > 0) {
            int n2 = 0;
            int n3 = stringBuffer.length();
            while (stringBuffer.charAt(n2) == ' ') {
                ++n2;
            }
            int n4 = 0;
            while (++n2 < n3) {
                if (stringBuffer.charAt(n2) != ' ') continue;
                ++n4;
            }
            if (n4 != 0) {
                int n5 = n / n4;
                int n6 = n % n4;
                do {
                    if (stringBuffer.charAt(--n2) != ' ') continue;
                    for (int i = 0; i < n5; ++i) {
                        stringBuffer.insert(n2, ' ');
                    }
                    if (n6 != 0) {
                        stringBuffer.insert(n2, ' ');
                        --n6;
                    }
                    --n4;
                } while (n4 != 0);
            }
        }
    }

    private static boolean isSeparator(char c) {
        return c == ' ' || c == '!' || c == '.' || c == ',' || c == ';' || c == '?' || c == '-' || c == '+' || c == '=' || c == ')' || c == '}' || c == ']' || c == '\\' || c == '/' || c == ':' || c == '>';
    }

    final char getChar(int n) {
        if (n >= this.textLength) {
            return '\u0000';
        }
        return Locale.getChar(this.text[n]);
    }

    int splitWord(StringBuffer stringBuffer, int n, int n2, boolean bl) {
        char c = stringBuffer.charAt(n - 1);
        char c2 = stringBuffer.charAt(n - 2);
        if (ReaderCanvas.isSeparator(c2)) {
            if (c2 == ' ') {
                stringBuffer.delete(n - 2, stringBuffer.length());
                n2 -= this.spaceWidth + this.font.charWidth(c);
            } else {
                stringBuffer.delete(n - 1, stringBuffer.length());
                n2 -= this.font.charWidth(c);
            }
            if (bl) {
                ReaderCanvas.insertSpaces(stringBuffer, (this.screenWidth - n2) / this.spaceWidth);
            }
            return 1;
        }
        int n3 = Locale.split(stringBuffer, n);
        if (n3 <= 0) {
            n3 = n - 2;
        }
        int n4 = n - n3;
        boolean bl2 = true;
        if (n3 >= 1 && ReaderCanvas.isSeparator(stringBuffer.charAt(n3 - 1))) {
            if (stringBuffer.charAt(n3 - 1) == ' ') {
                --n3;
            }
            bl2 = false;
        } else if (n3 >= 2 && ReaderCanvas.isSeparator(stringBuffer.charAt(n3 - 2))) {
            n3 -= stringBuffer.charAt(n3 - 2) == ' ' ? 2 : 1;
            ++n4;
            bl2 = false;
        }
        for (int i = n3; i < n; ++i) {
            n2 -= this.font.charWidth(stringBuffer.charAt(i));
        }
        stringBuffer.delete(n3, stringBuffer.length());
        if (bl2) {
            stringBuffer.insert(n3, '-');
            n2 += this.hyphenWidth;
        }
        if (bl) {
            ReaderCanvas.insertSpaces(stringBuffer, (this.screenWidth - n2) / this.spaceWidth);
        }
        return n4;
    }

    private static String getUrl(String string) {
        String string2;
        int n;
        String string3 = string.substring(string.indexOf(61) + 1).trim();
        if (string3.startsWith("\"")) {
            string3 = string3.substring(1, string3.indexOf(34, 1));
        } else {
            n = string3.indexOf(32);
            if (n >= 0) {
                string3 = string3.substring(0, n);
            }
        }
        n = string3.indexOf(63);
        if (n >= 0 && (string2 = string3.substring(n + 1)).startsWith("http://")) {
            return string2;
        }
        return string3;
    }

    protected void paint(Graphics graphics) {
        int n;
        int n2;
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(graphics.getClipX(), graphics.getClipY(), graphics.getClipWidth(), graphics.getClipHeight());
        boolean bl = false;
        while (true) {
            n2 = this.currPagePos;
            n = 0;
            Tag tag = this.tags.next;
            Tag tag2 = null;
            this.nLines = 0;
            for (int i = 0; n == 0 && i < this.screenLines; ++i) {
                int n3;
                int n4;
                this.linePos[i] = n2;
                ++this.nLines;
                int n5 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                Tag tag3 = null;
                Tag tag4 = null;
                char c = '\u0000';
                do {
                    c = this.getChar(n2);
                    while (tag != this.tags && tag.end <= n2) {
                        tag = tag.next;
                    }
                    n4 = 0;
                    if (n2 >= tag.beg && n2 < tag.end) {
                        n4 = 0;
                        if (tag3 == null) {
                            if (this.currTag.end <= this.currPagePos) {
                                this.currTag = tag;
                            }
                            tag3 = tag4 = tag;
                            tag.pos = stringBuffer.length() - n2 + tag.beg;
                        } else if (tag.beg == n2) {
                            tag4 = tag;
                            tag.pos = stringBuffer.length();
                        }
                    }
                    ++n2;
                    if (c == ' ') {
                        n3 = n2 - 1;
                        while (--n3 >= 0 && this.text[n3] == 32) {
                        }
                        if ((n3 < 0 || this.text[n3] == 13) && n2 - n3 - 1 <= 2) {
                            stringBuffer.append(c);
                            n5 += this.spaceWidth;
                            continue;
                        }
                        if (n3 + 2 < n2) {
                            continue;
                        }
                    } else if (c == '\r') {
                        c = '\n';
                        if (n2 < this.textLength && (this.text[n2] == 32 || this.text[n2] == 13)) break;
                        c = ' ';
                    } else {
                        if (c == '\u0000') {
                            n = 1;
                            break;
                        }
                        if (c == '\n') break;
                    }
                    stringBuffer.append(c);
                    n5 += this.font.charWidth(c);
                } while (n5 <= this.screenWidth);
                if (n5 > this.screenWidth) {
                    if (c == ' ' || c == '\n') {
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                        n5 -= this.spaceWidth;
                        if (tag3 == null) {
                            ReaderCanvas.insertSpaces(stringBuffer, (this.screenWidth - n5) / this.spaceWidth);
                        }
                    } else {
                        n4 = stringBuffer.length();
                        if (n == 0) {
                            n3 = n2;
                            while ((c = this.getChar(n3++)) > ' ') {
                                stringBuffer.append(c);
                            }
                        }
                        n2 -= this.splitWord(stringBuffer, n4, n5, tag3 == null);
                    }
                }
                String string = stringBuffer.toString();
                n3 = string.length();
                graphics.setColor(0);
                graphics.setFont(this.font);
                graphics.drawString(string, 0, i * this.fontHeight, 20);
                if (tag3 == null) continue;
                if (tag2 == null) {
                    tag2 = tag3;
                }
                graphics.setFont(this.linkFont);
                tag4 = tag4.next;
                do {
                    int n6 = tag3.end - tag3.beg;
                    int n7 = tag3.pos;
                    if (n7 < 0) {
                        n6 += n7;
                        n7 = 0;
                    }
                    if (n7 >= n3) continue;
                    if (n7 + n6 > n3) {
                        n6 = n3 - n7;
                    }
                    if (tag3 == this.currTag) {
                        graphics.setColor(0);
                        graphics.fillRect(this.font.substringWidth(string, 0, n7), i * this.fontHeight, this.font.substringWidth(string, n7, n6), this.fontHeight);
                        graphics.setColor(0xFFFFFF);
                        bl = true;
                    } else {
                        graphics.setColor(tag3.url.startsWith("#") || this.browser.historyHash.get(tag3.url) != null ? 0x800040 : 255);
                    }
                    graphics.drawSubstring(string, n7, n6, this.font.substringWidth(string, 0, n7), i * this.fontHeight, 20);
                } while ((tag3 = tag3.next) != tag4);
            }
            this.currPageEnd = n2;
            this.linePos[this.nLines] = n2;
            if (bl || tag2 == null) break;
            bl = true;
            this.currTag = tag2;
        }
        if (this.textLength != 0) {
            n2 = (this.currPageEnd - this.currPagePos) * this.screenHeight / this.textLength;
            if (n2 < 3) {
                n2 = 3;
            }
            n = this.currPagePos * this.screenHeight / this.textLength;
            graphics.setColor(0x8080FF);
            graphics.drawLine(this.screenWidth, 0, this.screenWidth, this.screenHeight);
            graphics.setColor(0xFF0000);
            graphics.drawLine(this.screenWidth, n, this.screenWidth, n + n2);
        }
    }

    void moveBackward(int n) {
        int n2 = this.currPagePos;
        int n3 = 0;
        this.prevPageChar = (char)10;
        while (--n2 >= 0 && n > 0) {
            char c = this.getChar(n2);
            if (c == '\n') {
                n3 = 0;
                --n;
                this.prevPageChar = (char)10;
                continue;
            }
            if ((n3 += this.font.charWidth(c)) <= this.screenWidth) continue;
            n3 = 0;
            --n;
            this.prevPageChar = (char)32;
        }
        this.setPosition(n2 + 1);
    }

    void moveForward(int n) {
        if (this.nLines == this.screenLines) {
            if (n > this.screenLines) {
                n = this.screenLines;
            }
            this.setPosition(this.linePos[n]);
        }
    }

    public void setPosition(int n) {
        this.currPagePos = n;
        this.browser.setCurrentPosition(n);
    }

    public void keyPressed(int n) {
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
        }
        this.repeatTask = new RepeatTask(n);
        this.repeatTimer.schedule((TimerTask)this.repeatTask, 1000L, 100L);
    }

    public void keyReleased(int n) {
        this.keyAction(n);
        if (this.repeatTask != null) {
            this.repeatTask.cancel();
            this.repeatTask = null;
        }
    }

    private void keyAction(int n) {
        block0 : switch (n) {
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.moveForward(n - 48);
                break;
            }
            case 48: {
                new Menu(this.browser, this);
                return;
            }
            case 42: {
                this.browser.backward();
                return;
            }
            case 35: {
                this.browser.forward();
                return;
            }
            default: {
                switch (this.getGameAction(n)) {
                    case 2: {
                        if (this.currTag.prev != this.tags) {
                            this.currTag = this.currTag.prev;
                            if (this.currTag.beg >= this.currPagePos) break block0;
                            this.setPosition(this.currTag.beg);
                            break block0;
                        }
                        this.moveBackward(1);
                        break block0;
                    }
                    case 5: {
                        if (this.currTag.next != this.tags) {
                            this.currTag = this.currTag.next;
                            if (this.currTag.beg < this.currPageEnd) break block0;
                            this.setPosition(this.currTag.beg);
                            break block0;
                        }
                        this.moveForward(1);
                        break block0;
                    }
                    case 1: {
                        this.moveBackward(this.screenLines);
                        break block0;
                    }
                    case 6: {
                        this.moveForward(this.screenLines);
                        break block0;
                    }
                    case 8: {
                        if (this.currTag != this.tags) {
                            String string = this.currTag.url;
                            if (string.startsWith("#")) {
                                Integer n2 = (Integer)this.index.get(string.substring(1));
                                if (n2 != null) {
                                    this.setPosition(n2);
                                    break block0;
                                }
                            } else {
                                if (!string.startsWith("http:")) {
                                    string = string.startsWith("/") ? MobiBrowser.getHost(this.url) + string : MobiBrowser.getHost(this.url) + '/' + string;
                                }
                                this.browser.load(string, 0);
                            }
                        }
                    }
                    default: {
                        return;
                    }
                }
            }
        }
        this.repaint();
    }

    class RepeatTask
    extends TimerTask {
        int keyCode;

        RepeatTask(int n) {
            this.keyCode = n;
        }

        public void run() {
            ReaderCanvas.this.keyAction(this.keyCode);
        }
    }

    static class Tag {
        Tag next;
        Tag prev;
        String url;
        int beg;
        int end;
        int pos;

        void link(Tag tag) {
            this.prev.next = tag;
            tag.next = this;
            tag.prev = this.prev;
            this.prev = tag;
        }

        void unlink() {
            this.next.prev = this.prev;
            this.prev.next = this.next;
        }

        Tag(String string, int n) {
            this.url = string;
            this.beg = n;
            this.end = -1;
        }

        Tag() {
            this.next = this.prev = this;
            this.end = -1;
            this.beg = -1;
        }
    }
}

