/*
 * Decompiled with CFR 0.152.
 */
package DreamBookMIDlet.Dictionary;

import DreamBookMIDlet.CharSets;
import DreamBookMIDlet.Dictionary.WordsOffsets;
import java.io.DataInputStream;

public class Words {
    private static final String fileName = "/DreamBookMIDlet/Data/Words.txt";
    private static final int fileSize = 10365;
    private WordsOffsets wordsOffsets = new WordsOffsets();
    private String words;

    public Words() {
        try {
            char[] chars = new char[10365];
            byte[] buffer = new byte[10365];
            DataInputStream dataInputStream = new DataInputStream(Class.forName("java.lang.Class").getResourceAsStream(fileName));
            dataInputStream.read(buffer);
            dataInputStream.close();
            System.gc();
            int i = 0;
            while (i < 10365) {
                chars[i] = CharSets.CP1251[buffer[i] & 0xFF];
                ++i;
            }
            this.words = new String(chars);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getWord(int index) {
        int offset0 = this.wordsOffsets.getOffset(index);
        int offset1 = this.wordsOffsets.getOffset(index + 1);
        return this.words.substring(offset0, offset1 - 1);
    }

    public int[] searchWords(String word) {
        int[] searchedWordsIndexes = null;
        int currentOffset = -1;
        while ((currentOffset = this.words.indexOf(word, currentOffset + 1)) != -1) {
            int index = this.wordsOffsets.getIndex(currentOffset);
            if (searchedWordsIndexes != null) {
                int[] tempSearchedWordsIndexes = new int[searchedWordsIndexes.length + 1];
                System.arraycopy(searchedWordsIndexes, 0, tempSearchedWordsIndexes, 0, searchedWordsIndexes.length);
                tempSearchedWordsIndexes[searchedWordsIndexes.length] = index;
                searchedWordsIndexes = tempSearchedWordsIndexes;
                System.gc();
                continue;
            }
            searchedWordsIndexes = new int[]{index};
        }
        return searchedWordsIndexes;
    }

    static {
        fileName = fileName;
        fileSize = 10365;
    }
}

