/*
 * Decompiled with CFR 0.152.
 */
package net.benhui.btgallery.browser;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.bluetooth.DeviceClass;
import javax.bluetooth.RemoteDevice;
import javax.microedition.io.Connection;
import net.benhui.btgallery.browser.BBServiceRecord;

public class BBRemoteDevice
extends RemoteDevice {
    public String bluetoothAddress = null;
    public DeviceClass deviceClass = null;
    public int discoveryMode = 10390323;
    public long discoveryTime = 0L;
    public String friendyName = null;
    public boolean hasServiceRecord = false;
    public int inquiryCount = 0;
    public long inquiryTime = 0L;
    public boolean isAuthenticated = false;
    public boolean isAuthorized = false;
    public boolean isEncrypted = false;
    public boolean isTrustedDevice = false;
    public RemoteDevice original = null;
    public int presistentMode = 0;
    public int rmsRecordId = -1;
    public Vector serviceRecords = new Vector();

    public BBRemoteDevice(String address, DataInputStream data_in, int record_id) {
        super(address);
        this.deserialize(data_in);
        this.presistentMode = 1;
        this.rmsRecordId = record_id;
    }

    public BBRemoteDevice(RemoteDevice src, DeviceClass device_class, int discovery_mode) {
        super(src.getBluetoothAddress());
        this.original = src;
        this.discoveryMode = discovery_mode;
        this.deviceClass = device_class;
        try {
            this.friendyName = src.getFriendlyName(false);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.bluetoothAddress = src.getBluetoothAddress();
        this.isAuthenticated = src.isAuthenticated();
        this.isEncrypted = src.isEncrypted();
        this.isTrustedDevice = src.isTrustedDevice();
    }

    public boolean authenticate() throws IOException {
        return false;
    }

    public boolean authorize(Connection connection) throws IOException {
        return false;
    }

    public void deserialize(DataInputStream data_in) {
        try {
            this.bluetoothAddress = data_in.readUTF();
            this.deviceClass = new DeviceClass(data_in.readInt());
            this.discoveryMode = data_in.readInt();
            this.hasServiceRecord = data_in.readBoolean();
            this.friendyName = data_in.readUTF();
            this.isAuthenticated = data_in.readBoolean();
            this.isAuthorized = data_in.readBoolean();
            this.isEncrypted = data_in.readBoolean();
            this.isTrustedDevice = data_in.readBoolean();
            this.inquiryTime = data_in.readLong();
            this.discoveryTime = data_in.readLong();
            this.inquiryCount = data_in.readInt();
            int size = data_in.readInt();
            int j = 0;
            while (j < size) {
                BBServiceRecord record = new BBServiceRecord(this, data_in);
                this.serviceRecords.addElement(record);
                this.hasServiceRecord = true;
                ++j;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean encrypt(Connection connection, boolean boolean1) throws IOException {
        return false;
    }

    public String getBluetoothAddress2() {
        return this.bluetoothAddress;
    }

    public String getFriendlyName(boolean boolean0) throws IOException {
        return this.friendyName;
    }

    public static RemoteDevice getRemoteDevice(Connection connection) throws IOException {
        return null;
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public boolean isAuthorized(Connection connection) throws IOException {
        return false;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public boolean isTrustedDevice() {
        return this.isTrustedDevice;
    }

    public void serialize(DataOutputStream data_out) {
        try {
            data_out.writeUTF(this.bluetoothAddress);
            data_out.writeInt(this.deviceClass.getMajorDeviceClass() | this.deviceClass.getMinorDeviceClass() | this.deviceClass.getServiceClasses());
            data_out.writeInt(this.discoveryMode);
            data_out.writeBoolean(this.hasServiceRecord);
            data_out.writeUTF(this.friendyName);
            data_out.writeBoolean(this.isAuthenticated);
            data_out.writeBoolean(this.isAuthorized);
            data_out.writeBoolean(this.isEncrypted);
            data_out.writeBoolean(this.isTrustedDevice);
            data_out.writeLong(this.inquiryTime);
            data_out.writeLong(this.discoveryTime);
            data_out.writeInt(this.inquiryCount);
            data_out.writeInt(this.serviceRecords.size());
            int j = 0;
            while (j < this.serviceRecords.size()) {
                BBServiceRecord record = (BBServiceRecord)this.serviceRecords.elementAt(j);
                record.serialize(data_out);
                ++j;
            }
            data_out.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

