/*
 * Decompiled with CFR 0.152.
 */
package paint;

import com.motorola.io.FileConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import jpegdata.f;
import paint.CMain;
import paint.DColorTarget;
import paint.DGetString;
import paint.DOpenFile;
import paint.DSaveFile;
import paint.DSettings;
import paint.Ellipse;
import paint.FilledEllipse;
import paint.FilledPoly;
import paint.ISetColorReceiver;
import paint.ImageTool;
import paint.Line;
import paint.OSM;
import paint.Pencil;
import paint.Rect;
import paint.SettingsStore;
import paint.Shape;
import paint.ShapeViewer;
import paint.Text;

public class DMain
extends Canvas
implements ISetColorReceiver {
    static DMain inst;
    private int softbar_h = 20;
    static int height;
    static int width;
    static int TOOL_NONE;
    static int TOOL_PENCIL;
    static int TOOL_LINE;
    static int TOOL_RECT;
    static int TOOL_ELLIPSE;
    static int TOOL_TEXT;
    static int TOOL_IMAGE;
    static int TOOL_ELLIPSE_FS;
    static int TOOL_ELLIPSE_F;
    static int TOOL_POLY_FS;
    static int TOOL_POLY_F;
    static int TOOL_EYEDROPPER;
    static int TOOL_ENUMERATOR;
    OSM osm;
    ShapeViewer sv;
    boolean osm_visible;
    boolean old_osmvis;
    Vector shapes;
    int curtool;
    int oldtool;
    int sR;
    int sG;
    int sB;
    int fR;
    int fG;
    int fB;
    Image img;
    Image imgCur;
    boolean smallStep = true;
    boolean needConf = false;
    int x;
    int y;
    static String excmsg;

    public DMain() {
        inst = this;
        this.setFullScreenMode(true);
        width = this.getWidth();
        height = this.getHeight() + this.softbar_h;
        this.img = Image.createImage((int)width, (int)height);
        this.shapes = new Vector();
        try {
            this.imgCur = Image.createImage((String)"/cursor.png");
        }
        catch (IOException iOException) {
            DMain.ShowAlert("Error", "Unable to open /cursor.png");
        }
        this.sv = new ShapeViewer();
        this.osm = new OSM("tools");
        this.osm_visible = true;
        this.osm.setFocus(true);
        this.curtool = TOOL_PENCIL;
    }

    protected void paint(Graphics graphics) {
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, 0);
        } else {
            this.img = Image.createImage((int)width, (int)height);
            for (int i = 0; i < this.shapes.size(); ++i) {
                ((Shape)this.shapes.elementAt(i)).draw(this.img.getGraphics());
            }
            this.repaint();
        }
        if (this.osm_visible && this.curtool != TOOL_ENUMERATOR) {
            this.osm.paint(graphics);
        }
        if (this.curtool == TOOL_ENUMERATOR) {
            this.sv.paint(graphics);
        }
        if (this.curtool == TOOL_EYEDROPPER) {
            String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(this.x)))).append(":").append(Integer.toString(this.y))));
            int n = Font.getDefaultFont().stringWidth(string);
            int n2 = this.x + this.imgCur.getWidth() / 2;
            int n3 = this.y + this.imgCur.getWidth() / 2;
            if (n2 + n > width) {
                n2 -= n;
            }
            if (n3 + Font.getDefaultFont().getHeight() > height) {
                n3 -= Font.getDefaultFont().getHeight();
            }
            graphics.setColor(0xFFFFFF);
            graphics.drawString(string, n2 + 1, n3 + 1, 0);
            graphics.setColor(0);
            graphics.drawString(string, n2, n3, 0);
        }
        if (!this.osm.getFocus()) {
            graphics.drawImage(this.imgCur, this.x - this.imgCur.getWidth() / 2, this.y - this.imgCur.getHeight() / 2, 0);
        }
        if (this.needConf) {
            Shape shape = (Shape)this.shapes.lastElement();
            shape.drawPreview(graphics, this.x, this.y);
            shape = null;
        }
        System.gc();
    }

    protected void keyPressed(int n) {
        boolean bl = this.osm.keyPressed(n);
        if (this.curtool == TOOL_ENUMERATOR) {
            this.sv.keyPressed(n);
            this.repaint();
            if (this.curtool != TOOL_PENCIL) {
                Pencil.index = -1;
            }
            return;
        }
        if (n != 42) {
            excmsg = String.valueOf(String.valueOf(excmsg)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Integer.toString(n))).concat(", "))));
        }
        switch (n) {
            case -23: 
            case 23: {
                this.osm.MakeSelection(SettingsStore.softkeys[1]);
                break;
            }
            case -22: 
            case 22: {
                this.osm.MakeSelection(SettingsStore.softkeys[2]);
                break;
            }
            case -21: 
            case 21: {
                this.osm.MakeSelection(SettingsStore.softkeys[0]);
                break;
            }
            case 35: {
                if (this.curtool == TOOL_ENUMERATOR) break;
                this.osm_visible = !this.osm_visible;
                this.osm.setFocus(this.osm_visible);
                break;
            }
            case 42: {
                this.smallStep = !this.smallStep;
                break;
            }
            case 49: {
                if (this.osm.getFocus()) break;
                this.y -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y < 0) {
                    this.y = this.needConf ? 0 : height;
                }
                this.x -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x >= 0) break;
                if (this.needConf) {
                    this.x = 0;
                    break;
                }
                this.x = width;
                break;
            }
            case 48: {
                this.osm.setFocus(!this.osm.getFocus());
                break;
            }
            case -1: 
            case 1: 
            case 50: {
                if (this.osm.getFocus()) break;
                this.y -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y >= 0) break;
                if (this.needConf) {
                    this.y = 0;
                    break;
                }
                this.y = height;
                break;
            }
            case 51: {
                if (this.osm.getFocus()) break;
                this.y -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y < 0) {
                    this.y = this.needConf ? 0 : height;
                }
                this.x += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x <= width) break;
                if (this.needConf) {
                    this.x = width;
                    break;
                }
                this.x = 0;
                break;
            }
            case -2: 
            case 2: 
            case 52: {
                if (this.osm.getFocus()) break;
                this.x -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x >= 0) break;
                if (this.needConf) {
                    this.x = 0;
                    break;
                }
                this.x = width;
                break;
            }
            case -5: 
            case 5: 
            case 54: {
                if (this.osm.getFocus()) break;
                this.x += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x <= width) break;
                if (this.needConf) {
                    this.x = width;
                    break;
                }
                this.x = 0;
                break;
            }
            case -6: 
            case 6: 
            case 56: {
                if (this.osm.getFocus()) break;
                this.y += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y <= height) break;
                if (this.needConf) {
                    this.y = height;
                    break;
                }
                this.y = 0;
                break;
            }
            case 55: {
                if (this.osm.getFocus()) break;
                this.x -= this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x < 0) {
                    this.x = this.needConf ? 0 : width;
                }
                this.y += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y <= height) break;
                if (this.needConf) {
                    this.y = height;
                    break;
                }
                this.y = 0;
                break;
            }
            case 57: {
                if (this.osm.getFocus()) break;
                this.x += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.x > width) {
                    this.x = this.needConf ? width : 0;
                }
                this.y += this.smallStep ? SettingsStore.sm_step : SettingsStore.b_step;
                if (this.y <= height) break;
                if (this.needConf) {
                    this.y = height;
                    break;
                }
                this.y = 0;
                break;
            }
            case -20: 
            case -10: 
            case 20: 
            case 53: {
                this.ProceedSelect(bl);
            }
        }
        this.repaint();
        if (this.curtool != TOOL_PENCIL) {
            Pencil.index = -1;
        }
    }

    private void ProceedSelect(boolean bl) {
        if (this.osm.getFocus() && bl) {
            this.osm_select();
        } else if (!this.osm.getFocus()) {
            if (this.curtool == TOOL_ELLIPSE) {
                if (!this.needConf) {
                    this.shapes.addElement(new Ellipse(this.x, this.y, this.sR, this.sG, this.sB));
                    this.needConf = true;
                } else {
                    Ellipse ellipse = (Ellipse)this.shapes.lastElement();
                    ellipse.set2(this.x, this.y);
                    ellipse.draw(this.img.getGraphics());
                    this.needConf = false;
                    ellipse = null;
                }
            } else if (this.curtool == TOOL_ELLIPSE_FS) {
                if (!this.needConf) {
                    this.shapes.addElement(new FilledEllipse(this.x, this.y, this.sR, this.sG, this.sB, this.fR, this.fG, this.fB));
                    this.needConf = true;
                } else {
                    FilledEllipse filledEllipse = (FilledEllipse)this.shapes.lastElement();
                    filledEllipse.set2(this.x, this.y);
                    filledEllipse.draw(this.img.getGraphics());
                    this.needConf = false;
                    filledEllipse = null;
                }
            } else if (this.curtool == TOOL_ELLIPSE_F) {
                if (!this.needConf) {
                    this.shapes.addElement(new FilledEllipse(this.x, this.y, this.fR, this.fG, this.fB, this.fR, this.fG, this.fB));
                    this.needConf = true;
                } else {
                    FilledEllipse filledEllipse = (FilledEllipse)this.shapes.lastElement();
                    filledEllipse.set2(this.x, this.y);
                    filledEllipse.draw(this.img.getGraphics());
                    this.needConf = false;
                    filledEllipse = null;
                }
            } else if (this.curtool == TOOL_EYEDROPPER) {
                int[] nArray = new int[1];
                this.img.getRGB(nArray, 0, this.img.getWidth(), this.x, this.y, 1, 1);
                int n = nArray[0];
                int n2 = n & 0xFF;
                int n3 = n & 0xFF00;
                int n4 = n & 0xFF0000;
                this.sR = n4 >>= 16;
                this.sG = n3 >>= 8;
                this.sB = n2;
                this.osm_visible = this.old_osmvis;
                this.osm.setFocus(this.old_osmvis);
            } else if (this.curtool == TOOL_LINE) {
                if (!this.needConf) {
                    this.shapes.addElement(new Line(this.x, this.y, this.sR, this.sG, this.sB));
                    this.needConf = true;
                } else {
                    ((Line)this.shapes.lastElement()).set2(this.x, this.y);
                    ((Line)this.shapes.lastElement()).draw(this.img.getGraphics());
                    this.needConf = false;
                }
            } else if (this.curtool == TOOL_PENCIL) {
                Pencil pencil;
                int n = Pencil.index;
                if (n < 0) {
                    this.shapes.addElement(new Pencil(this.sR, this.sG, this.sB));
                    n = this.shapes.size() - 1;
                }
                if ((pencil = (Pencil)this.shapes.elementAt(n)).getPointCount() >= 1) {
                    Pencil.Point point = pencil.GetPoint(pencil.getPointCount() - 1);
                    if (point.X == this.x && point.Y == this.y) {
                        Pencil.index = -1;
                        return;
                    }
                }
                pencil.AddPoint(this.x, this.y);
                ((Pencil)this.shapes.elementAt(n)).draw(this.img.getGraphics());
                Pencil.index = n;
                pencil = null;
            } else if (this.curtool == TOOL_POLY_F || this.curtool == TOOL_POLY_FS) {
                FilledPoly filledPoly;
                int n = FilledPoly.index;
                if (n < 0) {
                    int n5 = this.sR;
                    int n6 = this.sG;
                    int n7 = this.sB;
                    if (this.curtool == TOOL_POLY_F) {
                        n5 = this.fR;
                        n6 = this.fG;
                        n7 = this.fB;
                    }
                    this.shapes.addElement(new FilledPoly(n5, n6, n7, this.fR, this.fG, this.fB));
                    n = this.shapes.size() - 1;
                }
                if ((filledPoly = (FilledPoly)this.shapes.elementAt(n)).getPointCount() >= 1) {
                    Pencil.Point point = filledPoly.GetPoint(filledPoly.getPointCount() - 1);
                    if (point.X == this.x && point.Y == this.y) {
                        FilledPoly.index = -1;
                        return;
                    }
                }
                filledPoly.AddPoint(this.x, this.y);
                ((FilledPoly)this.shapes.elementAt(n)).draw(this.img.getGraphics());
                FilledPoly.index = n;
                filledPoly = null;
            } else if (this.curtool == TOOL_RECT) {
                if (!this.needConf) {
                    this.shapes.addElement(new Rect(this.x, this.y, this.sR, this.sG, this.sB));
                    this.needConf = true;
                } else {
                    Rect rect = (Rect)this.shapes.lastElement();
                    rect.set2(this.x, this.y);
                    rect.draw(this.img.getGraphics());
                    this.needConf = false;
                    rect = null;
                }
            } else if (this.curtool == TOOL_TEXT) {
                if (this.needConf) {
                    Text text = (Text)this.shapes.lastElement();
                    text.x1 = this.x;
                    text.y1 = this.y;
                    text.draw(this.img.getGraphics());
                    this.needConf = false;
                    this.osm.setFocus(this.old_osmvis);
                    this.osm_visible = this.old_osmvis;
                    text = null;
                }
            } else if (this.curtool == TOOL_IMAGE && this.needConf) {
                ImageTool imageTool = (ImageTool)this.shapes.lastElement();
                imageTool.x1 = this.x;
                imageTool.y1 = this.y;
                imageTool.draw(this.img.getGraphics());
                this.needConf = false;
                this.osm.setFocus(this.old_osmvis);
                this.osm_visible = this.old_osmvis;
                imageTool = null;
            }
        }
        System.gc();
    }

    void osm_select() {
        String string = this.osm.getCurMenu();
        if (string.compareTo("root") == 0) {
            switch (this.osm.getSelectedIndex()) {
                case 0: {
                    this.ResetData();
                    this.repaint();
                    break;
                }
                case 1: {
                    DSaveFile dSaveFile = new DSaveFile();
                    CMain.display.setCurrent((Displayable)dSaveFile);
                    dSaveFile = null;
                    break;
                }
                case 2: {
                    DOpenFile dOpenFile = new DOpenFile(new String[]{".pnt"}, true, SettingsStore.prevRes);
                    CMain.display.setCurrent((Displayable)dOpenFile);
                    dOpenFile = null;
                    break;
                }
                case 3: {
                    DSettings dSettings = new DSettings(SettingsStore.sm_step, SettingsStore.b_step, SettingsStore.intl_scale);
                    CMain.display.setCurrent((Displayable)dSettings);
                    dSettings = null;
                }
            }
        } else if (string.compareTo("drawopts") == 0) {
            if (this.osm.getSelectedIndex() == 2 && !this.needConf) {
                this.oldtool = this.curtool;
                this.curtool = TOOL_ENUMERATOR;
                this.sv.ToolInvoked();
            }
        } else if (string.compareTo("colors") == 0) {
            switch (this.osm.getSelectedIndex()) {
                case 0: {
                    DColorTarget dColorTarget = new DColorTarget(new int[]{this.sR, this.sG, this.sB, this.fR, this.fG, this.fB}, false, this);
                    CMain.display.setCurrent((Displayable)dColorTarget);
                    dColorTarget = null;
                    break;
                }
                case 1: {
                    DColorTarget dColorTarget = new DColorTarget(new int[]{this.sR, this.sG, this.sB, this.fR, this.fG, this.fB}, true, this);
                    CMain.display.setCurrent((Displayable)dColorTarget);
                    dColorTarget = null;
                    break;
                }
                case 2: {
                    if (this.needConf) break;
                    this.curtool = TOOL_EYEDROPPER;
                    this.old_osmvis = this.osm_visible;
                    this.osm_visible = false;
                    this.osm.setFocus(false);
                }
            }
        } else if (string.compareTo("tools") == 0) {
            if (this.needConf) {
                return;
            }
            switch (this.osm.getSelectedIndex()) {
                case 2: {
                    this.curtool = TOOL_TEXT;
                    CMain.display.setCurrent((Displayable)new DGetString());
                    this.old_osmvis = this.osm_visible;
                    this.osm_visible = false;
                    this.osm.setFocus(false);
                    this.needConf = true;
                    break;
                }
                case 3: {
                    this.curtool = TOOL_IMAGE;
                    this.old_osmvis = this.osm_visible;
                    this.osm_visible = false;
                    this.osm.setFocus(false);
                    CMain.display.setCurrent((Displayable)new DOpenFile(new String[]{".jpg", ".gif", ".jpeg", ".png"}, false, SettingsStore.prevRes));
                    this.needConf = true;
                }
            }
        } else if (string.compareTo("stools") == 0) {
            switch (this.osm.getSelectedIndex()) {
                case 0: {
                    this.curtool = TOOL_PENCIL;
                    break;
                }
                case 1: {
                    this.curtool = TOOL_LINE;
                    break;
                }
                case 2: {
                    this.curtool = TOOL_RECT;
                    break;
                }
                case 3: {
                    this.curtool = TOOL_ELLIPSE;
                }
            }
        } else if (string.compareTo("ftools") == 0) {
            switch (this.osm.getSelectedIndex()) {
                case 0: {
                    this.curtool = TOOL_POLY_FS;
                    break;
                }
                case 1: {
                    this.curtool = TOOL_ELLIPSE_FS;
                    break;
                }
                case 2: {
                    this.curtool = TOOL_POLY_F;
                    break;
                }
                case 3: {
                    this.curtool = TOOL_ELLIPSE_F;
                }
            }
        }
        System.gc();
    }

    void ResetData() {
        System.gc();
        this.shapes = new Vector();
        this.img = Image.createImage((int)width, (int)height);
        this.fB = 0;
        this.fG = 0;
        this.fR = 0;
        this.sB = 0;
        this.sG = 0;
        this.sR = 0;
        this.y = 0;
        this.x = 0;
        this.needConf = false;
        this.smallStep = true;
        this.curtool = TOOL_PENCIL;
        this.osm_visible = true;
        this.osm.setFocus(true);
        Pencil.index = -1;
        FilledPoly.index = -1;
        System.gc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void DeleteFile(String string) {
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)string);
            fileConnection.delete();
            fileConnection.close();
        }
        catch (IOException iOException) {
            return;
        }
        try {
            if (fileConnection != null) {
                fileConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        fileConnection = null;
        System.gc();
    }

    public void SaveFile(String string) {
        this.Serialize(String.valueOf(String.valueOf(string)).concat(".pnt"));
        CMain.display.setCurrent((Displayable)inst);
    }

    /*
     * Loose catch block
     */
    public void SaveFileJPG(String string) {
        block17: {
            byte[] byArray = f.o(this.img);
            FileConnection fileConnection = null;
            DataOutputStream dataOutputStream = null;
            fileConnection = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file:///a/mobile/picture/").append(string).append(".jpg"))));
            fileConnection.create();
            fileConnection.setHidden(false);
            fileConnection.setReadable(true);
            fileConnection.setWriteable(true);
            dataOutputStream = fileConnection.openDataOutputStream();
            dataOutputStream.write(byArray);
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            dataOutputStream = null;
            fileConnection = null;
            byArray = null;
            System.gc();
            break block17;
            catch (IOException iOException) {}
            {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.flush();
                        dataOutputStream.close();
                    }
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                dataOutputStream = null;
                fileConnection = null;
                byArray = null;
                System.gc();
                try {
                }
                catch (Throwable throwable) {
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.flush();
                            dataOutputStream.close();
                        }
                        if (fileConnection != null) {
                            fileConnection.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    dataOutputStream = null;
                    fileConnection = null;
                    byArray = null;
                    System.gc();
                    throw throwable;
                }
            }
        }
        CMain.display.setCurrent((Displayable)inst);
    }

    public void LoadFile(String string) {
        inst.Deserialize(string, true);
        CMain.display.setCurrent((Displayable)inst);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void Serialize(String string) {
        FilterOutputStream filterOutputStream = null;
        FileConnection fileConnection = null;
        String string2 = "/a/mobile/picture/";
        try {
            String string3 = String.valueOf(String.valueOf(new StringBuffer("file://").append(string2).append(string)));
            fileConnection = (FileConnection)Connector.open((String)string3);
            if (fileConnection.exists()) {
                this.DeleteFile(string3);
            }
            fileConnection.create();
            fileConnection.setHidden(false);
            fileConnection.setReadable(true);
            fileConnection.setWriteable(true);
            filterOutputStream = fileConnection.openDataOutputStream();
            ((DataOutputStream)filterOutputStream).writeByte(152);
        }
        catch (IOException iOException) {
            return;
            catch (Exception exception) {}
            {
                try {
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                filterOutputStream = null;
                fileConnection = null;
                System.gc();
                return;
            }
        }
        for (int i = 0; i < this.shapes.size(); ++i) {
            Shape shape;
            Shape shape2 = (Shape)this.shapes.elementAt(i);
            int n = shape2.getType();
            ((DataOutputStream)filterOutputStream).writeByte(n);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.x1);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.y1);
            ((DataOutputStream)filterOutputStream).writeShort(shape2.x2);
            System.out.println(shape2.y2);
            ((DataOutputStream)filterOutputStream).writeShort(shape2.y2);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.r);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.g);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.b);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.rf);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.gf);
            ((DataOutputStream)filterOutputStream).writeByte(shape2.bf);
            if (n == TOOL_PENCIL || n == TOOL_POLY_F || n == TOOL_POLY_FS) {
                shape = (Pencil)shape2;
                ((DataOutputStream)filterOutputStream).writeShort(shape.getPointCount());
                for (int j = 0; j < shape.getPointCount(); ++j) {
                    Pencil.Point point = shape.GetPoint(j);
                    ((DataOutputStream)filterOutputStream).writeByte(point.X);
                    ((DataOutputStream)filterOutputStream).writeByte(point.Y);
                }
                shape = null;
            } else if (n == TOOL_TEXT) {
                shape = (Text)shape2;
                ((DataOutputStream)filterOutputStream).writeUTF(((Text)shape).content);
                shape = null;
            } else if (n == TOOL_IMAGE) {
                shape = (ImageTool)shape2;
                ((DataOutputStream)filterOutputStream).writeShort(((ImageTool)shape).width);
                ((DataOutputStream)filterOutputStream).writeShort(((ImageTool)shape).height);
                ((DataOutputStream)filterOutputStream).writeShort(((ImageTool)shape).scale);
                ((DataOutputStream)filterOutputStream).writeUTF(DOpenFile.getFileName(((ImageTool)shape).path));
                shape = null;
            }
            shape2 = null;
        }
        try {
            if (filterOutputStream != null) {
                filterOutputStream.close();
            }
            if (fileConnection != null) {
                fileConnection.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        filterOutputStream = null;
        fileConnection = null;
        System.gc();
    }

    /*
     * Loose catch block
     */
    public void Deserialize(String string, boolean bl) {
        block22: {
            FileConnection fileConnection;
            FilterInputStream filterInputStream;
            block21: {
                filterInputStream = null;
                fileConnection = null;
                String string2 = "/a/mobile/picture/";
                if (bl) {
                    this.ResetData();
                }
                fileConnection = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file://").append(string2).append(string))));
                filterInputStream = fileConnection.openDataInputStream();
                int n = ((DataInputStream)filterInputStream).readUnsignedByte();
                if (n >> 7 == 1) {
                    if ((n & 0x7F) == 24) {
                        this.Deserialize24((DataInputStream)filterInputStream, (int)fileConnection.fileSize(), 1);
                    }
                    break block21;
                }
                if (n >> 7 == 0) {
                    this.Deserialize23((DataInputStream)filterInputStream, (int)fileConnection.fileSize(), 1, n);
                    break block21;
                }
                System.err.println("[MPNT] Version of the file is not supported");
                DMain.ShowAlert("Error", String.valueOf(String.valueOf(new StringBuffer("Version \"").append(Integer.toString(n & 0x7F)).append("\" is not supported"))));
            }
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            filterInputStream = null;
            fileConnection = null;
            this.img = null;
            System.gc();
            break block22;
            catch (IOException iOException) {}
            {
                try {
                    if (filterInputStream != null) {
                        filterInputStream.close();
                    }
                    if (fileConnection != null) {
                        fileConnection.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                filterInputStream = null;
                fileConnection = null;
                this.img = null;
                System.gc();
                try {
                }
                catch (Throwable throwable) {
                    try {
                        if (filterInputStream != null) {
                            filterInputStream.close();
                        }
                        if (fileConnection != null) {
                            fileConnection.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    filterInputStream = null;
                    fileConnection = null;
                    this.img = null;
                    System.gc();
                    throw throwable;
                }
            }
        }
        this.repaint();
    }

    public void Deserialize24(DataInputStream dataInputStream, int n, int n2) {
        try {
            int n3 = n2;
            while (n3 < n) {
                int n4;
                int n5;
                int n6;
                int n7 = dataInputStream.readUnsignedByte();
                int n8 = dataInputStream.readUnsignedByte();
                int n9 = dataInputStream.readUnsignedByte();
                int n10 = dataInputStream.readUnsignedShort();
                int n11 = dataInputStream.readUnsignedShort();
                int n12 = dataInputStream.readUnsignedByte();
                int n13 = dataInputStream.readUnsignedByte();
                int n14 = dataInputStream.readUnsignedByte();
                int n15 = dataInputStream.readUnsignedByte();
                int n16 = dataInputStream.readUnsignedByte();
                int n17 = dataInputStream.readUnsignedByte();
                n3 += 13;
                if (n7 == TOOL_ELLIPSE) {
                    this.shapes.addElement(new Ellipse(n8, n9, n10, n11, n12, n13, n14));
                } else if (n7 == TOOL_LINE) {
                    this.shapes.addElement(new Line(n8, n9, n10, n11, n12, n13, n14));
                } else if (n7 == TOOL_PENCIL) {
                    this.shapes.addElement(new Pencil(n12, n13, n14));
                } else if (n7 == TOOL_RECT) {
                    this.shapes.addElement(new Rect(n8, n9, n10, n11, n12, n13, n14));
                } else if (n7 == TOOL_TEXT) {
                    this.shapes.addElement(new Text("", n12, n13, n14, n8, n9));
                } else if (n7 == TOOL_ELLIPSE_F) {
                    this.shapes.addElement(new FilledEllipse(n8, n9, n10, n11, n15, n16, n17, n15, n16, n17));
                } else if (n7 == TOOL_ELLIPSE_FS) {
                    this.shapes.addElement(new FilledEllipse(n8, n9, n10, n11, n12, n13, n14, n15, n16, n17));
                } else if (n7 == TOOL_POLY_F) {
                    this.shapes.addElement(new FilledPoly(n15, n16, n17, n15, n16, n17));
                } else if (n7 == TOOL_POLY_FS) {
                    this.shapes.addElement(new FilledPoly(n12, n13, n14, n15, n16, n17));
                }
                if (n7 == TOOL_PENCIL || n7 == TOOL_POLY_F || n7 == TOOL_POLY_FS) {
                    n6 = dataInputStream.readUnsignedShort();
                    n3 += 2;
                    for (n5 = 0; n5 < n6; ++n5) {
                        n4 = dataInputStream.readUnsignedByte();
                        int n18 = dataInputStream.readUnsignedByte();
                        n3 += 2;
                        if (n7 == TOOL_PENCIL) {
                            ((Pencil)this.shapes.lastElement()).AddPoint(n4, n18);
                            continue;
                        }
                        ((FilledPoly)this.shapes.lastElement()).AddPoint(n4, n18);
                    }
                    continue;
                }
                if (n7 == TOOL_TEXT) {
                    String string;
                    ((Text)this.shapes.lastElement()).content = string = dataInputStream.readUTF();
                    n3 += string.length() + 2;
                    continue;
                }
                if (n7 != TOOL_IMAGE) continue;
                n6 = dataInputStream.readUnsignedShort();
                n5 = dataInputStream.readUnsignedShort();
                n4 = dataInputStream.readUnsignedShort();
                n3 += 6;
                String string = dataInputStream.readUTF();
                n3 += string.length() + 2;
                ImageTool imageTool = new ImageTool("file:///a/mobile/picture/".concat(String.valueOf(String.valueOf(string))), n6, n5, n8, n9, n10, n11, n4);
                imageTool.Load();
                this.shapes.addElement(imageTool);
                imageTool = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void Deserialize23(DataInputStream dataInputStream, int n, int n2, int n3) {
        try {
            int n4 = n2;
            boolean bl = false;
            while (n4 < n) {
                int n5;
                int n6;
                int n7;
                int n8;
                if (bl) {
                    n8 = dataInputStream.readUnsignedByte();
                } else {
                    n8 = n3;
                    bl = true;
                }
                int n9 = dataInputStream.readUnsignedByte();
                int n10 = dataInputStream.readUnsignedByte();
                int n11 = dataInputStream.readUnsignedShort();
                int n12 = dataInputStream.readUnsignedShort();
                int n13 = dataInputStream.readUnsignedByte();
                int n14 = dataInputStream.readUnsignedByte();
                int n15 = dataInputStream.readUnsignedByte();
                n4 += 10;
                if (n8 == TOOL_ELLIPSE) {
                    this.shapes.addElement(new Ellipse(n9, n10, n11, n12, n13, n14, n15));
                } else if (n8 == TOOL_LINE) {
                    this.shapes.addElement(new Line(n9, n10, n11, n12, n13, n14, n15));
                } else if (n8 == TOOL_PENCIL) {
                    this.shapes.addElement(new Pencil(n13, n14, n15));
                } else if (n8 == TOOL_RECT) {
                    this.shapes.addElement(new Rect(n9, n10, n11, n12, n13, n14, n15));
                } else if (n8 == TOOL_TEXT) {
                    this.shapes.addElement(new Text("", n13, n14, n15, n9, n10));
                }
                if (n8 == TOOL_PENCIL) {
                    n7 = dataInputStream.readUnsignedShort();
                    n4 += 2;
                    for (n6 = 0; n6 < n7; ++n6) {
                        n5 = dataInputStream.readUnsignedByte();
                        int n16 = dataInputStream.readUnsignedByte();
                        n4 += 2;
                        ((Pencil)this.shapes.lastElement()).AddPoint(n5, n16);
                    }
                    continue;
                }
                if (n8 == TOOL_TEXT) {
                    String string;
                    ((Text)this.shapes.lastElement()).content = string = dataInputStream.readUTF();
                    n4 += string.length() + 2;
                    continue;
                }
                if (n8 != TOOL_IMAGE) continue;
                n7 = dataInputStream.readUnsignedShort();
                n6 = dataInputStream.readUnsignedShort();
                n5 = dataInputStream.readUnsignedShort();
                n4 += 6;
                String string = dataInputStream.readUTF();
                n4 += string.length() + 2;
                ImageTool imageTool = new ImageTool("file:///a/mobile/picture/".concat(String.valueOf(String.valueOf(string))), n7, n6, n9, n10, n11, n12, n5);
                imageTool.Load();
                this.shapes.addElement(imageTool);
                imageTool = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void ShowAlert(String string, String string2) {
        Alert alert = new Alert(string, string2, null, AlertType.INFO);
        alert.setTimeout(-2);
        CMain.display.setCurrent((Displayable)alert);
        alert = null;
        System.gc();
    }

    public void ColorSet(int n, int n2, int n3) {
        this.sR = n;
        this.sG = n2;
        this.sB = n3;
        CMain.display.setCurrent((Displayable)this);
    }

    public void ColorSetCanceled() {
        CMain.display.setCurrent((Displayable)this);
    }

    public void FillColorSet(int n, int n2, int n3) {
        this.fR = n;
        this.fG = n2;
        this.fB = n3;
        CMain.display.setCurrent((Displayable)this);
    }

    static {
        TOOL_NONE = 0;
        TOOL_PENCIL = 1;
        TOOL_LINE = 2;
        TOOL_RECT = 3;
        TOOL_ELLIPSE = 4;
        TOOL_TEXT = 5;
        TOOL_IMAGE = 6;
        TOOL_ELLIPSE_FS = 7;
        TOOL_ELLIPSE_F = 8;
        TOOL_POLY_FS = 9;
        TOOL_POLY_F = 10;
        TOOL_EYEDROPPER = 20;
        TOOL_ENUMERATOR = 21;
    }
}

