/*
 * Decompiled with CFR 0.152.
 */
package paint;

import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import paint.CMain;
import paint.DColorTarget;
import paint.DGenShapeEditor;
import paint.DMain;
import paint.ISetColorReceiver;
import paint.Rect;
import paint.Shape;

public class ShapeViewer
implements ISetColorReceiver {
    int curindex;
    Shape curshape;
    boolean bfirst;
    boolean blast;
    static String[] toolnames = new String[]{"\u041d\u0435\u0442", "\u041c\u043d\u043e\u0433\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0438\u043a", "\u041b\u0438\u043d\u0438\u044f", "\u041f\u0440\u044f\u043c\u043e\u0443\u0433\u043e\u043b\u044c\u043d\u0438\u043a", "\u042d\u043b\u043b\u0438\u043f\u0441", "\u0422\u0435\u043a\u0441\u0442", "\u041a\u0430\u0440\u0442\u0438\u043d\u043a\u0430", "\u042d\u043b\u043b\u0438\u043f\u0441 \u0437/\u0433", "\u042d\u043b\u043b\u0438\u043f\u0441 \u0437", "\u041c\u043d\u043e\u0433\u043e\u0443\u0433. \u0437/\u0433", "\u041c\u043d\u043e\u0433\u043e\u0443\u0433. \u0437"};

    void updCurShape() {
        if (this.curindex < 0 || this.curindex >= DMain.inst.shapes.size()) {
            this.curshape = null;
            return;
        }
        this.curshape = (Shape)DMain.inst.shapes.elementAt(this.curindex);
        this.bfirst = this.curindex == 0;
        this.blast = this.curindex == DMain.inst.shapes.size() - 1;
    }

    public ShapeViewer() {
        this.curindex = DMain.inst.shapes.size() - 1;
        this.bfirst = true;
        this.blast = true;
        this.updCurShape();
    }

    public void ToolInvoked() {
        this.curindex = DMain.inst.shapes.size() - 1;
        this.updCurShape();
    }

    public void paint(Graphics graphics) {
        Font font = Font.getDefaultFont();
        int n = font.getHeight() + 4;
        int n2 = DMain.height - n;
        graphics.setColor(0xDDDDDD);
        graphics.fillRect(0, n2, DMain.width - 1, n - 1);
        graphics.setColor(0);
        graphics.drawRect(0, n2, DMain.width - 1, n - 1);
        if (this.curshape == null) {
            graphics.drawString("(\u043d\u0435\u0442 \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432)", 6, n2 + 2, 0);
            return;
        }
        int n3 = n2 + n / 2;
        if (!this.bfirst) {
            graphics.fillTriangle(2, n3 - 1, 4, n3 - 3, 6, n3 - 1);
        }
        if (!this.blast) {
            graphics.fillTriangle(2, n3 + 1, 4, n3 + 3, 6, n3 + 1);
        }
        int n4 = 10;
        String string = toolnames[this.curshape.getType()];
        graphics.drawString(string, n4, n2 + 2, 0);
        int n5 = 4;
        graphics.setColor(this.curshape.r, this.curshape.g, this.curshape.b);
        graphics.fillRect(font.stringWidth(string) + n4 + 5, n3 - n5, n5 * 2, n5 * 2);
        if (this.curshape.type == DMain.TOOL_ELLIPSE_F || this.curshape.type == DMain.TOOL_ELLIPSE_FS || this.curshape.type == DMain.TOOL_POLY_F || this.curshape.type == DMain.TOOL_POLY_FS) {
            graphics.setColor(this.curshape.rf, this.curshape.gf, this.curshape.bf);
            graphics.fillRect(font.stringWidth(string) + n4 + 5 + n5 + 5, n3 - n5, n5 * 2, n5 * 2);
        }
        graphics.setColor(0xDDDDDD);
        int n6 = 2;
        graphics.drawRect(this.curshape.x1 - n6, this.curshape.y1 - n6, n6 * 2, n6 * 2);
        graphics.drawRect(this.curshape.x2 - n6, this.curshape.y2 - n6, n6 * 2, n6 * 2);
        graphics.setColor(0x898989);
        graphics.setStrokeStyle(1);
        int[] nArray = Rect.NormalizeRect(this.curshape.c_x1, this.curshape.c_y1, this.curshape.c_x2, this.curshape.c_y2);
        graphics.drawRect(nArray[0], nArray[1], nArray[2] - nArray[0], nArray[3] - nArray[1]);
        graphics.setStrokeStyle(0);
    }

    public void keyPressed(int n) {
        switch (n) {
            case 50: {
                --this.curindex;
                if (this.curindex >= 0) break;
                this.curindex = 0;
                break;
            }
            case 56: {
                ++this.curindex;
                if (this.curindex < DMain.inst.shapes.size()) break;
                this.curindex = DMain.inst.shapes.size() - 1;
                break;
            }
            case 49: {
                if (this.curindex < 0 || this.curindex >= DMain.inst.shapes.size() || this.curshape == null) {
                    return;
                }
                DMain.inst.shapes.removeElementAt(this.curindex);
                DMain.inst.img = null;
                --this.curindex;
                if (this.curindex >= 0) break;
                this.curindex = 0;
                break;
            }
            case 51: {
                if (this.curindex < 0 || this.curindex >= DMain.inst.shapes.size() || this.curshape == null) {
                    return;
                }
                int[] nArray = new int[]{this.curshape.r, this.curshape.g, this.curshape.b, this.curshape.rf, this.curshape.gf, this.curshape.bf};
                DColorTarget dColorTarget = new DColorTarget(nArray, true, this);
                CMain.display.setCurrent((Displayable)dColorTarget);
                dColorTarget = null;
                break;
            }
            case 53: {
                DGenShapeEditor dGenShapeEditor = new DGenShapeEditor(this.curindex);
                CMain.display.setCurrent((Displayable)dGenShapeEditor);
                dGenShapeEditor = null;
                DMain.inst.img = null;
                break;
            }
            case 35: {
                DMain.inst.curtool = DMain.inst.oldtool;
            }
        }
        this.updCurShape();
    }

    public void ColorSet(int n, int n2, int n3) {
        this.curshape.r = n;
        this.curshape.g = n2;
        this.curshape.b = n3;
        DMain.inst.img = null;
        CMain.display.setCurrent((Displayable)DMain.inst);
    }

    public void ColorSetCanceled() {
        CMain.display.setCurrent((Displayable)DMain.inst);
    }

    public void FillColorSet(int n, int n2, int n3) {
        this.curshape.rf = n;
        this.curshape.gf = n2;
        this.curshape.bf = n3;
        DMain.inst.img = null;
        CMain.display.setCurrent((Displayable)DMain.inst);
    }
}

