/*
 * Decompiled with CFR 0.152.
 */
package paint;

import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import paint.CMain;
import paint.DMain;
import paint.DSetColor;
import paint.ISetColorReceiver;

public class DHSVColor
extends Canvas
implements ISetColorReceiver {
    int r;
    int g;
    int b;
    int org_r;
    int org_g;
    int org_b;
    int h;
    int v;
    int s;
    Image imgCur;
    Image imgHueBar;
    int sm_step;
    int b_step;
    boolean stepSm = true;
    ISetColorReceiver rcvr;

    public DHSVColor(int n, int n2, int n3, ISetColorReceiver iSetColorReceiver) {
        this.setFullScreenMode(true);
        this.rcvr = iSetColorReceiver;
        try {
            this.imgCur = Image.createImage((String)"/cursor.png");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.sm_step = 5;
        this.b_step = 10;
        this.org_r = this.r = n;
        this.org_g = this.g = n2;
        this.org_b = this.b = n3;
        int[] nArray = DHSVColor.RGB_to_HSV(this.r / 2, this.g / 2, this.b / 2);
        this.h = nArray[0];
        this.s = nArray[1];
        this.v = nArray[2];
    }

    static int[] H_to_PureRGB(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = n % 60 * 255 / 60;
        if ((n %= 360) >= 0 && n < 60) {
            n2 = 255;
            n3 = n5;
            n4 = 0;
        }
        if (n >= 60 && n < 120) {
            n2 = 255 - n5;
            n3 = 255;
            n4 = 0;
        }
        if (n >= 120 && n < 180) {
            n2 = 0;
            n3 = 255;
            n4 = n5;
        }
        if (n >= 180 && n < 240) {
            n2 = 0;
            n3 = 255 - n5;
            n4 = 255;
        }
        if (n >= 240 && n < 300) {
            n2 = n5;
            n3 = 0;
            n4 = 255;
        }
        if (n >= 300 && n < 360) {
            n2 = 255;
            n3 = 0;
            n4 = 255 - n5;
        }
        return new int[]{n2, n3, n4};
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, DMain.width, DMain.height);
        int n = DMain.width;
        int n2 = DMain.width / 3;
        int n3 = DMain.height / 6;
        int n4 = DMain.height / 7;
        this.DrawHueBar(graphics, n, n3);
        for (int i = 255; i >= 0; --i) {
            graphics.setColor(i, i, i);
            graphics.drawLine((255 - i) * (n / 3) / 255, n3 + 8, (255 - i) * (n / 3) / 255, n3 + 8 + n4);
        }
        graphics.setColor(0);
        graphics.drawLine((100 - this.s) * (n / 3) / 100, n3 + 8 + n4, (100 - this.s) * (n / 3) / 100, n3 + 11 + n4);
        graphics.drawLine((100 - this.s) * (n / 3) / 100, n3 + 11 + n4, n / 6, n3 + 14 + n4);
        Image image = Image.createImage((int)(2 * (n / 3)), (int)(n4 + 8));
        this.DrawValueBar(image.getGraphics(), n, n4);
        graphics.drawImage(image, n / 3, n3 + 8, 0);
        int[] nArray = new int[1];
        int n5 = this.v * (image.getWidth() - 1) / 100;
        image.getRGB(nArray, 0, image.getWidth(), n5, 0, 1, 1);
        int n6 = nArray[0];
        int n7 = n6 & 0xFF;
        int n8 = n6 & 0xFF00;
        int n9 = n6 & 0xFF0000;
        this.r = n9 >>= 16;
        this.g = n8 >>= 8;
        this.b = n7;
        graphics.setColor(n6);
        int n10 = n / 4;
        int n11 = n3 + 20 + n4;
        graphics.fillRect(n / 2 - n10 / 2, n11, n10, n10 / 2);
        graphics.setColor(this.org_r, this.org_g, this.org_b);
        graphics.fillRect(n / 2 - n10 / 2, n11 + n10 / 2, n10, n10 / 2);
        graphics.setColor(0);
        graphics.drawRect(n / 2 - n10 / 2, n11, n10, n10);
        String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(Integer.toString(this.r)))).append("/").append(Integer.toString(this.g)).append("/").append(Integer.toString(this.b))));
        Font font = Font.getDefaultFont();
        graphics.setColor(0);
        graphics.setFont(font);
        graphics.drawString(string, n / 2 - font.stringWidth(string) / 2, n11 + n10 + 5, 0);
    }

    static int[] RGB_to_HSV(int n, int n2, int n3) {
        int n4 = Math.max(Math.max(n, n2), n3);
        int n5 = 0;
        int n6 = 0;
        int n7 = Math.min(Math.min(n, n2), n3);
        n5 = n4 == 0 ? 0 : (n4 - n7) * 100 / n4;
        if (n5 == 0) {
            n6 = 0;
        } else {
            int n8 = (n4 - n) / (n4 - n7);
            int n9 = (n4 - n2) / (n4 - n7);
            int n10 = (n4 - n3) / (n4 - n7);
            if (n == n4) {
                n6 = n10 - n9;
            }
            if (n2 == n4) {
                n6 = 2 + n8 - n10;
            }
            if (n3 == n4) {
                n6 = 4 + n9 - n8;
            }
            if ((n6 *= 60) < 0) {
                n6 += 360;
            }
        }
        n4 = n4 * 100 / 255;
        return new int[]{n6, n5, n4};
    }

    private void DrawHueBar(Graphics graphics, int n, int n2) {
        if (this.imgHueBar == null) {
            this.imgHueBar = Image.createImage((int)n, (int)n2);
            Graphics graphics2 = this.imgHueBar.getGraphics();
            for (int i = 0; i < 360; ++i) {
                int[] nArray = DHSVColor.H_to_PureRGB(i);
                graphics2.setColor(nArray[0], nArray[1], nArray[2]);
                graphics2.drawLine(i * n / 359, 0, i * n / 359, n2);
            }
        }
        graphics.setColor(0);
        graphics.drawLine(this.h * n / 359, n2, this.h * n / 359, n2 + 3);
        graphics.drawLine(this.h * n / 359, n2 + 3, n / 2, n2 + 6);
        graphics.drawImage(this.imgHueBar, 0, 0, 0);
    }

    private void DrawValueBar(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray = DHSVColor.H_to_PureRGB(this.h);
        int n7 = 255 * (100 - this.s) / 100;
        for (n6 = 0; n6 < 256; ++n6) {
            n5 = n6;
            n4 = n6;
            n3 = n6;
            if (n6 >= nArray[0]) {
                n5 = nArray[0];
            }
            if (n6 >= nArray[1]) {
                n4 = nArray[1];
            }
            if (n6 >= nArray[2]) {
                n3 = nArray[2];
            }
            if ((n5 -= n7) < 0) {
                n5 = 0;
            }
            if ((n4 -= n7) < 0) {
                n4 = 0;
            }
            if ((n3 -= n7) < 0) {
                n3 = 0;
            }
            graphics.setColor(n5, n4, n3);
            graphics.drawLine(n6 * (n / 3) / 255, 0, n6 * (n / 3) / 255, n2);
        }
        for (n6 = 0; n6 < 256; ++n6) {
            n5 = nArray[0] + n6;
            n4 = nArray[1] + n6;
            n3 = nArray[2] + n6;
            if (n5 > 255) {
                n5 = 255;
            }
            if (n4 > 255) {
                n4 = 255;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            if ((n5 -= n7) < 0) {
                n5 = 0;
            }
            if ((n4 -= n7) < 0) {
                n4 = 0;
            }
            if ((n3 -= n7) < 0) {
                n3 = 0;
            }
            graphics.setColor(n5, n4, n3);
            graphics.drawLine(n6 * (n / 3) / 255 + n / 3, 0, n6 * (n / 3) / 255 + n / 3, n2);
        }
        graphics.setColor(0);
        graphics.drawLine(this.v * (2 * n / 3) / 100, n2, this.v * (2 * n / 3) / 100, n2 + 3);
        graphics.drawLine(this.v * (2 * n / 3) / 100, n2 + 3, n / 3, n2 + 5);
    }

    protected void keyPressed(int n) {
        int n2 = this.stepSm ? this.sm_step : this.b_step;
        switch (n) {
            case -21: 
            case 21: {
                CMain.display.setCurrent((Displayable)DMain.inst);
                break;
            }
            case -22: 
            case 22: {
                this.rcvr.ColorSet(this.r, this.g, this.b);
                CMain.display.setCurrent((Displayable)DMain.inst);
                break;
            }
            case 52: {
                this.h -= n2;
                if (this.h >= 0) break;
                this.h = 0;
                break;
            }
            case 54: {
                this.h += n2;
                if (this.h <= 360) break;
                this.h = 360;
                break;
            }
            case 49: {
                this.s += n2;
                if (this.s <= 100) break;
                this.s = 100;
                break;
            }
            case 51: {
                this.s -= n2;
                if (this.s >= 0) break;
                this.s = 0;
                break;
            }
            case 55: {
                this.v -= n2;
                if (this.v >= 0) break;
                this.v = 0;
                break;
            }
            case 57: {
                this.v += n2;
                if (this.v <= 100) break;
                this.v = 100;
                break;
            }
            case 53: {
                DSetColor dSetColor = new DSetColor(this.r, this.g, this.b, this);
                CMain.display.setCurrent((Displayable)dSetColor);
                break;
            }
            case 42: {
                this.stepSm = !this.stepSm;
            }
        }
        this.repaint();
    }

    public void ColorSet(int n, int n2, int n3) {
        this.org_r = n;
        this.org_g = n2;
        this.org_b = n3;
        int[] nArray = DHSVColor.RGB_to_HSV(n / 2, n2 / 2, n3 / 2);
        this.h = nArray[0];
        this.s = nArray[1];
        this.v = nArray[2];
        CMain.display.setCurrent((Displayable)this);
    }

    public void ColorSetCanceled() {
        CMain.display.setCurrent((Displayable)this);
    }

    public void FillColorSet(int n, int n2, int n3) {
    }
}

