/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import org.kxml.Attribute;
import org.kxml.io.ParseException;
import org.kxml.parser.AbstractXmlParser;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.StartTag;
import org.kxml.parser.Tag;

public class XmlParser
extends AbstractXmlParser {
    static final String UNEXPECTED_EOF = "Unexpected EOF";
    char[] buf = new char[Runtime.getRuntime().freeMemory() >= 0x100000L ? 8192 : 128];
    boolean eof;
    int bufPos;
    int bufCount;
    Reader reader;
    boolean relaxed;
    int line = 1;
    int column = 1;
    Vector qNames = new Vector();
    boolean immediateClose = false;
    StartTag current;
    protected ParseEvent next;

    int peekChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.bufPos >= this.bufCount) {
            this.bufCount = this.reader.read(this.buf, 0, this.buf.length);
            this.bufPos = 0;
            if (this.bufCount == -1) {
                this.eof = true;
                return -1;
            }
        }
        return this.buf[this.bufPos];
    }

    int readChar() throws IOException {
        int n = this.peekChar();
        ++this.bufPos;
        ++this.column;
        if (n == 10) {
            ++this.line;
            this.column = 1;
        }
        return n;
    }

    void skipWhitespace() throws IOException {
        while (!this.eof && this.peekChar() <= 32) {
            this.readChar();
        }
    }

    public String readName() throws IOException {
        int n = this.readChar();
        if (!(n >= 128 || n == 95 || n == 58 || n >= 97 && n <= 122 || n >= 65 && n <= 90)) {
            throw new DefaultParserException("name expected!", null);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((char)n);
        while (!this.eof) {
            n = this.peekChar();
            if (!(n >= 128 || n == 95 || n == 45 || n == 58 || n == 46 || n >= 48 && n <= 57 || n >= 97 && n <= 122 || n >= 65 && n <= 90)) break;
            stringBuffer.append((char)this.readChar());
        }
        return stringBuffer.toString();
    }

    public StringBuffer readTo(char c, StringBuffer stringBuffer) throws IOException {
        while (!this.eof && this.peekChar() != c) {
            stringBuffer.append((char)this.readChar());
        }
        return stringBuffer;
    }

    public XmlParser(Reader reader) throws IOException {
        this.reader = reader;
    }

    public String resolveCharacterEntity(String string) throws IOException {
        throw new DefaultParserException("Undefined: &" + string + ";", null);
    }

    /*
     * Unable to fully structure code
     */
    ParseEvent parseComment() throws IOException {
        var1_1 = new StringBuffer();
        if (this.readChar() != 45) {
            throw new DefaultParserException("'-' expected", null);
        }
        while (true) {
            this.readTo('-', var1_1);
            if (this.readChar() == -1) {
                throw new DefaultParserException("Unexpected EOF", null);
            }
            var2_2 = 0;
            do {
                var3_3 = this.readChar();
                ++var2_2;
            } while (var3_3 == 45);
            if (var3_3 != 62 || var2_2 < 2) ** GOTO lbl18
            if (true) ** GOTO lbl25
lbl-1000:
            // 1 sources

            {
                var1_1.append('-');
lbl18:
                // 2 sources

                ** while (var2_2-- > 0)
            }
lbl19:
            // 1 sources

            var1_1.append((char)var3_3);
        }
        do {
            var1_1.append('-');
lbl25:
            // 2 sources

        } while (var2_2-- > 2);
        return new ParseEvent(1, var1_1.toString());
    }

    ParseEvent parseDoctype() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 1;
        while (true) {
            int n2 = this.readChar();
            switch (n2) {
                case -1: {
                    throw new DefaultParserException(UNEXPECTED_EOF, null);
                }
                case 60: {
                    ++n;
                    break;
                }
                case 62: {
                    if (--n != 0) break;
                    return new ParseEvent(2, stringBuffer.toString());
                }
            }
            stringBuffer.append((char)n2);
        }
    }

    ParseEvent parseCData() throws IOException {
        StringBuffer stringBuffer = this.readTo('[', new StringBuffer());
        if (!stringBuffer.toString().equals("CDATA")) {
            throw new DefaultParserException("Invalid CDATA start!", null);
        }
        stringBuffer.setLength(0);
        this.readChar();
        int n = this.readChar();
        int n2 = this.readChar();
        while (true) {
            int n3;
            if ((n3 = this.readChar()) == -1) {
                throw new DefaultParserException(UNEXPECTED_EOF, null);
            }
            if (n == 93 && n2 == 93 && n3 == 62) break;
            stringBuffer.append((char)n);
            n = n2;
            n2 = n3;
        }
        return new ParseEvent(128, stringBuffer.toString());
    }

    ParseEvent parseEndTag() throws IOException {
        Object object;
        this.skipWhitespace();
        String string = this.readName();
        this.skipWhitespace();
        if (this.readChar() != 62) {
            throw new DefaultParserException("'>' expected", null);
        }
        int n = this.qNames.size();
        while (true) {
            if (n == 0) {
                if (this.relaxed) {
                    return new ParseEvent(8, null);
                }
                throw new DefaultParserException("tagstack empty parsing </" + string + ">", null);
            }
            object = (String)this.qNames.elementAt(--n);
            this.qNames.removeElementAt(n);
            if (((String)object).equals(string)) break;
            if (!this.relaxed) {
                throw new DefaultParserException("StartTag <" + (String)object + "> does not match end tag </" + string + ">", null);
            }
            if (((String)object).toLowerCase().equals(string.toLowerCase())) break;
            this.current = this.current.parent;
        }
        object = new Tag(16, this.current, this.current.namespace, this.current.name);
        this.current = this.current.parent;
        return object;
    }

    ParseEvent parsePI() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.readTo('?', stringBuffer);
        this.readChar();
        while (this.peekChar() != 62) {
            stringBuffer.append('?');
            int n = this.readChar();
            if (n == -1) {
                throw new DefaultParserException(UNEXPECTED_EOF, null);
            }
            stringBuffer.append((char)n);
            this.readTo('?', stringBuffer);
            this.readChar();
        }
        this.readChar();
        return new ParseEvent(32, stringBuffer.toString());
    }

    StartTag parseStartTag() throws IOException {
        String string = this.readName();
        Vector<Attribute> vector = null;
        this.immediateClose = false;
        while (true) {
            this.skipWhitespace();
            int n = this.peekChar();
            if (n == 47) {
                this.immediateClose = true;
                this.readChar();
                this.skipWhitespace();
                if (this.readChar() == 62) break;
                throw new DefaultParserException("illegal element termination", null);
            }
            if (n == 62) {
                this.readChar();
                break;
            }
            if (n == -1) {
                throw new DefaultParserException(UNEXPECTED_EOF, null);
            }
            String string2 = this.readName();
            if (string2.length() == 0) {
                throw new DefaultParserException("illegal char / attr", null);
            }
            this.skipWhitespace();
            if (this.readChar() != 61) {
                throw new DefaultParserException("Attribute name " + string2 + "must be followed by '='!", null);
            }
            this.skipWhitespace();
            int n2 = this.readChar();
            if (n2 != 39 && n2 != 34) {
                if (!this.relaxed) {
                    throw new DefaultParserException("<" + string + ">: invalid delimiter: " + (char)n2, null);
                }
                n2 = 32;
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.readText(stringBuffer, (char)n2);
            if (vector == null) {
                vector = new Vector<Attribute>();
            }
            vector.addElement(new Attribute(null, string2, stringBuffer.toString()));
            if (n2 == 32) continue;
            this.readChar();
        }
        try {
            this.current = new StartTag(this.current, "", string, vector, this.immediateClose, this.processNamespaces);
        }
        catch (Exception exception) {
            throw new DefaultParserException(exception.toString(), exception);
        }
        if (!this.immediateClose) {
            this.qNames.addElement(string);
        }
        return this.current;
    }

    int readText(StringBuffer stringBuffer, char c) throws IOException {
        int n;
        int n2 = 256;
        while ((n = this.peekChar()) != -1 && n != c && (c != ' ' || n != 62 && n >= 32)) {
            this.readChar();
            if (n == 38) {
                String string = this.readTo(';', new StringBuffer()).toString();
                this.readChar();
                if (string.charAt(0) == '#') {
                    int n3 = n = string.charAt(1) == 'x' ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string.substring(1));
                    if (n > 32) {
                        n2 = 128;
                    }
                    stringBuffer.append((char)n);
                    continue;
                }
                if (string.equals("lt")) {
                    stringBuffer.append('<');
                } else if (string.equals("gt")) {
                    stringBuffer.append('>');
                } else if (string.equals("apos")) {
                    stringBuffer.append('\'');
                } else if (string.equals("quot")) {
                    stringBuffer.append('\"');
                } else if (string.equals("amp")) {
                    stringBuffer.append('&');
                } else {
                    stringBuffer.append(this.resolveCharacterEntity(string));
                }
                n2 = 128;
                continue;
            }
            if (n > 32) {
                n2 = 128;
            }
            stringBuffer.append((char)n);
        }
        return n2;
    }

    ParseEvent parseSpecial() throws IOException {
        switch (this.peekChar()) {
            case -1: {
                throw new DefaultParserException(UNEXPECTED_EOF, null);
            }
            case 33: {
                this.readChar();
                switch (this.peekChar()) {
                    case 45: {
                        this.readChar();
                        return this.parseComment();
                    }
                    case 91: {
                        this.readChar();
                        return this.parseCData();
                    }
                }
                return this.parseDoctype();
            }
            case 63: {
                this.readChar();
                return this.parsePI();
            }
            case 47: {
                this.readChar();
                return this.parseEndTag();
            }
        }
        return this.parseStartTag();
    }

    public ParseEvent read() throws IOException {
        if (this.next == null) {
            this.peek();
        }
        ParseEvent parseEvent = this.next;
        this.next = null;
        return parseEvent;
    }

    public ParseEvent peek() throws IOException {
        if (this.next == null) {
            if (this.immediateClose) {
                this.next = new Tag(16, this.current, this.current.namespace, this.current.name);
                this.current = this.current.getParent();
                this.immediateClose = false;
            } else {
                switch (this.peekChar()) {
                    case 60: {
                        this.readChar();
                        this.next = this.parseSpecial();
                        break;
                    }
                    case -1: {
                        if (this.current != null && !this.relaxed) {
                            throw new DefaultParserException("End tag missing for: " + this.current, null);
                        }
                        this.next = new ParseEvent(8, null);
                        break;
                    }
                    default: {
                        StringBuffer stringBuffer = new StringBuffer();
                        int n = this.readText(stringBuffer, '<');
                        this.next = new ParseEvent(n, stringBuffer.toString());
                    }
                }
            }
        }
        return this.next;
    }

    public void setRelaxed(boolean bl) {
        this.relaxed = bl;
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    class DefaultParserException
    extends ParseException {
        DefaultParserException(String string, Exception exception) {
            super(string, exception, XmlParser.this.line, XmlParser.this.column);
        }
    }
}

