/*
 * Decompiled with CFR 0.152.
 */
package org.kxml.io;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class XMLWriter {
    private Hashtable hashtableOfNamespace;
    private Hashtable namespaceForElements = new Hashtable();
    private int namespaceCounter = 1;
    private Stack elementsToClose;
    private boolean namespaceAlreadyDeclared = true;
    private boolean mapElementToNamespace = false;
    private boolean tagToClose = false;
    private boolean elementToClose = false;
    private StringBuffer sb = new StringBuffer();

    public XMLWriter(Hashtable hashtable) {
        this.hashtableOfNamespace = hashtable;
        this.elementsToClose = new Stack();
        this.sb.append("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void startElement(String string, String string2) {
        if (this.tagToClose) {
            this.sb.append(">");
        }
        this.tagToClose = true;
        String string3 = this.findPrefixForNamespace(string2);
        this.elementsToClose.push(string3 + ":" + string);
        if (this.mapElementToNamespace) {
            this.mapNamespaceToElement(string2);
        }
        this.sb.append("<" + string3 + ":" + string);
        if (!this.namespaceAlreadyDeclared) {
            this.namespaceAlreadyDeclared = true;
            this.sb.append(" xmlns:" + string3 + "=\"" + string2 + "\"");
        }
    }

    public void startElement(String string) {
        if (this.tagToClose) {
            this.sb.append(">");
        }
        this.tagToClose = true;
        this.elementsToClose.push(string);
        this.sb.append("<" + string);
    }

    public void attribute(String string, String string2) {
        this.sb.append(" " + string + "=\"" + string2 + "\"");
    }

    public void attribute(String string, String string2, String string3, String string4) {
        String string5 = this.findPrefixForNamespace(string2);
        if (!this.namespaceAlreadyDeclared) {
            this.namespaceAlreadyDeclared = true;
            this.sb.append(" xmlns:" + string5 + "=\"" + string2 + "\" ");
            if (this.mapElementToNamespace) {
                this.mapNamespaceToElement(string2);
            }
        }
        String string6 = this.findPrefixForNamespace(string4);
        if (!this.namespaceAlreadyDeclared) {
            this.namespaceAlreadyDeclared = true;
            this.sb.append(" xmlns:" + string6 + "=\"" + string4 + "\" ");
            if (this.mapElementToNamespace) {
                this.mapNamespaceToElement(string4);
            }
        }
        this.sb.append(" " + string5 + ":" + string + "=\"" + string6 + ":" + string3 + "\"");
    }

    public void elementBody(String string) {
        if (this.tagToClose) {
            this.sb.append(">");
            this.tagToClose = false;
        }
        this.sb.append(string);
    }

    public void endTag() {
        String string = (String)this.elementsToClose.pop();
        if (this.tagToClose) {
            this.sb.append(">");
            this.tagToClose = false;
        }
        this.sb.append("</" + string + ">");
        Vector vector = (Vector)this.namespaceForElements.remove(string);
        int n = 0;
        while (vector != null && n < vector.size()) {
            this.hashtableOfNamespace.remove((String)vector.elementAt(n));
            ++n;
        }
    }

    public byte[] getPayload(String string) throws UnsupportedEncodingException {
        String string2 = this.sb.toString();
        if (string != null) {
            return string2.getBytes(string);
        }
        return string2.getBytes();
    }

    private String findPrefixForNamespace(String string) {
        String string2 = (String)this.hashtableOfNamespace.get(string);
        if (string2 == null) {
            string2 = "ns" + this.namespaceCounter++;
            this.hashtableOfNamespace.put(string, string2);
            this.namespaceAlreadyDeclared = false;
            this.mapElementToNamespace = true;
        }
        return string2;
    }

    private void mapNamespaceToElement(String string) {
        this.mapElementToNamespace = false;
        Vector<String> vector = (Vector<String>)this.namespaceForElements.remove((String)this.elementsToClose.peek());
        if (vector == null) {
            vector = new Vector<String>();
        }
        vector.addElement(string);
        this.namespaceForElements.put((String)this.elementsToClose.peek(), vector);
    }
}

