/*
 * Decompiled with CFR 0.152.
 */
package com.wingfoot.soap.encoding;

import com.wingfoot.soap.SOAPException;
import com.wingfoot.soap.encoding.BaseSerializer;
import com.wingfoot.soap.encoding.SerializerDeserializer;
import com.wingfoot.soap.encoding.TypeMappingRegistry;
import com.wingfoot.soap.encoding.WSerializable;
import org.kxml.io.XMLWriter;
import org.kxml.parser.ParseEvent;
import org.kxml.parser.XmlParser;

public class BeanSerializer
implements SerializerDeserializer {
    public void marshall(XMLWriter xMLWriter, String string, Object object, TypeMappingRegistry typeMappingRegistry, BaseSerializer baseSerializer) throws Exception {
        xMLWriter.startElement(string);
        String[] stringArray = typeMappingRegistry.getInfoForClass(object.getClass().getName());
        if (stringArray == null) {
            throw new SOAPException("Class " + object.getClass().getName() + " not registered");
        }
        xMLWriter.attribute("type", baseSerializer.getSchemaInstance(), stringArray[1], stringArray[0]);
        WSerializable wSerializable = (WSerializable)object;
        int n = 0;
        while (n < wSerializable.getPropertyCount()) {
            baseSerializer.serialize(xMLWriter, typeMappingRegistry, wSerializable.getPropertyName(n), wSerializable.getPropertyValue(n));
            ++n;
        }
        xMLWriter.endTag();
    }

    public void unmarshall(XmlParser xmlParser, TypeMappingRegistry typeMappingRegistry, Object object, BaseSerializer baseSerializer) throws Exception {
        ParseEvent parseEvent = xmlParser.read();
        String string = parseEvent.getName();
        WSerializable wSerializable = (WSerializable)object;
        while (xmlParser.peek().getType() != 16 || !xmlParser.peek().getName().trim().equals(string)) {
            if (xmlParser.peek().getType() == 64) {
                String string2 = xmlParser.peek().getName().trim();
                Object object2 = baseSerializer.deserialize(xmlParser, typeMappingRegistry);
                wSerializable.setProperty(string2, object2);
                continue;
            }
            xmlParser.read();
        }
    }
}

