/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotOpenException;

class recordStores {
    private static String name = "EverydayNotes";
    private static int recordLength = 4096;
    private RecordStore rs = null;

    public recordStores() {
        try {
            this.rs = null;
            this.rs = RecordStore.openRecordStore((String)name, (boolean)true);
        }
        catch (RecordStoreFullException recordStoreFullException) {
            this.rs = null;
        }
        catch (RecordStoreNotOpenException recordStoreNotOpenException) {
            this.rs = null;
        }
        catch (RecordStoreException recordStoreException) {
            this.rs = null;
        }
    }

    public int getNumRecords() {
        if (this.rs != null) {
            try {
                return this.rs.getNumRecords();
            }
            catch (RecordStoreNotOpenException recordStoreNotOpenException) {
                return 0;
            }
            catch (RecordStoreException recordStoreException) {
                return 0;
            }
        }
        return 0;
    }

    public String getRecord(int n) {
        String string = null;
        if (this.rs != null) {
            try {
                byte[] byArray = this.rs.getRecord(n);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, 0, recordLength);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                string = dataInputStream.readUTF();
                if (string.length() < recordLength) {
                    dataInputStream.skip(recordLength - string.length());
                }
            }
            catch (IOException iOException) {
                return null;
            }
            catch (RecordStoreException recordStoreException) {
                return null;
            }
            return string;
        }
        return null;
    }

    public boolean setRecord(int n, String string) {
        if (this.rs != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(string);
                this.rs.setRecord(n, byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            }
            catch (IOException iOException) {
                return false;
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                try {
                    this.rs.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
                }
                catch (RecordStoreException recordStoreException) {
                    return false;
                }
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean closeRecords() {
        if (this.rs != null) {
            try {
                this.rs.closeRecordStore();
                this.rs = null;
            }
            catch (RecordStoreException recordStoreException) {
                return false;
            }
            return true;
        }
        return false;
    }
}

