/*
 * Decompiled with CFR 0.152.
 */
package org.jibble.simpleftp;

import com.jenfa.AsciiReader;
import com.jenfa.AsciiWriter;
import com.jenfa.BufferedInputStream;
import com.jenfa.BufferedOutputStream;
import com.jenfa.StringTokenizer;
import com.jenfa.UnixFileParser;
import com.jenfa.WindowsFileParser;
import com.motorola.io.FileConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import motoftp.mftp;

public class SimpleFTP {
    Vector log = new Vector();
    private SocketConnection socket = null;
    private AsciiReader reader = null;
    private AsciiWriter writer = null;
    FileConnection fc = null;
    private static boolean DEBUG = true;
    String SYSTEM = "";

    public synchronized void connect(String host) throws IOException {
        this.connect(host, 21);
    }

    public synchronized void connect(String host, int port) throws IOException {
        this.connect(host, port, "anonymous", "anonymous");
    }

    public synchronized void connect(String host, int port, String user, String pass) throws IOException {
        if (this.socket != null) {
            throw new IOException("MotoFTP is already connected. Disconnect first.");
        }
        this.socket = (SocketConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("socket://").append(host).append(":").append(port))));
        try {
            this.reader = new AsciiReader();
            this.reader.openStream(this.socket.openInputStream());
            this.writer = new AsciiWriter();
            this.writer.openStream(this.socket.openOutputStream());
        }
        catch (Exception e) {
            this.Handle(e);
        }
        String response = this.readMultiLineAnswer();
        if (!response.startsWith("220 ")) {
            throw new IOException("MotoFTP received an unknown response when connecting to the FTP server: ".concat(String.valueOf(String.valueOf(response))));
        }
        this.sendLine("USER ".concat(String.valueOf(String.valueOf(user))));
        response = this.readMultiLineAnswer();
        if (!response.startsWith("331 ") && !response.startsWith("230 ")) {
            throw new IOException("MotoFTP received an unknown response after sending the user: ".concat(String.valueOf(String.valueOf(response))));
        }
        if (!response.startsWith("230 ")) {
            this.sendLine("PASS ".concat(String.valueOf(String.valueOf(pass))));
            response = this.readMultiLineAnswer();
            if (!response.startsWith("230 ")) {
                throw new IOException("MotoFTP was unable to log in with the supplied password: ".concat(String.valueOf(String.valueOf(response))));
            }
        }
        this.sendLine("SYST");
        response = this.readMultiLineAnswer();
        if (!response.startsWith("215 ")) {
            if (DEBUG) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("MotoFTP cannot collect OS Info (").append(response).append("). Falling back to UNIX"))));
            }
            this.SYSTEM = "UNIX";
        } else {
            this.SYSTEM = response.substring(4);
        }
    }

    public synchronized void disconnect() throws IOException {
        try {
            this.sendLine("QUIT");
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            this.socket.close();
            this.socket = null;
        }
    }

    public synchronized String pwd() throws IOException {
        int firstQuote;
        int secondQuote;
        this.sendLine("PWD");
        String dir = null;
        String response = this.readMultiLineAnswer();
        if (response.startsWith("257 ") && (secondQuote = response.indexOf(34, (firstQuote = response.indexOf(34)) + 1)) > 0) {
            dir = response.substring(firstQuote + 1, secondQuote);
        }
        return dir;
    }

    public synchronized boolean cwd(String dir) throws IOException {
        this.sendLine("CWD ".concat(String.valueOf(String.valueOf(dir))));
        String response = this.readMultiLineAnswer();
        return response.startsWith("250 ");
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    public synchronized boolean stor(String filename, mftp host, int timeout) throws IOException {
        String fnam = this.getLastURLPart(filename, false);
        this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
        return this.stor(this.fc.openInputStream(), fnam, host, timeout);
    }

    public synchronized Enumeration list() throws IOException {
        Vector<String> result;
        SocketConnection dSock;
        String response;
        block10: {
            this.sendLine("PASV");
            response = this.readMultiLineAnswer();
            if (!response.startsWith("227 ")) {
                throw new IOException("MotoFTP could not request passive mode: ".concat(String.valueOf(String.valueOf(response))));
            }
            String ip = null;
            int port = -1;
            int opening = response.indexOf(40);
            int closing = response.indexOf(41, opening + 1);
            if (closing > 0) {
                String dataLink = response.substring(opening + 1, closing);
                StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
                try {
                    ip = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(tokenizer.nextToken()))).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken())));
                    port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
                }
                catch (Exception e) {
                    throw new IOException("MotoFTP received bad data link information: ".concat(String.valueOf(String.valueOf(response))));
                }
            }
            this.sendLine("LIST");
            dSock = (SocketConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("socket://").append(ip).append(":").append(port))));
            response = this.readMultiLineAnswer();
            if (!response.startsWith("150 ") && !response.startsWith("125 ")) {
                throw new IOException("MotoFTP was not allowed to download filelist: ".concat(String.valueOf(String.valueOf(response))));
            }
            AsciiReader list_read = new AsciiReader();
            result = new Vector<String>();
            UnixFileParser up = new UnixFileParser();
            WindowsFileParser wp = new WindowsFileParser();
            String line = "";
            int parser = 1;
            if (this.SYSTEM.toUpperCase().startsWith("WINDOWS")) {
                parser = 2;
            }
            try {
                list_read.openStream(dSock.openInputStream());
                while (!list_read.eof()) {
                    line = list_read.readLine();
                    if (parser == 1) {
                        result.addElement(up.parse(line));
                        continue;
                    }
                    result.addElement(wp.parse(line));
                }
                list_read.close();
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block10;
                throw (IOException)e;
            }
        }
        dSock.close();
        response = this.readMultiLineAnswer();
        Enumeration e1 = result.elements();
        return e1;
    }

    public synchronized boolean retr(String filename, mftp host, int timeout) throws Exception {
        String fnam = this.getLastURLPart(filename, false);
        this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
        if (this.fc.exists()) {
            this.fc.delete();
        }
        this.fc.create();
        return this.retr(this.fc.openOutputStream(), fnam, host, timeout);
    }

    public synchronized boolean retr(OutputStream output, String filename, mftp host, int timeout) throws IOException {
        this.sendLine("PASV");
        String response = this.readMultiLineAnswer();
        if (!response.startsWith("227 ")) {
            throw new IOException("MotoFTP could not request passive mode: ".concat(String.valueOf(String.valueOf(response))));
        }
        String ip = null;
        int port = -1;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                ip = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(tokenizer.nextToken()))).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken())));
                port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
            }
            catch (Exception e) {
                throw new IOException("MotoFTP received bad data link information: ".concat(String.valueOf(String.valueOf(response))));
            }
        }
        this.sendLine("RETR ".concat(String.valueOf(String.valueOf(filename))));
        SocketConnection dSock = (SocketConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("socket://").append(ip).append(":").append(port))));
        response = this.readMultiLineAnswer();
        if (!response.startsWith("150 ") && !response.startsWith("125 ")) {
            throw new IOException("MotoFTP was not allowed to download file: ".concat(String.valueOf(String.valueOf(response))));
        }
        BufferedInputStream input = new BufferedInputStream(dSock.openInputStream());
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            host.packet_downloaded(bytesRead);
        }
        output.flush();
        output.close();
        input.close();
        dSock.close();
        response = this.readMultiLineAnswer();
        return response.startsWith("226 ");
    }

    public synchronized boolean stor(InputStream inputStream, String filename, mftp host, int timeout) throws IOException {
        BufferedInputStream input = new BufferedInputStream(inputStream);
        this.sendLine("PASV");
        String response = this.readMultiLineAnswer();
        if (!response.startsWith("227 ")) {
            throw new IOException("MotoFTP could not request passive mode: ".concat(String.valueOf(String.valueOf(response))));
        }
        String ip = null;
        int port = -1;
        int opening = response.indexOf(40);
        int closing = response.indexOf(41, opening + 1);
        if (closing > 0) {
            String dataLink = response.substring(opening + 1, closing);
            StringTokenizer tokenizer = new StringTokenizer(dataLink, ",");
            try {
                ip = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(tokenizer.nextToken()))).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken()).append(".").append(tokenizer.nextToken())));
                port = Integer.parseInt(tokenizer.nextToken()) * 256 + Integer.parseInt(tokenizer.nextToken());
            }
            catch (Exception e) {
                throw new IOException("MotoFTP received bad data link information: ".concat(String.valueOf(String.valueOf(response))));
            }
        }
        this.sendLine("STOR ".concat(String.valueOf(String.valueOf(filename))));
        SocketConnection dataSocket = (SocketConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("socket://").append(ip).append(":").append(port))));
        response = this.readMultiLineAnswer();
        if (!response.startsWith("150 ") && !response.startsWith("125 ")) {
            throw new IOException("MotoFTP was not allowed to send the file: ".concat(String.valueOf(String.valueOf(response))));
        }
        BufferedOutputStream output = new BufferedOutputStream(dataSocket.openOutputStream());
        byte[] buffer = new byte[4096];
        int bytesRead = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            host.packet_uploaded(bytesRead);
        }
        output.flush();
        output.close();
        input.close();
        dataSocket.close();
        response = this.readMultiLineAnswer();
        return response.startsWith("226");
    }

    public synchronized boolean bin() throws IOException {
        this.sendLine("TYPE I");
        String response = this.readMultiLineAnswer();
        return response.startsWith("200 ");
    }

    public synchronized boolean mkd(String name) throws IOException {
        this.sendLine("MKD ".concat(String.valueOf(String.valueOf(name))));
        String response = this.readMultiLineAnswer();
        return response.startsWith("257 ");
    }

    public synchronized boolean rmd(String name) throws IOException {
        this.sendLine("RMD ".concat(String.valueOf(String.valueOf(name))));
        String response = this.readMultiLineAnswer();
        return response.startsWith("250 ");
    }

    public synchronized boolean dele(String name) throws IOException {
        this.sendLine("DELE ".concat(String.valueOf(String.valueOf(name))));
        String response = this.readMultiLineAnswer();
        return response.startsWith("250 ");
    }

    public synchronized boolean ascii() throws IOException {
        this.sendLine("TYPE A");
        String response = this.readMultiLineAnswer();
        return response.startsWith("200 ");
    }

    public Enumeration getLog() {
        return this.log.elements();
    }

    private void sendLine(String line) throws IOException {
        if (this.socket == null) {
            throw new IOException("MotoFTP is not connected.");
        }
        try {
            this.writer.writeLine(String.valueOf(String.valueOf(line)).concat("\r\n"));
            if (DEBUG) {
                System.out.println("> ".concat(String.valueOf(String.valueOf(line))));
            }
            this.log.addElement("> ".concat(String.valueOf(String.valueOf(line))));
        }
        catch (Exception e) {
            this.socket = null;
            throw (IOException)e;
        }
    }

    private String readMultiLineAnswer() throws IOException {
        String line = "";
        line = this.readLine();
        while (line.charAt(3) == '-') {
            line = this.readLine();
        }
        return line;
    }

    private String readLine() throws IOException {
        try {
            String line = this.reader.readLine();
            if (DEBUG) {
                System.out.println("< ".concat(String.valueOf(String.valueOf(line))));
            }
            this.log.addElement("< ".concat(String.valueOf(String.valueOf(line))));
            String string = line;
            return string;
        }
        catch (Exception e) {
            this.Handle(e);
            return "";
        }
    }

    void Handle(Exception e) {
        System.out.println(e.toString());
    }
}

