/*
 * Decompiled with CFR 0.152.
 */
package motoftp;

import java.util.Enumeration;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import motoftp.Account;
import motoftp.AccountContainer;

public class SettingsHandler
implements CommandListener {
    Displayable cb = null;
    List accountlist;
    String active_account = "";
    byte sort_files = 0;
    ChoiceGroup sort;
    int edit_action = -1;
    TextField t_host;
    TextField t_port;
    TextField t_login;
    TextField t_pass;
    TextField t_start_dir;
    TextField t_dir;
    TextField t_acc_name;
    AccountContainer ac;
    String ftp_dir = "/";
    String host = "";
    int port = 21;
    int timeout = 1000;
    String login = "anonymous";
    String pass = "mail@mail.com";
    String start_dir = "/a/mobile/";
    String acc_name = "Default";
    String old_acc_name;
    Command exit = new Command("Exit", 8, 3);
    Command ok = new Command("OK", 4, 1);
    Command cancel = new Command("Cancel", 3, 1);
    Command save = new Command("Save", 4, 1);
    Command new_acc = new Command("New", 8, 1);
    Command cancel2 = new Command("Cancel", 3, 1);
    Command delete = new Command("Delete", 8, 1);
    Command edit = new Command("Edit", 8, 1);
    Display disp;
    Image inactive_acc;
    Image active_acc;

    public SettingsHandler(Display d) {
        this.disp = d;
        try {
            this.inactive_acc = Image.createImage((String)"/icons/inactive.png");
            this.active_acc = Image.createImage((String)"/icons/active.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ac = new AccountContainer(d);
        this.ac.LoadAccounts();
        this.active_account = this.ac.active_account;
    }

    public void LoadSettings() {
        this.LoadAccount(this.ac.getActiveAccount());
    }

    void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MOTOAMP EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void LoadAccount(Account a) {
        this.host = a.host;
        this.login = a.login;
        this.pass = a.pass;
        this.ftp_dir = a.ftp_dir;
        this.start_dir = a.start_dir;
        this.sort_files = a.sort_files;
        this.port = a.port;
        this.acc_name = a.account_name;
    }

    public void ChangeAccountData() {
        if (this.edit_action == 2) {
            this.old_acc_name = this.accountlist.getString(this.accountlist.getSelectedIndex());
            this.LoadAccount(this.ac.getAccountByName(this.old_acc_name));
        }
        if (this.edit_action == 1) {
            this.LoadAccount(new Account());
            this.acc_name = "";
        }
        Form form = new Form("Settings");
        this.t_host = new TextField("Host", this.host, 255, 0);
        this.t_port = new TextField("Port", String.valueOf(this.port), 5, 2);
        this.t_login = new TextField("Login", this.login, 255, 0);
        this.t_pass = new TextField("Password", this.pass, 255, 65536);
        this.t_dir = new TextField("FTP Upload dir", this.ftp_dir, 255, 0);
        this.t_acc_name = new TextField("Account name", this.acc_name, 255, 0);
        this.t_start_dir = new TextField("FS Browsing Root", this.start_dir, 255, 0);
        this.sort = new ChoiceGroup("Sorting", 1);
        this.sort.append("No", null);
        this.sort.append("By name: Forward", null);
        this.sort.append("By name: Reverse", null);
        this.sort.append("By date: Forward", null);
        this.sort.append("By date: Reverse", null);
        this.sort.setSelectedIndex((int)this.sort_files, true);
        form.append((Item)this.t_acc_name);
        form.append((Item)this.t_host);
        form.append((Item)this.t_port);
        form.append((Item)this.t_login);
        form.append((Item)this.t_pass);
        form.append((Item)this.t_dir);
        form.append((Item)this.t_start_dir);
        form.append((Item)this.sort);
        form.addCommand(this.ok);
        form.addCommand(this.cancel);
        form.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)form);
    }

    public void ChangeSettings(Displayable callback) {
        this.cb = callback;
        this.ShowAccountList();
    }

    public void ShowAccountList() {
        this.accountlist = new List("Accounts", 3);
        Enumeration e = this.ac.enumerateAccounts();
        Object im = null;
        while (e.hasMoreElements()) {
            Account a = (Account)e.nextElement();
            if (a.account_name.compareTo(this.active_account) == 0) {
                this.accountlist.append(a.account_name, this.active_acc);
                continue;
            }
            this.accountlist.append(a.account_name, this.inactive_acc);
        }
        this.accountlist.addCommand(this.save);
        this.accountlist.addCommand(this.cancel2);
        this.accountlist.addCommand(this.new_acc);
        this.accountlist.addCommand(this.edit);
        this.accountlist.addCommand(this.delete);
        this.accountlist.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)this.accountlist);
    }

    public void Callback() {
        this.LoadAccount(this.ac.getActiveAccount());
        this.disp.setCurrent(this.cb);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.ok) {
            this.host = this.t_host.getString();
            this.port = Integer.parseInt(this.t_port.getString());
            this.login = this.t_login.getString();
            this.pass = this.t_pass.getString();
            this.ftp_dir = this.t_dir.getString();
            this.start_dir = this.t_start_dir.getString();
            this.acc_name = this.t_acc_name.getString();
            if (this.edit_action == 1) {
                this.ac.addAccount(this);
            }
            if (this.edit_action == 2) {
                if (this.active_account.compareTo(this.old_acc_name) == 0) {
                    this.active_account = this.acc_name;
                    this.ac.active_account = this.acc_name;
                }
                this.ac.updateAccount(this);
            }
            this.ShowAccountList();
        }
        if (c == this.cancel2) {
            this.Callback();
        }
        if (c == this.cancel) {
            this.ShowAccountList();
        }
        if (c == this.new_acc) {
            this.edit_action = 1;
            this.ChangeAccountData();
        }
        if (c == this.edit) {
            this.edit_action = 2;
            this.ChangeAccountData();
        }
        if (c == this.delete) {
            this.ac.deleteAccount(this.accountlist.getString(this.accountlist.getSelectedIndex()));
            this.ShowAccountList();
        }
        if (c == this.save) {
            this.ac.SaveAccounts();
            this.Callback();
        }
        if (c == List.SELECT_COMMAND) {
            String name;
            int idx = this.accountlist.getSelectedIndex();
            this.active_account = name = this.accountlist.getString(idx);
            this.ac.active_account = name;
            this.ShowAccountList();
            this.accountlist.setSelectedIndex(idx, true);
        }
    }
}

