/*
 * Decompiled with CFR 0.152.
 */
package motoftp;

import com.motorola.io.FileConnection;
import com.motorola.io.FileSystemRegistry;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import motoftp.About;
import motoftp.SettingsHandler;
import motoftp.mftp;

public class FileBrowser
implements CommandListener {
    Image file = null;
    Image folder = null;
    String curdir = "";
    String[] roots;
    String cur_root;
    FileConnection fc;
    List mainwinlist;
    int i;
    Display disp;
    boolean overupd = false;
    SettingsHandler sh;
    List sel_root = null;
    String[] files_temp;
    int g_point = 0;
    int cur_dir_subfolders_cnt = 0;
    boolean action_success = true;
    mftp pm_host;
    Command open_file = new Command("Upload", 8, 1);
    Command about = new Command("About", 8, 1);
    Command settings = new Command("Settings", 8, 1);
    Command select_drive = new Command("Change Drive", 8, 1);
    Command up = new Command("Up", 8, 2);
    Command ftp_mode = new Command("FTP", 8, 1);
    Command open = new Command("Open", 8, 0);
    Command cancel2 = new Command("Cancel", 3, 2);

    public FileBrowser(mftp host, Display d, SettingsHandler Sh) {
        this.sh = Sh;
        try {
            this.file = Image.createImage((String)"/icons/file.png");
            this.folder = Image.createImage((String)"/icons/folder.png");
            this.disp = d;
            this.pm_host = host;
        }
        catch (Exception e) {
            this.HandleError(e, "FileBrowser constructor");
        }
    }

    public void enterFileMode() {
        if (this.overupd) {
            this.overupd = false;
            this.ShowFileManagerMainWin();
        } else {
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
    }

    public void HandleError(Exception what, String where) {
        this.action_success = false;
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MOTOFTP EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void browseDir(String dir) {
        this.cur_root = dir.substring(0, 3);
        this.curdir = dir;
        this.mainwinlist = new List("", 3);
        this.mainwinlist.addCommand(this.open_file);
        this.mainwinlist.addCommand(this.up);
        this.mainwinlist.addCommand(this.ftp_mode);
        this.mainwinlist.addCommand(this.select_drive);
        this.mainwinlist.addCommand(this.settings);
        this.mainwinlist.addCommand(this.about);
        this.mainwinlist.setCommandListener((CommandListener)this);
        this.ShowFileManagerMainWin();
    }

    public void getFilesFromDir(String dir) {
        String[] files = this.ListFiles(dir);
        System.arraycopy(files, 1, this.files_temp, this.g_point, files.length - 1);
        this.g_point = this.g_point + files.length - 1;
        files = null;
        String[] dirs = this.ListFolders(dir);
        for (int i2 = 1; i2 < dirs.length; ++i2) {
            System.out.println(dirs[i2]);
            if (dirs[i2].compareTo("..") == 0) continue;
            this.getFilesFromDir(dirs[i2]);
        }
        dirs = null;
    }

    String[] ListFolders(String dir) {
        int point = 0;
        this.cur_dir_subfolders_cnt = 0;
        String[] res = new String[1000];
        res[0] = "";
        try {
            this.fc = null;
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(dir))));
            String[] files = this.fc.list();
            this.fc.close();
            this.fc = null;
            this.roots = FileSystemRegistry.listRoots();
            if (this.curdir.compareTo(this.cur_root) != 0 || this.roots.length > 1) {
                res[1] = "..";
                point = 1;
                ++this.cur_dir_subfolders_cnt;
            }
            this.i = 0;
            while (this.i < files.length) {
                if (files[this.i].endsWith("/")) {
                    res[++point] = files[this.i];
                    ++this.cur_dir_subfolders_cnt;
                }
                ++this.i;
            }
            files = null;
        }
        catch (Exception e) {
            this.HandleError(e, "ListFolders");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        res = null;
        return res2;
    }

    String[] ListFiles(String dir) {
        int point = 0;
        String[] res = new String[1000];
        res[0] = "";
        String[] files = new String[]{};
        try {
            this.fc = null;
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(dir))));
            if (this.fc != null) {
                files = this.fc.list();
                this.fc.close();
            }
            this.fc = null;
            if (files != null) {
                this.i = 0;
                while (this.i < files.length) {
                    if (!files[this.i].endsWith("/")) {
                        String ext = "";
                        try {
                            ext = files[this.i].substring(files[this.i].lastIndexOf(46) + 1);
                            ext = ext.toLowerCase();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        res[++point] = files[this.i];
                    }
                    ++this.i;
                }
            }
            files = null;
        }
        catch (Exception e) {
            this.HandleError(e, "ListFiles");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        return res2;
    }

    public long getTime(String filename) {
        long time = 0L;
        try {
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
            time = this.fc.lastModified();
            this.fc.close();
        }
        catch (Exception e) {
            this.HandleError(e, "getTime");
        }
        return time;
    }

    void ShowFileManagerMainWin() {
        this.mainwinlist.deleteAll();
        this.mainwinlist.setTitle(this.curdir);
        String dirname = "";
        try {
            String[] folders = this.ListFolders(this.curdir);
            this.i = 1;
            while (this.i < folders.length) {
                dirname = folders[this.i];
                if (dirname != "..") {
                    dirname = this.getLastURLPart(folders[this.i], true);
                }
                this.mainwinlist.append(dirname, this.folder);
                ++this.i;
            }
            String[] files = this.ListFiles(this.curdir);
            this.i = 1;
            while (this.i < files.length) {
                files[this.i] = this.getLastURLPart(files[this.i], false);
                ++this.i;
            }
            byte sort_files = this.sh.sort_files;
            if (sort_files > 0) {
                this.sortFiles(files, sort_files);
            }
            this.i = 1;
            while (this.i < files.length) {
                dirname = files[this.i];
                this.mainwinlist.append(dirname, this.file);
                ++this.i;
            }
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        catch (Exception e) {
            this.HandleError(e, "ShowFileManagerMainWin : Listing");
        }
    }

    public String[] sortFiles(String[] fileslst, byte sort_type) {
        int i2;
        String r = "";
        if (sort_type == 1) {
            this.i = 1;
            while (this.i < fileslst.length) {
                for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                    if (fileslst[i2].toUpperCase().compareTo(fileslst[i2 + 1].toUpperCase()) <= 0) continue;
                    r = fileslst[i2];
                    fileslst[i2] = fileslst[i2 + 1];
                    fileslst[i2 + 1] = r;
                }
                ++this.i;
            }
        } else if (sort_type == 2) {
            this.i = 1;
            while (this.i < fileslst.length) {
                for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                    if (fileslst[i2].toUpperCase().compareTo(fileslst[i2 + 1].toUpperCase()) >= 0) continue;
                    r = fileslst[i2];
                    fileslst[i2] = fileslst[i2 + 1];
                    fileslst[i2 + 1] = r;
                }
                ++this.i;
            }
        } else if (sort_type == 3) {
            this.i = 1;
            while (this.i < fileslst.length) {
                for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                    if (this.getTime(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(fileslst[i2])))) <= this.getTime(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(fileslst[i2 + 1]))))) continue;
                    r = fileslst[i2];
                    fileslst[i2] = fileslst[i2 + 1];
                    fileslst[i2 + 1] = r;
                }
                ++this.i;
            }
        } else if (sort_type == 4) {
            this.i = 1;
            while (this.i < fileslst.length) {
                for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                    if (this.getTime(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(fileslst[i2])))) >= this.getTime(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(fileslst[i2 + 1]))))) continue;
                    r = fileslst[i2];
                    fileslst[i2] = fileslst[i2 + 1];
                    fileslst[i2 + 1] = r;
                }
                ++this.i;
            }
        }
        try {
            if (sort_type == 5) {
                this.i = 1;
                while (this.i < fileslst.length) {
                    for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                        if (fileslst[i2].substring(0, 2).toUpperCase().compareTo(fileslst[i2 + 1].substring(0, 2).toUpperCase()) <= 0) continue;
                        r = fileslst[i2];
                        fileslst[i2] = fileslst[i2 + 1];
                        fileslst[i2 + 1] = r;
                    }
                    ++this.i;
                }
            } else if (sort_type == 6) {
                this.i = 1;
                while (this.i < fileslst.length) {
                    for (i2 = 1; i2 < fileslst.length - this.i; ++i2) {
                        if (fileslst[i2].toUpperCase().substring(0, 2).compareTo(fileslst[i2 + 1].toUpperCase().substring(0, 2)) >= 0) continue;
                        r = fileslst[i2];
                        fileslst[i2] = fileslst[i2 + 1];
                        fileslst[i2 + 1] = r;
                    }
                    ++this.i;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileslst;
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    void freeMem() {
        Object file = null;
        Object folder = null;
        String curdir = "";
        String[] roots = new String[]{};
        String cur_root = "";
        Object fc = null;
        Object mainwinlist = null;
        Object disp = null;
        this.pm_host = null;
        this.open_file = null;
    }

    void SelectDrive() {
        this.sel_root = new List("\u0414\u0438\u0441\u043a", 3);
        this.roots = FileSystemRegistry.listRoots();
        Image harddrive = null;
        Image flash = null;
        Object favourites = null;
        try {
            harddrive = Image.createImage((String)"/icons/harddrive.png");
            flash = Image.createImage((String)"/icons/flash.png");
        }
        catch (Exception e) {
            this.HandleError(e, "ChangeRoot");
        }
        this.i = 0;
        while (this.i < this.roots.length) {
            if (this.i == 0) {
                this.sel_root.append(this.roots[this.i], harddrive);
            }
            if (this.i != 0) {
                this.sel_root.append(this.roots[this.i], flash);
            }
            ++this.i;
        }
        this.sel_root.setCommandListener((CommandListener)this);
        this.sel_root.addCommand(this.open);
        this.sel_root.addCommand(this.cancel2);
        this.sel_root.addCommand(this.settings);
        this.disp.setCurrent((Displayable)this.sel_root);
    }

    void ChDir(String dest) {
        if (dest == "..") {
            int idx = 0;
            idx = this.curdir.lastIndexOf(47, this.curdir.length() - 2);
            this.curdir = this.curdir.substring(0, idx + 1);
        } else {
            this.curdir = dest;
        }
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.ftp_mode) {
            this.pm_host.ftp_mode();
        }
        if (c == List.SELECT_COMMAND && d == this.mainwinlist) {
            c = this.open_file;
        }
        if (c == List.SELECT_COMMAND && d == this.sel_root) {
            c = this.open;
        }
        if (c == this.up) {
            if (this.curdir.compareTo(this.cur_root) != 0) {
                this.ChDir("..");
            }
            this.ShowFileManagerMainWin();
        }
        if (c == this.about) {
            About about = new About(this.disp, (Displayable)this.mainwinlist);
        }
        if (c == this.open) {
            this.cur_root = this.curdir = String.valueOf(String.valueOf(this.sel_root.getString(this.sel_root.getSelectedIndex()))).concat("mobile/");
            this.ShowFileManagerMainWin();
        }
        if (c == this.cancel2) {
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        if (c == this.open_file) {
            int idx = this.mainwinlist.getSelectedIndex();
            if (idx <= this.cur_dir_subfolders_cnt - 1) {
                String dirname = this.mainwinlist.getString(idx);
                if (dirname != "..") {
                    dirname = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.curdir))).append(dirname).append("/")));
                }
                this.action_success = true;
                this.ChDir(dirname);
                if (this.action_success) {
                    this.ShowFileManagerMainWin();
                }
            } else {
                try {
                    this.fc = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file://").append(this.curdir).append(this.mainwinlist.getString(idx)))));
                    this.pm_host.setFileData(this.fc.fileSize());
                    this.fc.close();
                }
                catch (Exception e) {
                    this.HandleError(e, "open_file");
                }
                this.pm_host.Upload(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(this.mainwinlist.getString(idx)))));
            }
        }
        if (c == this.settings) {
            this.pm_host.ChangeSettings(1);
        }
        if (c == this.select_drive) {
            this.SelectDrive();
        }
    }
}

