/*
 * Decompiled with CFR 0.152.
 */
package motoftp;

import com.motorola.io.FileConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.lcdui.Ticker;
import motoftp.About;
import motoftp.SettingsHandler;
import motoftp.mftp;
import org.jibble.simpleftp.SimpleFTP;

public class FTPBrowser
implements CommandListener {
    Thread t;
    boolean overupd = false;
    Image file = null;
    Image folder = null;
    String curdir = "";
    String[] roots;
    String cur_root;
    FileConnection fc;
    public List mainwinlist;
    int i;
    Display disp;
    TextField mkd_dirname;
    public SimpleFTP ftp;
    Hashtable filesize;
    public boolean connected = false;
    SettingsHandler sh;
    List sel_root = null;
    String[] files_temp;
    int g_point = 0;
    int cur_dir_subfolders_cnt = 0;
    boolean action_success = true;
    mftp pm_host;
    FTPBrowser me;
    Command open_file = new Command("Download", 8, 1);
    Command about = new Command("About", 8, 1);
    Command settings = new Command("Settings", 8, 1);
    Command up = new Command("Up", 8, 2);
    Command disk = new Command("Disk", 8, 1);
    Command cancel2 = new Command("Cancel", 3, 2);
    Command mkd = new Command("Make directory", 8, 1);
    Command mkd_ok = new Command("OK", 4, 1);
    Command delete = new Command("Delete", 8, 1);
    Command disconnect = new Command("Disconnect", 8, 1);
    Command transfer_log = new Command("Transfer Log", 8, 1);

    public FTPBrowser(mftp host, Display d, SettingsHandler Sh) {
        this.sh = Sh;
        try {
            this.file = Image.createImage((String)"/icons/file.png");
            this.folder = Image.createImage((String)"/icons/folder.png");
            this.disp = d;
            this.pm_host = host;
        }
        catch (Exception e) {
            this.HandleError(e, "FTPBrowser constructor");
        }
    }

    void SetLoadListCapt() {
        Ticker tt = new Ticker("Loading filelist...");
        this.mainwinlist.deleteAll();
        this.mainwinlist.setTitle(this.curdir);
        this.mainwinlist.setTicker(tt);
        this.disp.setCurrent((Displayable)this.mainwinlist);
    }

    public void HandleError(Exception what, String where) {
        this.action_success = false;
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MOTOFTP EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void prepare(String dir) {
        this.cur_root = "/";
        this.curdir = dir;
        this.mainwinlist = new List("", 3);
        this.mainwinlist.addCommand(this.open_file);
        this.mainwinlist.addCommand(this.disk);
        this.mainwinlist.addCommand(this.up);
        this.mainwinlist.addCommand(this.delete);
        this.mainwinlist.addCommand(this.mkd);
        this.mainwinlist.addCommand(this.settings);
        this.mainwinlist.addCommand(this.disconnect);
        this.mainwinlist.addCommand(this.transfer_log);
        this.mainwinlist.addCommand(this.about);
        this.mainwinlist.setCommandListener((CommandListener)this);
    }

    public synchronized void Connect() {
        Ticker tick = new Ticker("Connecting...");
        this.mainwinlist.setTicker(tick);
        this.disp.setCurrent((Displayable)this.mainwinlist);
        try {
            this.ftp = new SimpleFTP();
            this.ftp.connect(this.sh.host, this.sh.port, this.sh.login, this.sh.pass);
            this.ftp.cwd(this.sh.ftp_dir);
            this.connected = true;
        }
        catch (Exception e) {
            this.HandleError(e, "Connect");
        }
    }

    public void Disconnect() {
        try {
            if (this.connected) {
                this.ftp.disconnect();
                this.connected = false;
            }
        }
        catch (Exception e) {
            this.HandleError(e, "FTPBrowser.Disconnect");
        }
    }

    public void enterFTPMode(String dir) {
        if (this.mainwinlist == null) {
            this.prepare(dir);
        }
        if (!this.connected) {
            this.t = new Thread(){

                public void run() {
                    FTPBrowser.this.Connect();
                    FTPBrowser.this.ShowFileManagerMainWin();
                }
            };
            this.t.start();
        } else {
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        if (this.overupd) {
            this.ShowFileManagerMainWin();
        }
    }

    String[] List() {
        int point = 0;
        String[] res = new String[1000];
        res[0] = "";
        try {
            Enumeration enumeration = this.ftp.list();
            while (enumeration.hasMoreElements()) {
                ++point;
                String zz = (String)enumeration.nextElement();
                if (zz == null) continue;
                res[point] = zz;
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(point)))).append(": ").append(zz))));
            }
            enumeration = null;
        }
        catch (Exception e) {
            this.HandleError(e, "List");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        res = null;
        return res2;
    }

    String[] ListFolders(String[] data) {
        int point = 0;
        this.cur_dir_subfolders_cnt = 0;
        String[] res = new String[data.length];
        res[0] = "";
        try {
            if (this.curdir.compareTo(this.cur_root) != 0) {
                res[1] = "..";
                point = 1;
                ++this.cur_dir_subfolders_cnt;
            }
            this.i = 1;
            while (this.i < data.length) {
                if (data[this.i] != null && data[this.i].startsWith("d ")) {
                    String tmp = data[this.i].substring(2);
                    if (tmp.compareTo(".") != 0 && tmp.compareTo("..") != 0) {
                        res[++point] = tmp;
                        ++this.cur_dir_subfolders_cnt;
                    }
                    System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(String.valueOf(this.i)))).append(": ").append(data[this.i]))));
                }
                ++this.i;
            }
            data = null;
        }
        catch (Exception e) {
            this.HandleError(e, "ListFolders");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        res = null;
        return res2;
    }

    String[] ListFiles(String[] data) {
        this.filesize = new Hashtable();
        int point = 0;
        String[] res = new String[data.length];
        res[0] = "";
        String tmp = "";
        long size = 0L;
        try {
            this.i = 1;
            while (this.i < data.length) {
                if (data[this.i] != null && data[this.i].startsWith("f ")) {
                    tmp = data[this.i].substring(2);
                    size = Long.parseLong(tmp.substring(0, tmp.indexOf(32)));
                    Long s = new Long(size);
                    res[++point] = tmp.substring(tmp.indexOf(32) + 1);
                    this.filesize.put(res[point], s);
                }
                ++this.i;
            }
            data = null;
        }
        catch (Exception e) {
            this.HandleError(e, "ListFiles");
        }
        String[] res2 = new String[point + 1];
        System.arraycopy(res, 0, res2, 0, point + 1);
        res = null;
        return res2;
    }

    void ShowFileManagerMainWin() {
        this.overupd = false;
        Thread t2 = new Thread(){

            public void run() {
                FTPBrowser.this.SetLoadListCapt();
            }
        };
        t2.start();
        String dirname = "";
        try {
            String[] data = this.List();
            String[] folders = this.ListFolders(data);
            this.i = 1;
            while (this.i < folders.length) {
                dirname = folders[this.i];
                this.mainwinlist.append(dirname, this.folder);
                ++this.i;
            }
            String[] files = this.ListFiles(data);
            this.i = 1;
            while (this.i < files.length) {
                this.mainwinlist.append(files[this.i], this.file);
                ++this.i;
            }
            this.mainwinlist.setTicker(null);
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        catch (Exception e) {
            this.HandleError(e, "ShowFileManagerMainWin : Listing");
        }
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    void freeMem() {
        Object file = null;
        Object folder = null;
        String curdir = "";
        String[] roots = new String[]{};
        String cur_root = "";
        Object fc = null;
        Object mainwinlist = null;
        Object disp = null;
        this.pm_host = null;
        this.open_file = null;
    }

    void ChDir(String dest) {
        if (dest == "..") {
            int idx = 0;
            idx = this.curdir.lastIndexOf(47, this.curdir.length() - 2);
            this.curdir = this.curdir.substring(0, idx + 1);
        } else {
            this.curdir = dest;
        }
        try {
            this.ftp.cwd(this.curdir);
        }
        catch (Exception e) {
            this.HandleError(e, "FTPBrowser.ChDir");
        }
    }

    void mkd() {
        Form form = new Form("New dir");
        this.mkd_dirname = new TextField("Name: ", "", 255, 0);
        form.append((Item)this.mkd_dirname);
        form.addCommand(this.mkd_ok);
        form.addCommand(this.cancel2);
        form.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)form);
    }

    public void viewLog() {
        List loglist = new List("Log", 3);
        Enumeration e = this.ftp.getLog();
        while (e.hasMoreElements()) {
            loglist.append((String)e.nextElement(), null);
        }
        loglist.addCommand(this.cancel2);
        loglist.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)loglist);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.disk) {
            this.pm_host.disk_mode();
        }
        if (c == List.SELECT_COMMAND && d == this.mainwinlist) {
            c = this.open_file;
        }
        if (c == this.up) {
            if (this.curdir.compareTo(this.cur_root) != 0) {
                this.ChDir("..");
            }
            this.ShowFileManagerMainWin();
        }
        if (c == this.about) {
            About about = new About(this.disp, (Displayable)this.mainwinlist);
        }
        if (c == this.cancel2) {
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        if (c == this.open_file) {
            int idx = this.mainwinlist.getSelectedIndex();
            if (idx <= this.cur_dir_subfolders_cnt - 1) {
                String dirname = this.mainwinlist.getString(idx);
                if (dirname != "..") {
                    dirname = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.curdir))).append(dirname).append("/")));
                }
                this.action_success = true;
                this.ChDir(dirname);
                this.ShowFileManagerMainWin();
            } else {
                Long z = (Long)this.filesize.get(this.mainwinlist.getString(idx));
                this.pm_host.setFileData(z);
                this.pm_host.Download(this.mainwinlist.getString(idx));
            }
        }
        if (c == this.mkd) {
            this.mkd();
        }
        if (c == this.mkd_ok) {
            try {
                this.ftp.mkd(this.mkd_dirname.getString());
                this.ShowFileManagerMainWin();
            }
            catch (Exception e) {
                this.HandleError(e, "mkd_ok");
            }
        }
        if (c == this.delete) {
            int idx = this.mainwinlist.getSelectedIndex();
            if (idx <= this.cur_dir_subfolders_cnt - 1) {
                try {
                    this.ftp.rmd(this.mainwinlist.getString(idx));
                    this.ShowFileManagerMainWin();
                }
                catch (Exception e) {
                    this.HandleError(e, "delete");
                }
            } else {
                try {
                    this.ftp.dele(this.mainwinlist.getString(idx));
                    this.ShowFileManagerMainWin();
                }
                catch (Exception e) {
                    this.HandleError(e, "delete");
                }
            }
        }
        if (c == this.settings) {
            this.pm_host.ChangeSettings(2);
        }
        if (c == this.disconnect) {
            this.Disconnect();
        }
        if (c == this.transfer_log) {
            this.viewLog();
        }
    }
}

