/*
 * Decompiled with CFR 0.152.
 */
package motoftp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import motoftp.Account;
import motoftp.SettingsHandler;

public class AccountContainer {
    Display disp;
    Vector accounts;
    String active_account = "";

    public AccountContainer(Display d) {
        this.disp = d;
        this.accounts = new Vector();
    }

    public boolean validateName(String name) {
        boolean res = true;
        Enumeration e = this.accounts.elements();
        Account tmp = null;
        while (e.hasMoreElements()) {
            tmp = (Account)e.nextElement();
            if (tmp.account_name.compareTo(name) != 0) continue;
            res = false;
        }
        tmp = null;
        return res;
    }

    public void LoadAccounts() {
        block4: {
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"motoftp_accounts", (boolean)true);
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                String data = "";
                while (re.hasNextElement()) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(re.nextRecord());
                    DataInputStream dis = new DataInputStream(bis);
                    data = dis.readUTF();
                    if (data.startsWith("curacc: ")) {
                        this.active_account = data.substring(8);
                    }
                    if (!data.startsWith("accdata: ")) continue;
                    data = data.substring(9);
                    this.accounts.addElement(new Account(data));
                }
                rs.closeRecordStore();
            }
            catch (Exception e) {
                if (e instanceof EOFException) break block4;
                this.HandleError(e, "AccountContainer.LoadAccounts");
            }
        }
    }

    public Account getActiveAccount() {
        Enumeration e = this.accounts.elements();
        Account res = new Account();
        Account tmp = null;
        while (e.hasMoreElements()) {
            tmp = (Account)e.nextElement();
            if (tmp.account_name.compareTo(this.active_account) != 0) continue;
            res = tmp;
        }
        tmp = null;
        return res;
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(5000);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MOTOFTP EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void setActiveAccount(String active_acc_name) {
        this.active_account = active_acc_name;
    }

    public void addAccount(SettingsHandler sh) {
        if (this.validateName(sh.acc_name)) {
            Account newacc = new Account();
            newacc.account_name = sh.acc_name;
            newacc.ftp_dir = sh.ftp_dir;
            newacc.host = sh.host;
            newacc.login = sh.login;
            newacc.pass = sh.pass;
            newacc.port = sh.port;
            newacc.start_dir = sh.start_dir;
            newacc.sort_files = sh.sort_files;
            this.accounts.addElement(newacc);
        }
    }

    public void updateAccount(SettingsHandler sh) {
        if (this.validateName(sh.acc_name) || sh.old_acc_name.compareTo(sh.acc_name) == 0) {
            Enumeration e = this.accounts.elements();
            int point = -1;
            Account newacc = null;
            while (e.hasMoreElements()) {
                ++point;
                newacc = (Account)e.nextElement();
                if (newacc.account_name.compareTo(sh.old_acc_name) != 0) continue;
                newacc.account_name = sh.acc_name;
                newacc.account_name = sh.acc_name;
                newacc.ftp_dir = sh.ftp_dir;
                newacc.host = sh.host;
                newacc.login = sh.login;
                newacc.pass = sh.pass;
                newacc.port = sh.port;
                newacc.start_dir = sh.start_dir;
                newacc.sort_files = sh.sort_files;
                this.accounts.setElementAt(newacc, point);
                break;
            }
            e = null;
            newacc = null;
        }
    }

    public void deleteAccount(String name) {
        Enumeration e = this.accounts.elements();
        int point = -1;
        Account newacc = null;
        while (e.hasMoreElements()) {
            ++point;
            newacc = (Account)e.nextElement();
            if (newacc.account_name.compareTo(name) != 0) continue;
            this.accounts.removeElementAt(point);
            break;
        }
        e = null;
        newacc = null;
    }

    public void SaveAccounts() {
        block4: {
            try {
                RecordStore rs = RecordStore.openRecordStore((String)"motoftp_accounts", (boolean)true);
                RecordEnumeration re = rs.enumerateRecords(null, null, false);
                Account a = null;
                while (re.hasNextElement()) {
                    rs.deleteRecord(re.nextRecordId());
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(bos);
                dos.writeUTF("curacc: ".concat(String.valueOf(String.valueOf(this.active_account))));
                byte[] b = bos.toByteArray();
                rs.addRecord(b, 0, b.length);
                bos.close();
                bos = null;
                dos = null;
                Enumeration e = this.accounts.elements();
                while (e.hasMoreElements()) {
                    bos = new ByteArrayOutputStream();
                    dos = new DataOutputStream(bos);
                    a = (Account)e.nextElement();
                    dos.writeUTF("accdata: ".concat(String.valueOf(String.valueOf(a.getRawData()))));
                    b = bos.toByteArray();
                    rs.addRecord(b, 0, b.length);
                    bos.close();
                    bos = null;
                    dos = null;
                }
                rs.closeRecordStore();
            }
            catch (Exception e) {
                if (e instanceof EOFException) break block4;
                this.HandleError(e, "AccountContainer.LoadAccounts");
            }
        }
    }

    public Enumeration enumerateAccounts() {
        return this.accounts.elements();
    }

    public Account getAccountByName(String name) {
        Enumeration e = this.accounts.elements();
        Account res = new Account();
        Account tmp = null;
        while (e.hasMoreElements()) {
            tmp = (Account)e.nextElement();
            if (tmp.account_name.compareTo(name) != 0) continue;
            res = tmp;
        }
        tmp = null;
        return res;
    }
}

