/*
 * Decompiled with CFR 0.152.
 */
package com.jenfa;

import com.jenfa.FTPFileParser;
import java.util.Calendar;

public class UnixFileParser
extends FTPFileParser {
    public static String cvsId = "@(#)$Id: UnixFileParser.java,v 1.12 2005/06/03 11:26:25 bruceb Exp $";
    private static final String SYMLINK_ARROW = "->";
    private static final char SYMLINK_CHAR = 'l';
    private static final char ORDINARY_FILE_CHAR = '-';
    private static final char DIRECTORY_CHAR = 'd';
    private static final int MIN_FIELD_COUNT = 8;

    public static boolean isUnix(String raw) {
        char ch = raw.charAt(0);
        return ch == '-' || ch == 'd' || ch == 'l';
    }

    public String parse(String raw) throws Exception {
        if (!UnixFileParser.isUnix(raw)) {
            return null;
        }
        String[] fields = this.split(raw);
        if (fields.length < 8) {
            StringBuffer listing = new StringBuffer("Unexpected number of fields in listing '");
            listing.append(raw).append("' - expected minimum ").append(8).append(" fields but found ").append(fields.length).append(" fields");
            throw new Exception(listing.toString());
        }
        int index = 0;
        char ch = raw.charAt(0);
        String permissions = fields[index++];
        ch = permissions.charAt(0);
        boolean isDir = false;
        boolean isLink = false;
        if (ch == 'd') {
            isDir = true;
        } else if (ch == 'l') {
            isLink = true;
        }
        int linkCount = 0;
        if (Character.isDigit(fields[index].charAt(0))) {
            try {
                linkCount = Integer.parseInt(fields[index++]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String owner = fields[index++];
        String group = fields[index++];
        long size = 0L;
        String sizeStr = fields[index];
        if (!Character.isDigit(sizeStr.charAt(0)) && Character.isDigit(group.charAt(0))) {
            sizeStr = group;
            group = "";
        } else {
            ++index;
        }
        try {
            size = Long.parseLong(sizeStr);
        }
        catch (NumberFormatException ex) {
            throw new Exception("Failed to parse size: ".concat(String.valueOf(String.valueOf(sizeStr))));
        }
        int dateTimePos = index;
        Object lastModified = null;
        StringBuffer stamp = new StringBuffer(fields[index++]);
        stamp.append('-').append(fields[index++]).append('-');
        String field = fields[index++];
        if (field.indexOf(58) < 0) {
            stamp.append(field);
            lastModified = null;
        } else {
            Calendar cal = Calendar.getInstance();
            int year = cal.get(1);
            stamp.append(year).append('-').append(field);
            lastModified = null;
        }
        String name = null;
        String linkedname = null;
        int pos = 0;
        boolean ok = true;
        for (int i = dateTimePos; i < dateTimePos + 3; ++i) {
            if ((pos = raw.indexOf(fields[i], pos)) < 0) {
                ok = false;
                break;
            }
            pos += fields[i].length();
        }
        if (ok) {
            String remainder = raw.substring(pos).trim();
            if (!isLink) {
                name = remainder;
            } else {
                pos = remainder.indexOf(SYMLINK_ARROW);
                if (pos <= 0) {
                    name = remainder;
                } else {
                    int len = SYMLINK_ARROW.length();
                    name = remainder.substring(0, pos).trim();
                    if (pos + len < remainder.length()) {
                        linkedname = remainder.substring(pos + len);
                    }
                }
            }
        } else {
            throw new Exception("Failed to retrieve name: ".concat(String.valueOf(String.valueOf(raw))));
        }
        String res = name;
        res = isDir ? "d ".concat(String.valueOf(String.valueOf(res))) : String.valueOf(String.valueOf(new StringBuffer("f ").append(size).append(" ").append(res)));
        return res;
    }

    static {
        SYMLINK_ARROW = SYMLINK_ARROW;
        SYMLINK_CHAR = (char)108;
        ORDINARY_FILE_CHAR = (char)45;
        DIRECTORY_CHAR = (char)100;
        MIN_FIELD_COUNT = 8;
    }
}

