/*
 * Decompiled with CFR 0.152.
 */
package com.jenfa;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringTokenizer
implements Enumeration {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private char maxDelimChar;

    private void setMaxDelimChar() {
        if (this.delimiters == null) {
            this.maxDelimChar = '\u0000';
            return;
        }
        char c = '\u0000';
        for (int i = 0; i < this.delimiters.length(); ++i) {
            char c1 = this.delimiters.charAt(i);
            if (c >= c1) continue;
            c = c1;
        }
        this.maxDelimChar = c;
    }

    public StringTokenizer(String s, String s1, boolean flag) {
        this.str = s;
        this.maxPosition = s.length();
        this.delimiters = s1;
        this.retDelims = flag;
        this.setMaxDelimChar();
    }

    public StringTokenizer(String s, String s1) {
        this(s, s1, false);
    }

    public StringTokenizer(String s) {
        this(s, " \t\n\r\f", false);
    }

    private int skipDelimiters(int i) {
        char c;
        int j;
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        for (j = i; !this.retDelims && j < this.maxPosition && (c = this.str.charAt(j)) <= this.maxDelimChar && this.delimiters.indexOf(c) >= 0; ++j) {
        }
        return j;
    }

    private int scanToken(int i) {
        char c1;
        char c;
        int j;
        for (j = i; j < this.maxPosition && ((c = this.str.charAt(j)) > this.maxDelimChar || this.delimiters.indexOf(c) < 0); ++j) {
        }
        if (this.retDelims && i == j && (c1 = this.str.charAt(j)) <= this.maxDelimChar && this.delimiters.indexOf(c1) >= 0) {
            ++j;
        }
        return j;
    }

    public boolean hasMoreTokens() {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public String nextToken() {
        this.currentPosition = this.newPosition < 0 || this.delimsChanged ? this.skipDelimiters(this.currentPosition) : this.newPosition;
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int i = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(i, this.currentPosition);
    }

    public String nextToken(String s) {
        this.delimiters = s;
        this.delimsChanged = true;
        this.setMaxDelimChar();
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() {
        return this.nextToken();
    }

    public int countTokens() {
        int i = 0;
        int j = this.currentPosition;
        while (j < this.maxPosition && (j = this.skipDelimiters(j)) < this.maxPosition) {
            j = this.scanToken(j);
            ++i;
        }
        return i;
    }
}

