/*
 * Decompiled with CFR 0.152.
 */
package com.jenfa;

import com.jenfa.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BufferedOutputStream
extends FilterOutputStream {
    protected byte[] buf;
    protected int count;

    public BufferedOutputStream(OutputStream outputstream) {
        this(outputstream, 512);
    }

    public BufferedOutputStream(OutputStream outputstream, int i) {
        super(outputstream);
        if (i <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[i];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    public synchronized void write(int i) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)i;
    }

    public synchronized void write(byte[] abyte0, int i, int j) throws IOException {
        if (j >= this.buf.length) {
            this.flushBuffer();
            this.out.write(abyte0, i, j);
            return;
        }
        if (j > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(abyte0, i, this.buf, this.count, j);
        this.count += j;
    }

    public synchronized void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

