/*
 * Decompiled with CFR 0.152.
 */
package com.jenfa;

import com.jenfa.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public BufferedInputStream(InputStream inputstream) {
        this(inputstream, defaultBufferSize);
    }

    public BufferedInputStream(InputStream inputstream, int i) {
        super(inputstream);
        if (i <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[i];
    }

    private void fill() throws IOException {
        if (this.markpos < 0) {
            this.pos = 0;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                int i = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, i);
                this.pos = i;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
            } else {
                int j = this.pos * 2;
                if (j > this.marklimit) {
                    j = this.marklimit;
                }
                byte[] abyte0 = new byte[j];
                System.arraycopy(this.buf, 0, abyte0, 0, this.pos);
                this.buf = abyte0;
            }
        }
        this.count = this.pos;
        int k = this.in.read(this.buf, this.pos, this.buf.length - this.pos);
        if (k > 0) {
            this.count = k + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] abyte0, int i, int j) throws IOException {
        int k = this.count - this.pos;
        if (k <= 0) {
            if (j >= this.buf.length && this.markpos < 0) {
                return this.in.read(abyte0, i, j);
            }
            this.fill();
            k = this.count - this.pos;
            if (k <= 0) {
                return -1;
            }
        }
        int l = k >= j ? j : k;
        System.arraycopy(this.buf, this.pos, abyte0, i, l);
        this.pos += l;
        return l;
    }

    public synchronized int read(byte[] abyte0, int i, int j) throws IOException {
        int l;
        this.ensureOpen();
        if ((i | j | i + j | abyte0.length - (i + j)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (j == 0) {
            return 0;
        }
        int k = this.read1(abyte0, i, j);
        if (k <= 0) {
            return k;
        }
        while (k < j && this.in.available() > 0 && (l = this.read1(abyte0, i + k, j - k)) > 0) {
            k += l;
        }
        return k;
    }

    public synchronized long skip(long l) throws IOException {
        this.ensureOpen();
        if (l <= 0L) {
            return 0L;
        }
        long l1 = this.count - this.pos;
        if (l1 <= 0L) {
            if (this.markpos < 0) {
                return this.in.skip(l);
            }
            this.fill();
            l1 = this.count - this.pos;
            if (l1 <= 0L) {
                return 0L;
            }
        }
        long l2 = l1 >= l ? l : l1;
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in.available();
    }

    public synchronized void mark(int i) {
        this.marklimit = i;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

