/*
 * Decompiled with CFR 0.152.
 */
package com.telecom;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Splash
extends Canvas {
    private Display display;
    private Displayable parent;
    private Image image;
    private Timer timer = new Timer();
    public String imageName = "/res/splash.png";
    public int splashTime = 2500;
    public boolean canCancel = false;
    public int backgroundColor = 0xFFFFFF;
    public int textColor = 0;
    public String[] textHeader = new String[0];
    public String[] textFooter = new String[0];

    public Splash(Display display, Displayable displayable) {
        this.setFullScreenMode(true);
        this.display = display;
        this.parent = displayable;
    }

    public static void showSplash(Display display, Displayable displayable) {
        Splash splash = new Splash(display, displayable);
        splash.show();
    }

    public void show() {
        try {
            this.image = Image.createImage((String)this.imageName);
        }
        catch (Exception exception) {
            this.image = null;
        }
        this.display.setCurrent((Displayable)this);
        this.timer.scheduleAtFixedRate((TimerTask)new SplashTimerTask(this), this.splashTime, Integer.MAX_VALUE);
    }

    protected void paint(Graphics graphics) {
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.image != null) {
            graphics.drawImage(this.image, this.getWidth() / 2, this.getHeight() / 2, 3);
        }
        graphics.setColor(this.textColor);
        int n = -graphics.getFont().getHeight();
        int n2 = 0;
        while (n2 < this.textHeader.length) {
            graphics.drawString(this.textHeader[n2], (this.getWidth() - graphics.getFont().stringWidth(this.textHeader[n2])) / 2, n += graphics.getFont().getHeight(), 0);
            ++n2;
        }
        n = this.getHeight();
        int n3 = 10;
        int n4 = this.textFooter.length - 1;
        while (n4 > -1) {
            graphics.drawString(this.textFooter[n4], (this.getWidth() - graphics.getFont().stringWidth(this.textFooter[n4])) / 2, n -= graphics.getFont().getHeight(), 0);
            --n4;
        }
    }

    protected void schedule() {
        this.timer.cancel();
        this.display.setCurrent(this.parent);
    }

    protected void keyReleased(int n) {
        if (this.canCancel) {
            this.schedule();
        }
    }

    private class SplashTimerTask
    extends TimerTask {
        private Splash splash;

        protected SplashTimerTask(Splash splash2) {
            this.splash = splash2;
        }

        public void run() {
            this.splash.schedule();
        }
    }
}

