/*
 * Decompiled with CFR 0.152.
 */
package com.telecom;

import com.motorola.io.FileConnection;
import com.motorola.io.FileSystemRegistry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.io.Connector;

public class FileSystemAccessor {
    private FileConnection connection;
    private String location;

    public FileSystemAccessor(String string) {
        this.location = string;
    }

    private void close() {
        try {
            this.connection.close();
            this.connection = null;
        }
        catch (Exception exception) {
            System.out.println("Close connection failed: " + exception.getMessage());
        }
    }

    private void open(int n) {
        try {
            this.connection = (FileConnection)Connector.open((String)("file://" + this.location), (int)n);
        }
        catch (Exception exception) {
            this.connection = null;
            System.out.println("Open connection '" + this.location + "' failed: " + exception.getMessage());
        }
    }

    private void open() {
        this.open(1);
    }

    public long availableSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.availableSize();
            this.close();
        }
        return l;
    }

    public boolean canRead() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canRead();
            this.close();
        }
        return bl;
    }

    public boolean canWrite() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.canWrite();
            this.close();
        }
        return bl;
    }

    public boolean create() {
        boolean bl = false;
        this.open(2);
        if (this.connection != null) {
            if (this.connection.exists() || this.connection.create()) {
                bl = true;
            }
            this.close();
        }
        return bl;
    }

    public boolean delete() {
        boolean bl = false;
        this.open(2);
        if (this.connection != null) {
            if (!this.connection.exists() || this.connection.delete()) {
                bl = true;
            }
            this.close();
        }
        return bl;
    }

    public long directorySize(boolean bl) {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.directorySize(bl);
            this.close();
        }
        return l;
    }

    public boolean exists() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.exists();
            this.close();
        }
        return bl;
    }

    public long fileSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.fileSize();
            this.close();
        }
        return l;
    }

    public boolean isDirectory() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isDirectory();
            this.close();
        }
        return bl;
    }

    public boolean isHidden() {
        boolean bl = false;
        this.open();
        if (this.connection != null) {
            bl = this.connection.isHidden();
            this.close();
        }
        return bl;
    }

    public long lastModified() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.lastModified();
            this.close();
        }
        return l;
    }

    public String[] list() {
        String[] stringArray = null;
        this.open();
        if (this.connection != null) {
            stringArray = this.connection.list();
            this.close();
        }
        return stringArray;
    }

    public static String[] listRoots() {
        return FileSystemRegistry.listRoots();
    }

    public byte[] read() {
        byte[] byArray = null;
        try {
            this.open(1);
            long l = this.connection.fileSize();
            byArray = new byte[(int)l];
            DataInputStream dataInputStream = this.connection.openDataInputStream();
            if (l != (long)dataInputStream.read(byArray)) {
                byArray = null;
            }
            dataInputStream.close();
            dataInputStream = null;
            this.close();
        }
        catch (Exception exception) {
            byArray = null;
            System.out.println("Read from '" + this.location + "' failed: " + exception.getMessage());
        }
        return byArray;
    }

    public boolean rename(String string) {
        boolean bl = false;
        this.open(2);
        if (this.connection != null) {
            if (this.connection.rename("file://" + string)) {
                bl = true;
            }
            this.close();
        }
        return bl;
    }

    public boolean write(byte[] byArray) {
        boolean bl = false;
        try {
            this.open(2);
            if (this.connection.exists()) {
                this.connection.delete();
            }
            this.connection.create();
            DataOutputStream dataOutputStream = this.connection.openDataOutputStream();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.flush();
            dataOutputStream.close();
            this.close();
            bl = true;
        }
        catch (Exception exception) {
            System.out.println("Write to '" + this.location + "' failed: " + exception.getMessage());
        }
        return bl;
    }

    public void setHidden(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setHidden(bl);
            this.close();
        }
    }

    public void setReadable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setReadable(bl);
            this.close();
        }
    }

    public void setWriteable(boolean bl) {
        this.open();
        if (this.connection != null) {
            this.connection.setWriteable(bl);
            this.close();
        }
    }

    public long totalSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.totalSize();
            this.close();
        }
        return l;
    }

    public long usedSize() {
        long l = -1L;
        this.open();
        if (this.connection != null) {
            l = this.connection.usedSize();
            this.close();
        }
        return l;
    }
}

