/*
 * Decompiled with CFR 0.152.
 */
package com.telecom;

import java.util.Timer;
import java.util.TimerTask;
import javax.microedition.lcdui.Canvas;

public abstract class ControlCanvas
extends Canvas {
    private static final int TIMER_INTERVAL = 250;
    private static final int WAIT_FOR_LONG = 500;
    private Timer timer = new Timer();
    private long counter = 0L;
    private int lastCode = 0;
    private long lastTimeMillis = 0L;
    private boolean isPressed = false;
    private boolean isLongPressed = false;
    public long lastTime = System.currentTimeMillis();

    protected abstract void onTimer();

    protected abstract void onKeyPress(int var1);

    protected abstract void onKeyRepeated(int var1);

    protected abstract void onKeyLongPress(int var1);

    public ControlCanvas() {
        this.setFullScreenMode(true);
        this.timer.scheduleAtFixedRate((TimerTask)new ControlCanvasTimerTask(this), 250L, 250L);
    }

    public void recreateTimer() {
        try {
            this.timer.cancel();
            this.timer = null;
        }
        catch (Exception exception) {
            this.timer = new Timer();
            this.timer.scheduleAtFixedRate((TimerTask)new ControlCanvasTimerTask(this), 250L, 250L);
        }
    }

    protected void keyPressed(int n) {
        if (System.currentTimeMillis() - this.lastTime > 1000L) {
            this.recreateTimer();
            this.repaint();
        }
        this.lastCode = n;
        this.lastTimeMillis = System.currentTimeMillis();
        this.isPressed = true;
        this.isLongPressed = false;
    }

    protected void keyReleased(int n) {
        if (this.isPressed && !this.isLongPressed) {
            this.onKeyPress(this.lastCode);
        }
        this.lastCode = 0;
        this.isPressed = false;
        this.isLongPressed = false;
    }

    protected void schedule() {
        this.lastTime = System.currentTimeMillis();
        ++this.counter;
        if (this.lastCode != 0 && System.currentTimeMillis() - this.lastTimeMillis >= 500L) {
            if (!this.isLongPressed) {
                this.onKeyLongPress(this.lastCode);
                this.isLongPressed = true;
            } else {
                this.onKeyRepeated(this.lastCode);
            }
        }
        this.onTimer();
    }

    public long getCounter() {
        return this.counter;
    }

    private class ControlCanvasTimerTask
    extends TimerTask {
        private ControlCanvas controlcanvas;

        protected ControlCanvasTimerTask(ControlCanvas controlCanvas2) {
            this.controlcanvas = controlCanvas2;
        }

        public void run() {
            this.controlcanvas.schedule();
        }
    }
}

