/*
 * Decompiled with CFR 0.152.
 */
package motoamp;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import motoamp.AudioPlayerUI;

public class PlaylistEditor
implements CommandListener {
    String[] playlist;
    List editor;
    AudioPlayerUI apUI;
    Command ok = new Command("OK", 4, 1);
    Command cancel = new Command("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 3, 1);
    Command delete = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 8, 1);
    Command play = new Command("\u041f\u0440\u043e\u0438\u0433\u0440\u0430\u0442\u044c", 8, 1);
    Command to_up = new Command("\u0412 \u043d\u0430\u0447\u0430\u043b\u043e", 8, 1);
    Command to_down = new Command("\u0412 \u043a\u043e\u043d\u0435\u0446", 8, 1);
    Command up10 = new Command("\u0412\u0432\u0435\u0440\u0445 10", 8, 1);
    Command down10 = new Command("\u0412\u043d\u0438\u0437 10", 8, 1);
    Command center = new Command("\u0412 \u0441\u0435\u0440\u0435\u0434\u0438\u043d\u0443", 8, 1);

    String getMetaData(int id) {
        String res = this.getLastURLPart(this.playlist[id], false);
        return res;
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    public void openList(String[] files) {
        this.playlist = files;
    }

    void editList(AudioPlayerUI cb) {
        this.apUI = cb;
        this.editor = new List("\u041f\u043b\u0435\u0439\u043b\u0438\u0441\u0442", 3);
        for (int i = 0; i < this.playlist.length; ++i) {
            this.editor.append(this.getMetaData(i), null);
        }
        this.editor.addCommand(this.ok);
        this.editor.addCommand(this.cancel);
        this.editor.addCommand(this.delete);
        this.editor.addCommand(this.play);
        this.editor.addCommand(this.to_up);
        this.editor.addCommand(this.to_down);
        this.editor.addCommand(this.up10);
        this.editor.addCommand(this.down10);
        this.editor.addCommand(this.center);
        this.editor.setCommandListener((CommandListener)this);
        this.apUI.disp.setCurrent((Displayable)this.editor);
    }

    public void commandAction(Command c, Displayable d) {
        if (c == List.SELECT_COMMAND && d == this.editor) {
            c = this.play;
        }
        if (c == this.delete) {
            for (int i = this.editor.getSelectedIndex() + 1; i < this.playlist.length; ++i) {
                this.playlist[i - 1] = this.playlist[i];
            }
            String[] temp = new String[this.playlist.length - 1];
            System.arraycopy(this.playlist, 0, temp, 0, temp.length);
            this.playlist = temp;
            temp = null;
            this.editor.delete(this.editor.getSelectedIndex());
        }
        if (c == this.to_up) {
            this.editor.setSelectedIndex(0, true);
        }
        if (c == this.to_down) {
            this.editor.setSelectedIndex(this.editor.size() - 1, true);
        }
        if (c == this.center) {
            this.editor.setSelectedIndex((this.editor.size() - 1) / 2, true);
        }
        if (c == this.up10) {
            int idx = this.editor.getSelectedIndex() - 10;
            if (idx < 0) {
                idx = 0;
            }
            this.editor.setSelectedIndex(idx, true);
        }
        if (c == this.down10) {
            int idx = this.editor.getSelectedIndex() + 10;
            if (idx > this.editor.size() - 1) {
                idx = this.editor.size() - 1;
            }
            this.editor.setSelectedIndex(idx, true);
        }
        if (c == this.cancel) {
            this.playlist = null;
            System.gc();
            this.apUI.playEditorCallback1(this);
        }
        if (c == this.ok) {
            this.apUI.playEditorCallback2(this.playlist, this);
        }
        if (c == this.play) {
            this.apUI.playEditorCallback3(this.playlist, this.editor.getSelectedIndex(), this);
        }
    }
}

