/*
 * Decompiled with CFR 0.152.
 */
package motoamp;

import java.util.Random;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.MetaDataControl;
import javax.microedition.media.control.VolumeControl;
import motoamp.AudioPlayerRepaintControl;
import motoamp.PlaylistEditor;
import motoamp.PlaylistManager;
import motoamp.ScrollingText;
import motoamp.SettingsHandler;
import motoamp.TrackMetaData;
import motoamp.callback;
import motoamp.exec;

public class AudioPlayerUI
extends Canvas
implements PlayerListener,
CommandListener,
Runnable {
    Display disp;
    callback Callback;
    char[] ascii2char = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u0402', '\u0403', '\u201a', '\u0453', '\u201e', '\u2026', '\u2020', '\u2021', '\u20ac', '\u2030', '\u0409', '\u2039', '\u040a', '\u040c', '\u040b', '\u040f', '\u0452', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u0098', '\u2122', '\u0459', '\u203a', '\u045a', '\u045c', '\u045b', '\u045f', '\u00a0', '\u040e', '\u045e', '\u0408', '\u00a4', '\u0490', '\u00a6', '\u00a7', '\u0401', '\u00a9', '\u0404', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u0407', '\u00b0', '\u00b1', '\u0406', '\u0456', '\u0491', '\u00b5', '\u00b6', '\u00b7', '\u0451', '\u2116', '\u0454', '\u00bb', '\u0458', '\u0405', '\u0455', '\u0457', '\u0410', '\u0411', '\u0412', '\u0413', '\u0414', '\u0415', '\u0416', '\u0417', '\u0418', '\u0419', '\u041a', '\u041b', '\u041c', '\u041d', '\u041e', '\u041f', '\u0420', '\u0421', '\u0422', '\u0423', '\u0424', '\u0425', '\u0426', '\u0427', '\u0428', '\u0429', '\u042a', '\u042b', '\u042c', '\u042d', '\u042e', '\u042f', '\u0430', '\u0431', '\u0432', '\u0433', '\u0434', '\u0435', '\u0436', '\u0437', '\u0438', '\u0439', '\u043a', '\u043b', '\u043c', '\u043d', '\u043e', '\u043f', '\u0440', '\u0441', '\u0442', '\u0443', '\u0444', '\u0445', '\u0446', '\u0447', '\u0448', '\u0449', '\u044a', '\u044b', '\u044c', '\u044d', '\u044e', '\u044f'};
    TextField tef;
    Player pl = null;
    ScrollingText st1;
    ScrollingText st2;
    ScrollingText st3;
    boolean loaded = false;
    boolean nameFromMeta = false;
    VolumeControl vc = null;
    byte seek_step = 0;
    byte volume_step = 0;
    Random rnd;
    int volume = 0;
    Command exit2 = new Command("\u0412\u044b\u0445\u043e\u0434", 8, 3);
    Command save = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 8, 3);
    Command ok = new Command("OK", 4, 1);
    Command edit = new Command("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442", 8, 3);
    int timeout = 0;
    boolean show_info = true;
    boolean s_override_info = false;
    String info = "";
    String override_info = "";
    String filename;
    String filepath;
    boolean auto_scroll = true;
    boolean backlight = true;
    boolean random_scroll = false;
    boolean override_klock = false;
    boolean keyboard_locked = false;
    String total;
    String played;
    String[] audlist;
    int[] real_idxs;
    TrackMetaData tmd = new TrackMetaData();
    int index;
    SettingsHandler Sh;
    AudioPlayerRepaintControl aprc = new AudioPlayerRepaintControl(this);
    Command exit = new Command("\u0417\u0430\u043a\u0440\u044b\u0442\u044c", 7, 1);
    Command viewMeta = new Command("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0444\u0430\u0439\u043b\u0435", 8, 3);
    Font song_title = Font.getFont((int)0, (int)0, (int)8);

    public AudioPlayerUI(Display d, exec prev, String[] filelist, int[] ridxs, int idx, SettingsHandler sh) {
        this.disp = d;
        this.Sh = sh;
        this.disp.flashBacklight(Integer.MAX_VALUE);
        this.Callback = prev;
        this.audlist = filelist;
        this.real_idxs = ridxs;
        this.index = idx;
        this.Init();
    }

    public AudioPlayerUI(Display d, exec prev, String[] filelist, SettingsHandler sh) {
        this.disp = d;
        this.Sh = sh;
        this.disp.flashBacklight(Integer.MAX_VALUE);
        this.Callback = prev;
        this.audlist = filelist;
        this.real_idxs = null;
        this.index = 0;
        this.Init();
    }

    public void Init() {
        this.addCommand(this.exit);
        this.addCommand(this.save);
        this.addCommand(this.edit);
        this.addCommand(this.viewMeta);
        this.setCommandListener(this);
        this.volume = this.Sh.volume;
        this.seek_step = this.Sh.seek_step;
        this.volume_step = this.Sh.volume_step;
        this.random_scroll = this.Sh.ap_shuffle;
        this.rnd = new Random(System.currentTimeMillis());
        if (this.random_scroll) {
            int rnd_znac = this.rnd.nextInt();
            if (rnd_znac < 0) {
                rnd_znac = -1 * rnd_znac;
            }
            this.index = rnd_znac % this.audlist.length;
            if (this.index > this.audlist.length - 1) {
                this.index = 0;
            }
        }
    }

    void playEditorCallback1(Object kill) {
        kill = null;
        this.disp.setCurrent((Displayable)this);
    }

    void playEditorCallback2(String[] files, Object kill) {
        this.audlist = files;
        kill = null;
        this.disp.setCurrent((Displayable)this);
    }

    void playEditorCallback3(String[] files, int index_, Object kill) {
        this.audlist = files;
        this.index = index_;
        kill = null;
        this.disp.setCurrent((Displayable)this);
        this.pl.deallocate();
        try {
            this.openFile(this.audlist[this.index]);
            this.prepareFile();
            this.launchPlayer();
        }
        catch (Exception e) {
            this.HandleError(e, "playEditorCallback3");
        }
    }

    public void run() {
        if (this.s_override_info) {
            ++this.timeout;
            if (this.timeout == 30) {
                this.s_override_info = false;
                this.timeout = 0;
            }
        }
        this.repaint();
    }

    public void HandleError(Exception what, String where) {
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        ErrorOut.addCommand(this.exit2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[FILEMANAGER EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void freeMem() {
        this.pl = null;
        this.song_title = null;
        this.vc = null;
        this.disp = null;
        System.gc();
    }

    protected void paint(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(255, 255, 255);
        g.setFont(this.song_title);
        int skip = 0;
        if (!this.nameFromMeta) {
            if (this.st3.tfpartw > this.getWidth()) {
                g.drawString(this.st3.getStr(), this.st3.getPos(), 1, 0);
                this.st3.NextStep();
            } else {
                g.drawString(this.filename, 1, 1, 0);
            }
            skip = 1;
        } else {
            if (this.st1.tfpartw > this.getWidth()) {
                g.drawString(this.st1.getStr(), this.st1.getPos(), 1, 0);
                this.st1.NextStep();
            } else {
                g.drawString(this.tmd.trackAuthor, 1, 1, 0);
            }
            if (this.st2.tfpartw > this.getWidth()) {
                g.drawString(this.st2.getStr(), this.st2.getPos(), this.song_title.getHeight() + 2, 0);
                this.st2.NextStep();
            } else {
                g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tmd.trackTitle))).append(" (").append(this.tmd.trackYear).append("-").append(this.tmd.trackAlbum).append(")"))), 1, this.song_title.getHeight() + 2, 0);
            }
            skip = 2;
        }
        if (this.pl.getState() == 200) {
            g.drawString("00:00/".concat(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() * skip + 2 * skip, 0);
            ++skip;
        }
        if (this.pl.getState() == 300) {
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getMediaTime())))).append("/").append(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() * skip + 2 * skip, 0);
            ++skip;
        }
        if (this.pl.getState() == 400) {
            g.drawString(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.millisecs2time(this.pl.getMediaTime())))).append("/").append(this.millisecs2time(this.pl.getDuration())))), 1, this.song_title.getHeight() * skip + 2 * skip, 0);
            ++skip;
        }
        if (this.show_info && !this.s_override_info) {
            g.drawString(this.info, 1, this.song_title.getHeight() * skip + 2 * skip, 0);
        }
        if (this.s_override_info) {
            g.drawString(this.override_info, 1, this.song_title.getHeight() * skip + 2 * skip, 0);
        }
    }

    protected void keyPressed(int keycode) {
        try {
            if (!this.keyboard_locked || this.override_klock) {
                long newt;
                long dur;
                this.override_klock = false;
                if (keycode == 53) {
                    boolean bl = this.nameFromMeta = !this.nameFromMeta;
                    if (!this.tmd.MetaDataCollected) {
                        this.nameFromMeta = false;
                        this.overrideInfo("\u0422\u0435\u0433\u0438 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
                    }
                }
                if (this.getGameAction(keycode) == 1 && keycode != 50) {
                    boolean handled = false;
                    if (this.pl.getState() == 300) {
                        this.pl.start();
                        handled = true;
                    }
                    if (this.pl.getState() == 400 && !handled) {
                        this.pl.stop();
                        handled = true;
                    }
                    if (this.pl.getState() == 200 && !handled) {
                        this.pl.prefetch();
                        this.pl.start();
                        handled = true;
                    }
                }
                if (this.getGameAction(keycode) == 6 && keycode != 56) {
                    if (this.pl.getState() == 300) {
                        this.pl.setMediaTime(0L);
                    }
                    if (this.pl.getState() == 400) {
                        this.pl.stop();
                        this.pl.setMediaTime(0L);
                    }
                }
                if (keycode == 52) {
                    long cur = this.pl.getMediaTime();
                    newt = cur - (dur = this.pl.getDuration()) / (long)(100 / this.seek_step);
                    if (newt < (long)0) {
                        newt = 0L;
                    }
                    this.pl.setMediaTime(newt);
                    this.overrideInfo("\u041f\u0435\u0440\u0435\u043c\u043e\u0442\u043a\u0430");
                }
                if (keycode == 54) {
                    long cur = this.pl.getMediaTime();
                    newt = cur + (dur = this.pl.getDuration()) / (long)(100 / this.seek_step);
                    if (newt >= dur) {
                        newt = 0L;
                    }
                    this.pl.setMediaTime(newt);
                    this.overrideInfo("\u041f\u0435\u0440\u0435\u043c\u043e\u0442\u043a\u0430");
                }
                if (this.getGameAction(keycode) == 2 && keycode != 52) {
                    if (!this.random_scroll) {
                        --this.index;
                    } else {
                        int rnd_znac = this.rnd.nextInt();
                        if (rnd_znac < 0) {
                            rnd_znac = -1 * rnd_znac;
                        }
                        this.index = rnd_znac % this.audlist.length;
                    }
                    if (this.index < 0) {
                        this.index = this.audlist.length - 1;
                    }
                    this.pl.deallocate();
                    try {
                        this.openFile(this.audlist[this.index]);
                        this.prepareFile();
                        this.launchPlayer();
                    }
                    catch (Exception e) {
                        this.HandleError(e, "keyPressed1");
                    }
                }
                if (this.getGameAction(keycode) == 5 && keycode != 54) {
                    if (!this.random_scroll) {
                        ++this.index;
                    } else {
                        int rnd_znac = this.rnd.nextInt();
                        if (rnd_znac < 0) {
                            rnd_znac = -1 * rnd_znac;
                        }
                        this.index = rnd_znac % this.audlist.length;
                    }
                    if (this.index > this.audlist.length - 1) {
                        this.index = 0;
                    }
                    this.pl.deallocate();
                    try {
                        this.openFile(this.audlist[this.index]);
                        this.prepareFile();
                        this.launchPlayer();
                    }
                    catch (Exception e) {
                        this.HandleError(e, "keyPressed2");
                    }
                }
                if (keycode == 42) {
                    if (this.vc != null) {
                        this.volume -= this.volume_step;
                        this.vc.setLevel(this.volume);
                        this.volume = this.vc.getLevel();
                        this.overrideInfo(String.valueOf(String.valueOf(new StringBuffer("\u0413\u0440\u043e\u043c\u043a\u043e\u0441\u0442\u044c: ").append(String.valueOf(this.volume)).append("%"))));
                    } else {
                        this.overrideInfo("\u041e\u0448\u0438\u0431\u043a\u0430");
                    }
                }
                if (keycode == 35) {
                    if (this.vc != null) {
                        this.volume += this.volume_step;
                        this.vc.setLevel(this.volume);
                        this.volume = this.vc.getLevel();
                        this.overrideInfo(String.valueOf(String.valueOf(new StringBuffer("\u0413\u0440\u043e\u043c\u043a\u043e\u0441\u0442\u044c: ").append(String.valueOf(this.volume)).append("%"))));
                    } else {
                        this.overrideInfo("\u041e\u0448\u0438\u0431\u043a\u0430");
                    }
                }
                if (keycode == 50) {
                    if (this.vc != null) {
                        boolean muted = this.vc.isMuted();
                        if (muted) {
                            this.vc.setMute(false);
                            this.overrideInfo("Unmuted");
                        } else {
                            this.vc.setMute(true);
                            this.overrideInfo("Muted");
                        }
                    } else {
                        this.overrideInfo("\u041e\u0448\u0438\u0431\u043a\u0430");
                    }
                }
                if (keycode == 55) {
                    boolean bl = this.auto_scroll = !this.auto_scroll;
                    if (this.auto_scroll) {
                        this.overrideInfo("\u0421\u043a\u0440\u043e\u043b\u043b: \u0410\u0432\u0442\u043e");
                    }
                    if (!this.auto_scroll) {
                        this.overrideInfo("\u0421\u043a\u0440\u043e\u043b\u043b: \u0412\u0440\u0443\u0447\u043d\u0443\u044e");
                    }
                }
                if (keycode == 57) {
                    boolean bl = this.random_scroll = !this.random_scroll;
                    if (this.random_scroll) {
                        this.overrideInfo("Shuffle: \u0412\u043a\u043b.");
                    }
                    if (!this.random_scroll) {
                        this.overrideInfo("Shuffle: \u0412\u044b\u043a\u043b.");
                    }
                }
                if (keycode == 56) {
                    boolean bl = this.backlight = !this.backlight;
                    if (this.backlight) {
                        this.overrideInfo("\u041f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0430: \u0412\u043a\u043b.");
                        this.disp.flashBacklight(Integer.MAX_VALUE);
                    }
                    if (!this.backlight) {
                        this.overrideInfo("\u041f\u043e\u0434\u0441\u0432\u0435\u0442\u043a\u0430: \u0412\u044b\u043a\u043b.");
                        this.disp.flashBacklight(0);
                    }
                }
            }
            if (keycode == 48) {
                boolean bl = this.keyboard_locked = !this.keyboard_locked;
                if (this.keyboard_locked) {
                    this.overrideInfo("\u0411\u043b\u043e\u043a \u043a\u043b\u0430\u0432\u0438\u0448: \u0412\u043a\u043b.");
                    this.backlight = false;
                    this.disp.flashBacklight(0);
                }
                if (!this.keyboard_locked) {
                    this.overrideInfo("\u0411\u043b\u043e\u043a \u043a\u043b\u0430\u0432\u0438\u0448: \u0412\u044b\u043a\u043b.");
                    this.backlight = true;
                    this.disp.flashBacklight(Integer.MAX_VALUE);
                }
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(String.valueOf(e.toString())).concat(" at AudioPlayerUI.keyPressed"));
        }
    }

    void showInfo(String what) {
        this.info = what;
        this.show_info = true;
        this.timeout = 0;
    }

    void overrideInfo(String what) {
        this.override_info = what;
        this.s_override_info = true;
        this.timeout = 0;
    }

    public String millisecs2time(long millisecs) {
        long ts = millisecs / (long)100000;
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.formatNumber(ts / 600L, 2, true)))).append(":").append(this.formatNumber(ts % (long)600 / (long)10, 2, true))));
    }

    private String formatNumber(long num, int len, boolean leadingZeros) {
        StringBuffer ret = new StringBuffer(String.valueOf(num));
        if (leadingZeros) {
            while (ret.length() < len) {
                ret.insert(0, '0');
            }
        } else {
            while (ret.length() < len) {
                ret.append('0');
            }
        }
        return ret.toString();
    }

    public void openFile(String fname) {
        this.filepath = fname;
        this.filename = fname.substring(fname.lastIndexOf(47) + 1);
        this.info = "\u041f\u043e\u0434\u0433\u043e\u0442\u0432\u043a\u0430";
    }

    public void prepareFile() throws Exception {
        try {
            SettingsHandler sh = new SettingsHandler(this.disp);
            sh.LoadSettings();
            this.pl = null;
            this.pl = Manager.createPlayer((String)"file:/".concat(String.valueOf(String.valueOf(this.filepath))));
            this.pl.addPlayerListener((PlayerListener)this);
            this.pl.realize();
            this.info = "Realized";
            this.repaint();
            this.pl.prefetch();
            this.vc = (VolumeControl)this.pl.getControl("VolumeControl");
            this.vc.setLevel(this.volume);
            this.info = "Collecting MetaData";
            this.repaint();
            this.tmd.ReInitMetaData();
            MetaDataControl mdc = (MetaDataControl)this.pl.getControl("MetaDataControl");
            if (mdc != null) {
                this.tmd.rawMetaDataKeys = mdc.getKeys();
                this.tmd.rawMetaDataValues = new String[this.tmd.rawMetaDataKeys.length];
                for (int i = 0; i < this.tmd.rawMetaDataKeys.length; ++i) {
                    this.tmd.rawMetaDataValues[i] = this.Ascii2UTF(mdc.getKeyValue(this.tmd.rawMetaDataKeys[i]));
                }
                this.tmd.trackAuthor = this.Ascii2UTF(mdc.getKeyValue("author"));
                this.tmd.trackTitle = this.Ascii2UTF(mdc.getKeyValue("title"));
                this.tmd.trackAlbum = this.Ascii2UTF(mdc.getKeyValue("album"));
                if (this.tmd.trackAlbum.compareTo("") == 0) {
                    this.tmd.trackAlbum = "N/A";
                }
                this.tmd.trackGenre = this.Ascii2UTF(mdc.getKeyValue("genre"));
                this.tmd.trackYear = mdc.getKeyValue("date");
                if (this.tmd.trackYear.compareTo("") == 0) {
                    this.tmd.trackYear = "N/A";
                }
                this.tmd.MetaDataCollected = true;
                this.nameFromMeta = true;
                String t = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tmd.trackTitle))).append(" (").append(this.tmd.trackYear).append("-").append(this.tmd.trackAlbum).append(") $$$ ").append(this.tmd.trackTitle).append(" (").append(this.tmd.trackYear).append("-").append(this.tmd.trackAlbum).append(")")));
                String t2 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tmd.trackTitle))).append(" (").append(this.tmd.trackYear).append("-").append(this.tmd.trackAlbum).append(") $$$ ")));
                this.st2 = new ScrollingText(t, this.song_title.stringWidth(t), this.song_title.stringWidth(t2));
                t = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tmd.trackAuthor))).append(" $$$ ").append(this.tmd.trackAuthor)));
                t2 = String.valueOf(String.valueOf(this.tmd.trackAuthor)).concat(" $$$ ");
                this.st1 = new ScrollingText(t, this.song_title.stringWidth(t), this.song_title.stringWidth(t2));
                t = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.filename))).append(" $$$ ").append(this.filename)));
                t2 = String.valueOf(String.valueOf(this.filename)).concat(" $$$ ");
                this.st3 = new ScrollingText(t, this.song_title.stringWidth(t), this.song_title.stringWidth(t2));
                t = null;
                t2 = null;
            } else {
                this.nameFromMeta = false;
                this.tmd.MetaDataCollected = false;
            }
            if (this.tmd.trackTitle.compareTo("") == 0 && this.tmd.trackAuthor.compareTo("") == 0) {
                this.nameFromMeta = false;
            }
        }
        catch (Exception e) {
            Exception e2 = new Exception(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(e.toString()))).append(" at AudioPlayerUI.prepareFile ").append(this.filepath))));
            throw e2;
        }
        this.aprc = null;
        this.aprc = new AudioPlayerRepaintControl(this);
        this.aprc.StartProgramFlow(1L, 100L);
    }

    public void launchPlayer() throws Exception {
        try {
            while (true) {
                if (this.pl.getState() != 100) break;
                this.pl.realize();
                Thread.sleep(50L);
            }
            this.pl.start();
            this.info = "\u0418\u0433\u0440\u0430\u0435\u0442";
        }
        catch (Exception e) {
            Exception e2 = new Exception(String.valueOf(String.valueOf(e.toString())).concat(" at AudioPlayerUI.launchPlayer"));
            throw e2;
        }
        this.repaint();
    }

    String Ascii2UTF(String ascii) {
        String res = "";
        for (int i = 0; i < ascii.length(); ++i) {
            char a = ascii.charAt(i);
            res = a < '\u00ff' && a > '\u0000' ? String.valueOf(String.valueOf(res)).concat(String.valueOf(String.valueOf(this.ascii2char[a]))) : String.valueOf(String.valueOf(res)).concat(String.valueOf(String.valueOf(a)));
        }
        return res;
    }

    public void commandAction(Command c, Displayable d) {
        if (!this.keyboard_locked || this.override_klock) {
            this.override_klock = false;
            if (c == this.exit) {
                this.disp.flashBacklight(Integer.MAX_VALUE);
                try {
                    if (this.pl.getState() == 400) {
                        this.pl.stop();
                    }
                    if (this.pl.getState() == 300) {
                        this.pl.deallocate();
                    }
                    this.pl.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.Sh.volume = (byte)this.volume;
                this.Sh.ap_shuffle = this.random_scroll;
                this.Sh.SaveSettings();
                this.Sh = null;
                this.freeMem();
                if (this.real_idxs != null) {
                    this.Callback.viewer_callback(false, this.real_idxs[this.index], this);
                } else {
                    this.Callback.callback(false, this);
                }
            }
            if (c == this.save) {
                this.saveList();
            }
            if (c == this.ok) {
                PlaylistManager pm = new PlaylistManager();
                pm.savePlaylist(this.tef.getString(), this.audlist);
                pm = null;
                this.disp.setCurrent((Displayable)this);
            }
            if (c == this.edit) {
                PlaylistEditor pe = new PlaylistEditor();
                pe.openList(this.audlist);
                pe.editList(this);
                pe.editor.setSelectedIndex(this.index, true);
            }
            if (c == this.viewMeta) {
                Form form = new Form("\u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f");
                if (this.tmd.MetaDataCollected) {
                    form.append(String.valueOf(String.valueOf(new StringBuffer("\u0410\u0432\u0442\u043e\u0440: ").append(this.tmd.trackAuthor).append("\n"))));
                    form.append(String.valueOf(String.valueOf(new StringBuffer("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435: ").append(this.tmd.trackTitle).append("\n"))));
                    form.append(String.valueOf(String.valueOf(new StringBuffer("\u0410\u043b\u044c\u0431\u043e\u043c: ").append(this.tmd.trackAlbum).append("\n"))));
                    form.append(String.valueOf(String.valueOf(new StringBuffer("\u0416\u0430\u043d\u0440: ").append(this.tmd.trackGenre).append("\n"))));
                    form.append("\n-----\n\n");
                    form.append("RAW MetaData:\n\n");
                    for (int i = 0; i < this.tmd.rawMetaDataKeys.length; ++i) {
                        form.append(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.tmd.rawMetaDataKeys[i]))).append(": ").append(this.tmd.rawMetaDataValues[i]).append("\n"))));
                    }
                } else {
                    form.append("MetaData \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
                }
                form.addCommand(this.exit2);
                form.setCommandListener((CommandListener)this);
                this.disp.setCurrent((Displayable)form);
            }
            if (c == this.exit2) {
                this.disp.setCurrent((Displayable)this);
            }
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        if (event == "endOfMedia") {
            if (!this.auto_scroll) {
                this.showInfo("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
                this.repaint();
            } else {
                this.override_klock = true;
                this.keyPressed(this.getKeyCode(2));
            }
        }
        if (event == "error") {
            this.showInfo("\u041e\u0448\u0438\u0431\u043a\u0430");
            this.repaint();
        }
        if (event == "closed") {
            this.showInfo("\u0417\u0430\u043a\u0440\u044b\u0442");
            this.repaint();
        }
        if (event == "started") {
            this.showInfo("\u0418\u0433\u0440\u0430\u0435\u0442");
            this.repaint();
        }
        if (event == "stopped") {
            this.showInfo("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
            this.repaint();
        }
    }

    void saveList() {
        Form form = new Form("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c");
        this.tef = new TextField("\u0418\u043c\u044f \u043f\u043b\u0435\u0439\u043b\u0438\u0441\u0442\u0430", "", 255, 0);
        form.append((Item)this.tef);
        form.addCommand(this.ok);
        form.addCommand(this.exit2);
        form.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)form);
    }

    public static String[] splitURL(String url) throws Exception {
        int slash;
        StringBuffer u = new StringBuffer(url);
        String[] result = new String[6];
        for (int i = 0; i <= 5; ++i) {
            result[i] = "";
        }
        boolean protFound = false;
        int index = url.indexOf(":");
        if (index > 0) {
            result[0] = url.substring(0, index);
            u.delete(0, index + 1);
            protFound = true;
        } else if (index == 0) {
            throw new Exception("url format error - protocol");
        }
        if (u.length() > 2 && u.charAt(0) == '/' && u.charAt(1) == '/') {
            u.delete(0, 2);
            slash = u.toString().indexOf(47);
            if (slash < 0) {
                slash = u.length();
            }
            int colon = u.toString().indexOf(58);
            int endIndex = slash;
            if (colon >= 0) {
                if (colon > slash) {
                    throw new Exception("url format error - port");
                }
                endIndex = colon;
                result[2] = u.toString().substring(colon + 1, slash);
            }
            result[1] = u.toString().substring(0, endIndex);
            u.delete(0, slash);
        }
        if (u.length() > 0) {
            url = u.toString();
            slash = url.lastIndexOf(47);
            if (slash > 0) {
                result[3] = url.substring(0, slash);
            }
            if (slash < url.length() - 1) {
                String fn = url.substring(slash + 1, url.length());
                int anchorIndex = fn.indexOf("#");
                if (anchorIndex >= 0) {
                    result[4] = fn.substring(0, anchorIndex);
                    result[5] = fn.substring(anchorIndex + 1);
                } else {
                    result[4] = fn;
                }
            }
        }
        return result;
    }

    public static String guessContentType(String url) throws Exception {
        String[] sURL = AudioPlayerUI.splitURL(url);
        String ext = "";
        String ct = "";
        int lastDot = sURL[4].lastIndexOf(46);
        if (lastDot >= 0) {
            ext = sURL[4].substring(lastDot + 1).toLowerCase();
        }
        if (ext.equals("mid") || ext.equals("kar") || ext.equals("midi") || ext.equals("bas")) {
            ct = "audio/midi";
        } else if (ext.equals("wav")) {
            ct = "audio/x-wav";
        } else if (ext.equals("jts")) {
            ct = "audio/x-tone-seq";
        } else if (ext.equals("txt")) {
            ct = "audio/x-txt";
        } else if (ext.equals("amr")) {
            ct = "audio/amr";
        } else if (ext.equals("awb")) {
            ct = "audio/amr-wb";
        } else if (ext.equals("gif")) {
            ct = "image/gif";
        } else if (ext.equals("mp3")) {
            ct = "audio/mpeg";
        }
        return ct;
    }
}

