/*
 * Decompiled with CFR 0.152.
 */
package sheet;

import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import sheet.Backable;
import sheet.Cell$1;
import sheet.Cell$Calculate;
import sheet.CellCalc;
import sheet.CellContainer;
import sheet.Operand;

final class Cell {
    static final String[] colors = new String[]{"White", "Light Gray", "Black"};
    static final int BG_WHITE = 0;
    static final int BG_LGRAY = 1;
    static final int BG_BLACK = 2;
    static final String[] aligns = new String[]{"Default", "Right", "Center", "Left"};
    static final int AL_DEFAULT = 0;
    static final int AL_RIGHT = 1;
    static final int AL_CENTER = 2;
    static final int AL_LEFT = 3;
    private static CellContainer parent;
    private static Cell$Calculate calc;
    private byte column;
    private byte row;
    private short colorIdx = 0;
    private short alignIdx = 0;
    private String formula;
    private Operand result;
    private boolean calculated;
    private String errMsg;
    private Image image;

    public Cell(CellContainer cellContainer, byte by, byte by2) {
        parent = cellContainer;
        this.column = by;
        this.row = by2;
        this.calculated = true;
        this.render();
    }

    public boolean isData() {
        return this.colorIdx != 0 || this.formula != null;
    }

    public byte getRow() {
        return this.row;
    }

    public byte getColumn() {
        return this.column;
    }

    public void setColor(short s) {
        if (this.colorIdx != s) {
            this.colorIdx = s;
            parent.notifyChanged();
            this.render();
        }
    }

    public void setAlign(short s) {
        if (this.alignIdx != s) {
            this.alignIdx = s;
            parent.notifyChanged();
            this.render();
        }
    }

    public void render() {
        if (this.isData()) {
            int n;
            short s = parent.getColumnWidth(this.column);
            int n2 = parent.getRowHeight(this.row);
            Font font = Font.getFont((int)64, (int)0, (int)8);
            int n3 = n2 - font.getHeight();
            int n4 = 1;
            String string = this.errMsg == null ? (this.result == null ? "" : Operand.getText(this.result)) : this.errMsg;
            int n5 = font.stringWidth(string);
            if (n5 > 0) {
                int n6 = s - 3;
                n = this.alignIdx;
                if (n5 > n6) {
                    n5 = n6;
                }
                if (n == 0) {
                    n = this.result != null && Operand.isNumber(this.result) ? 1 : 3;
                }
                switch (n) {
                    case 1: {
                        n4 = n6 - n5;
                        break;
                    }
                    case 2: {
                        n4 = (n6 - n5) / 2;
                        break;
                    }
                    case 3: {
                        n4 = 1;
                    }
                }
            }
            this.image = Image.createImage((int)s, (int)n2);
            Graphics graphics = this.image.getGraphics();
            graphics.setColor(0);
            graphics.setFont(font);
            switch (this.colorIdx) {
                case 1: {
                    n = 1 - s % 2;
                    int n7 = 1;
                    while (n7 < n2) {
                        graphics.drawLine(0, n7, n2 - 1 - n7, n2 - 1);
                        graphics.drawLine(s - 1, n7 - n, s - 1 - n7 + n, 0);
                        n7 += 2;
                    }
                    int n8 = 1;
                    while (n8 <= s - n2) {
                        graphics.drawLine(n8, 0, n8 + n2 - 1, n2 - 1);
                        n8 += 2;
                    }
                    graphics.setColor(0xFFFFFF);
                    graphics.drawString(string, n4 + 1, n3 + 1, 20);
                    graphics.setColor(0);
                    break;
                }
                case 2: {
                    graphics.fillRect(0, 0, (int)s, n2);
                    graphics.setColor(0xFFFFFF);
                }
            }
            graphics.drawString(string, n4, n3, 20);
        } else {
            this.image = null;
        }
    }

    public int paint(Graphics graphics, int n, int n2) {
        if (this.image != null) {
            graphics.drawImage(this.image, n, n2, 20);
        }
        return this.colorIdx == 2 ? 0xFFFFFF : 0;
    }

    public String getName() {
        char c = (char)(65 + this.column);
        return String.valueOf(c) + String.valueOf(this.row + 1);
    }

    public String getDetails() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.formula != null) {
            stringBuffer.append("Formula: ");
            stringBuffer.append(this.formula);
            stringBuffer.append("\n");
            if (this.errMsg != null) {
                stringBuffer.append("Error: ");
                stringBuffer.append(this.errMsg);
            } else if (this.result != null) {
                stringBuffer.append("Result: ");
                stringBuffer.append(Operand.getText(this.result));
            } else {
                stringBuffer.append("No result");
            }
        }
        return stringBuffer.toString();
    }

    public void notCalculated() {
        this.result = null;
        this.calculated = false;
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public void paste(Cell cell) {
        if (cell != null) {
            this.formula = cell.formula;
            this.colorIdx = cell.colorIdx;
            this.alignIdx = cell.alignIdx;
            parent.notifyChanged();
            parent.calculate();
        }
    }

    public boolean calculate() {
        this.calculated = true;
        this.errMsg = null;
        if (this.formula != null) {
            CellCalc cellCalc = new CellCalc(calc);
            char c = this.formula.charAt(0);
            if (c == '=' && this.formula.length() > 1) {
                try {
                    this.result = cellCalc.calculate(this.formula, (short)1, (short)this.formula.length());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.calculated = false;
                    this.result = null;
                    this.errMsg = illegalArgumentException.getMessage();
                }
            } else {
                this.result = c == '\'' ? new Operand(this.formula.substring(1), false) : new Operand(this.formula, true);
            }
        }
        this.render();
        return this.calculated;
    }

    public void edit(String string, Backable backable, Display display) {
        int n = 0;
        if (string == null) {
            string = this.formula;
        } else if (string.length() > 0 && Character.isDigit(string.charAt(0))) {
            n = 2;
        }
        String string2 = this.getName();
        Command command = new Command("Ok", 4, 0);
        Command command2 = new Command("Cancel", 3, 0);
        Command command3 = new Command("Help", 5, 0);
        TextBox textBox = new TextBox(string2, string, 50, n);
        textBox.setCommandListener((CommandListener)new Cell$1(this, command3, display, command, backable));
        textBox.addCommand(command);
        textBox.addCommand(command2);
        textBox.addCommand(command3);
        display.setCurrent((Displayable)textBox);
    }

    public boolean appendChar(char c, boolean bl) {
        int n;
        this.formula = c == '\b' && this.formula != null ? ((n = this.formula.length()) > 1 ? this.formula.substring(0, n - 1) : null) : (bl || this.formula == null ? String.valueOf(c) : this.formula + c);
        parent.notifyChanged();
        parent.calculate();
        return this.formula != null && this.formula.length() != 0;
    }

    public byte[] serialize(int n) {
        byte[] byArray;
        if (this.isData() && n == 1) {
            byte[] byArray2 = this.formula == null ? new byte[]{} : this.formula.getBytes();
            byArray = new byte[byArray2.length + 4];
            byArray[0] = this.column;
            byArray[1] = this.row;
            byArray[2] = (byte)this.colorIdx;
            byArray[3] = (byte)this.alignIdx;
            System.arraycopy(byArray2, 0, byArray, 4, byArray2.length);
        } else {
            byArray = null;
        }
        return byArray;
    }

    public static Cell deserialize(byte[] byArray, CellContainer cellContainer, int n) {
        Cell cell;
        if (n == 1 && byArray != null) {
            cell = new Cell(cellContainer, byArray[0], byArray[1]);
            cell.colorIdx = byArray[2];
            cell.alignIdx = byArray[3];
            cell.formula = new String(byArray, 4, byArray.length - 4);
            if (cell.formula.length() == 0) {
                cell.formula = null;
            }
            cell.calculated = false;
        } else {
            cell = null;
        }
        return cell;
    }

    static CellContainer access$000() {
        return parent;
    }

    static String access$100(Cell cell) {
        return cell.errMsg;
    }

    static boolean access$200(Cell cell) {
        return cell.calculated;
    }

    static Operand access$300(Cell cell) {
        return cell.result;
    }

    static Cell$Calculate access$500() {
        return calc;
    }

    static String access$600(Cell cell) {
        return cell.formula;
    }

    static String access$602(Cell cell, String string) {
        cell.formula = string;
        return cell.formula;
    }

    static String access$102(Cell cell, String string) {
        cell.errMsg = string;
        return cell.errMsg;
    }

    static {
        calc = new Cell$Calculate(null);
    }
}

