/*
 * Decompiled with CFR 0.152.
 */
package memo;

import com.jenfa.UTFTextFile;
import com.motorola.io.FileConnection;
import java.io.DataOutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.TextField;
import memo.SettingsHandler;
import memo.callback;

public class FileEditor
implements CommandListener {
    String filename = "";
    String text = "";
    boolean ac = false;
    Display disp;
    boolean upd = false;
    String savepath = "";
    TextField edit;
    TextField fnam;
    Command cancel = new Command("\u041e\u0442\u043c\u0435\u043d\u0430", 2, 1);
    Command save = new Command("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", 4, 2);
    callback cb;

    public FileEditor(Display d, callback c) {
        this.disp = d;
        this.cb = c;
        this.filename = String.valueOf(String.valueOf(new StringBuffer("/").append(this.time2Date(System.currentTimeMillis())).append(".txt")));
        SettingsHandler sh = new SettingsHandler(this.disp);
        sh.LoadSettings();
        this.savepath = sh.directory;
        this.upd = true;
    }

    public FileEditor(Display d, callback c, String fname) {
        this.disp = d;
        this.cb = c;
        this.filename = fname;
        this.text = this.readFile();
        this.savepath = fname.substring(0, fname.lastIndexOf(47) + 1);
    }

    private String time2Date(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(time));
        StringBuffer sb = new StringBuffer();
        sb.append(cal.get(5));
        sb.append('-');
        sb.append(2);
        sb.append('-');
        sb.append(cal.get(1));
        sb.append('_');
        sb.append(cal.get(11));
        sb.append("_");
        sb.append(cal.get(12));
        sb.append("_");
        sb.append(cal.get(13));
        return sb.toString();
    }

    void editFile() {
        Form form = new Form("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435");
        this.edit = new TextField("\u0422\u0435\u043a\u0441\u0442", this.text, 4096, 0);
        this.fnam = new TextField("\u0418\u043c\u044f", this.getLastURLPart(this.filename, false), 256, 0);
        form.append((Item)this.fnam);
        form.append((Item)this.edit);
        form.addCommand(this.cancel);
        form.addCommand(this.save);
        form.setCommandListener((CommandListener)this);
        this.disp.setCurrent((Displayable)form);
    }

    void HandleError(Exception what, String where) {
        this.ac = false;
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MEMO EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    void SaveFile() {
        try {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("file://").append(this.savepath).append(this.filename))));
            FileConnection fc = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file://").append(this.savepath).append(this.filename))));
            if (fc.exists()) {
                fc.delete();
            }
            if (!fc.create()) {
                throw new Exception("cannot create file");
            }
            DataOutputStream dos = fc.openDataOutputStream();
            dos.writeUTF(this.text);
            dos.flush();
            dos.close();
            fc.close();
            dos = null;
            fc = null;
        }
        catch (Exception e) {
            this.HandleError(e, "SaveFile");
        }
    }

    String readFile() {
        String ll = "";
        try {
            UTFTextFile utf = new UTFTextFile();
            utf.openFile(String.valueOf(String.valueOf(new StringBuffer("file://").append(this.savepath).append(this.filename))));
            while (!utf.eof()) {
                ll = String.valueOf(String.valueOf(ll)).concat(String.valueOf(String.valueOf(utf.readLine())));
            }
            utf.close();
        }
        catch (Exception e) {
            this.HandleError(e, "readFile");
        }
        return "".concat(String.valueOf(String.valueOf(ll)));
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.cancel) {
            this.cb.callback(false, this, false);
        }
        if (c == this.save) {
            this.ac = true;
            this.text = this.edit.getString();
            this.filename = this.fnam.getString();
            this.SaveFile();
            if (this.ac) {
                this.cb.callback(false, this, this.upd);
            }
        }
    }
}

