/*
 * Decompiled with CFR 0.152.
 */
package memo;

import com.motorola.io.FileConnection;
import java.io.DataInputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;
import memo.About;
import memo.main;

public class FileBrowser
implements CommandListener {
    Image file = null;
    Image folder = null;
    String curdir = "";
    String[] roots;
    String cur_root;
    FileConnection fc;
    List mainwinlist;
    int i;
    Display disp;
    boolean action_success = true;
    main pm_host;
    Command open_file = new Command("\u041e\u0442\u043a\u0440\u044b\u0442\u044c", 8, 1);
    Command create_file = new Command("\u0421\u043e\u0437\u0434\u0430\u0442\u044c", 8, 1);
    Command edit_file = new Command("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c", 8, 1);
    Command cancel = new Command("", 3, 1);
    Command about = new Command("\u041e \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u0435", 8, 1);
    Command settings = new Command("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438", 8, 1);
    Command delete = new Command("\u0423\u0434\u0430\u043b\u0438\u0442\u044c", 8, 1);

    public FileBrowser(main host, Display d) {
        try {
            this.file = Image.createImage((String)"/icons/txt.png");
            this.folder = Image.createImage((String)"/icons/folder.png");
            this.disp = d;
            this.pm_host = host;
        }
        catch (Exception e) {
            this.HandleError(e, "FileBrowser constructor");
        }
    }

    public void HandleError(Exception what, String where) {
        this.action_success = false;
        Alert ErrorOut = new Alert("Exception occured", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(what.toString()))).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))), null, AlertType.ERROR);
        ErrorOut.setTimeout(-2);
        System.err.println(String.valueOf(String.valueOf(new StringBuffer("[MEMO EXCEPTION]: ").append(what.toString()).append(" : ").append(what.getMessage()).append(" : ocurred at ").append(where))));
        this.disp.setCurrent((Displayable)ErrorOut);
    }

    public void browseDir(String dir) {
        this.cur_root = dir;
        this.curdir = dir;
        this.ShowFileManagerMainWin();
    }

    public boolean deleteFile(String filename) {
        boolean res = false;
        try {
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
            res = this.fc.delete();
            this.fc.close();
        }
        catch (Exception e) {
            this.HandleError(e, "deleteFile");
        }
        return res;
    }

    String[] ListFiles() {
        int point = 0;
        String[] res = new String[1000];
        res[0] = "";
        try {
            this.fc = null;
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(this.curdir))));
            String[] files = this.fc.list();
            this.fc.close();
            this.fc = null;
            this.i = 0;
            while (this.i < files.length) {
                this.fc = null;
                this.fc = (FileConnection)Connector.open((String)String.valueOf(String.valueOf(new StringBuffer("file://").append(this.cur_root).append(files[this.i]))));
                if (!this.fc.isDirectory()) {
                    res[++point] = files[this.i];
                }
                this.fc.close();
                ++this.i;
            }
        }
        catch (Exception e) {
            this.HandleError(e, "ListFiles");
        }
        String[] res2 = new String[point + 1];
        this.i = 0;
        while (this.i <= point) {
            res2[this.i] = res[this.i];
            ++this.i;
        }
        return res2;
    }

    void ShowFileManagerMainWin() {
        this.mainwinlist = new List(this.curdir, 3);
        String dirname = "";
        try {
            String[] files = this.ListFiles();
            if (files.length > 1) {
                this.i = 1;
                while (this.i < files.length) {
                    String filename = this.getLastURLPart(files[this.i], false);
                    String ext = "";
                    int lastDot = filename.lastIndexOf(46);
                    if (lastDot >= 0) {
                        ext = filename.substring(lastDot + 1).toLowerCase();
                    }
                    if (ext.equals("txt") || ext.equals("text")) {
                        this.mainwinlist.append(filename, this.file);
                    }
                    ++this.i;
                }
            }
            this.mainwinlist.addCommand(this.open_file);
            this.mainwinlist.addCommand(this.create_file);
            this.mainwinlist.addCommand(this.edit_file);
            this.mainwinlist.addCommand(this.settings);
            this.mainwinlist.addCommand(this.delete);
            this.mainwinlist.addCommand(this.about);
            this.mainwinlist.addCommand(this.cancel);
            this.mainwinlist.setCommandListener((CommandListener)this);
            this.disp.setCurrent((Displayable)this.mainwinlist);
        }
        catch (Exception e) {
            this.HandleError(e, "ShowFileManagerMainWin : Listing");
        }
    }

    public String getLastURLPart(String URL2, boolean hasFinalSlash) {
        boolean idx1 = false;
        int idxf = -1;
        int pidxf = -1;
        idxf = URL2.lastIndexOf(47);
        if (hasFinalSlash) {
            if (idxf != -1) {
                pidxf = URL2.lastIndexOf(47, idxf - 1);
            }
            URL2 = URL2.substring(pidxf + 1, idxf);
        } else {
            URL2 = URL2.substring(idxf + 1);
        }
        return URL2;
    }

    void ChDir(String dest) {
        if (dest == "..") {
            int idx1 = 0;
            int idxf = -1;
            int pidxf = -1;
            int ch = 47;
            while (idx1 != -1) {
                pidxf = idxf;
                idxf = idx1;
                idx1 = this.curdir.indexOf("/", idxf + 1);
            }
            this.curdir = this.curdir.substring(0, pidxf + 1);
        } else {
            this.curdir = dest;
        }
    }

    void freeMem() {
        Object file = null;
        Object folder = null;
        String curdir = "";
        String[] roots = new String[]{};
        String cur_root = "";
        Object fc = null;
        Object mainwinlist = null;
        Object disp = null;
        this.pm_host = null;
        this.open_file = null;
        this.cancel = null;
    }

    byte[] getFileContents(String filename) {
        byte[] a = new byte[1];
        try {
            this.fc = (FileConnection)Connector.open((String)"file://".concat(String.valueOf(String.valueOf(filename))));
            int size = (int)this.fc.fileSize();
            a = new byte[size];
            DataInputStream dis = this.fc.openDataInputStream();
            dis.readFully(a, 0, size);
            dis.close();
            this.fc.close();
        }
        catch (Exception e) {
            this.HandleError(e, "getFileContents");
        }
        return a;
    }

    public void commandAction(Command c, Displayable d) {
        int idx;
        if (c == List.SELECT_COMMAND && d == this.mainwinlist) {
            c = this.open_file;
        }
        if (c == this.open_file) {
            idx = this.mainwinlist.getSelectedIndex();
            this.pm_host.FileSelectedByUser(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(this.mainwinlist.getString(idx)))));
        }
        if (c == this.edit_file) {
            idx = this.mainwinlist.getSelectedIndex();
            this.pm_host.FileEditRequest(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(this.mainwinlist.getString(idx)))));
        }
        if (c == this.create_file) {
            this.pm_host.FileCreateRequest();
        }
        if (c == this.settings) {
            this.pm_host.SettingsRequest();
        }
        if (c == this.delete) {
            idx = this.mainwinlist.getSelectedIndex();
            this.action_success = true;
            this.deleteFile(String.valueOf(String.valueOf(this.curdir)).concat(String.valueOf(String.valueOf(this.mainwinlist.getString(idx)))));
            if (this.action_success) {
                this.ShowFileManagerMainWin();
            }
        }
        if (c == this.about) {
            About about = new About(this.disp, (Displayable)this.mainwinlist);
        }
    }
}

