/*
 * Decompiled with CFR 0.152.
 */
package net.jscience.math;

public abstract class MathFP {
    public static final int _digits = 8;
    private static final int _fbits = 24;
    private static final long _one = 0x1000000L;
    private static final long _fmask = 0xFFFFFFL;
    private static final long _dmul = 100000000L;
    private static final long _flt = 0L;
    private static final long _pi = 52707178L;
    private static final long[] e = new long[]{0x1000000L, 45605201L, 123967790L, 336979391L, 916004956L};
    public static final long PI = 52707178L;
    public static final long E = e[1];
    public static final long MAX_VALUE = Long.MAX_VALUE;
    public static final long MIN_VALUE = -9223372036854775807L;

    public static long toLong(long l) {
        if (l < 0L) {
            return -(MathFP.round(-l, 0) >> 24);
        }
        return MathFP.round(l, 0) >> 24;
    }

    public static long toFP(long l) {
        return l << 24;
    }

    public static long convert(long l, int n) {
        long l2 = l < 0L ? -1L : 1L;
        if ((long)((long)n < 0L ? -n : n) < 25L) {
            l = 24 < n ? l + l2 * (1L << (n - 24 >> 1)) >> n - 24 : (l <<= 24 - n);
        }
        return l;
    }

    public static long toFP(String string) {
        int n = 0;
        if (string.charAt(0) == '-') {
            n = 1;
        }
        String string2 = "-1";
        int n2 = string.indexOf(46);
        if (n2 >= 0) {
            string2 = string.substring(n2 + 1, string.length());
            while (string2.length() < 8) {
                string2 = string2 + "0";
            }
            if (string2.length() > 8) {
                string2 = string2.substring(0, 8);
            }
        } else {
            n2 = string.length();
        }
        long l = 0L;
        if (n != n2) {
            l = Long.parseLong(string.substring(n, n2));
        }
        long l2 = Long.parseLong(string2) + 1L;
        long l3 = (l << 24) + (l2 << 24) / 100000000L;
        if (n == 1) {
            l3 = -l3;
        }
        return l3;
    }

    public static String toString(long l) {
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            l = -l;
        }
        long l2 = l >> 24;
        long l3 = 100000000L * (l & 0xFFFFFFL) >> 24;
        String string = Long.toString(l3);
        while (string.length() < 8) {
            string = "0" + string;
        }
        return (bl ? "-" : "") + Long.toString(l2) + "." + string;
    }

    public static String toString(long l, int n) {
        if (n > 8) {
            n = 6;
        }
        String string = MathFP.toString(MathFP.round(l, n));
        return string.substring(0, string.length() - 8 + n);
    }

    public static long round(long l, int n) {
        long l2 = 10L;
        for (int i = 0; i < n; ++i) {
            l2 *= 10L;
        }
        l2 = MathFP.div(MathFP.toFP(5L), MathFP.toFP(l2));
        if (l < 0L) {
            l2 = -l2;
        }
        return l + l2;
    }

    public static long mul(long l, long l2) {
        boolean bl = false;
        int n = 24;
        long l3 = 0xFFFFFFL;
        if ((l & l3) == 0L) {
            return (l >> n) * l2;
        }
        if ((l2 & l3) == 0L) {
            return l * (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while ((l > l2 ? l : l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            l3 >>= 1;
            --n;
        }
        long l4 = (l >> n) * (l2 >> n) << n;
        long l5 = (l & l3) * (l2 & l3) >> n;
        if ((l4 = l4 + (l5 += (l & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) * (l2 & l3) >> n) + ((l & l3) * (l2 & (l3 ^ 0xFFFFFFFFFFFFFFFFL)) >> n) << 24 - n) < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return bl ? -l4 : l4;
    }

    public static long div(long l, long l2) {
        boolean bl = false;
        int n = 24;
        if (l2 == 0x1000000L) {
            return l;
        }
        if ((l2 & 0xFFFFFFL) == 0L) {
            return l / (l2 >> n);
        }
        if (l < 0L && l2 > 0L || l > 0L && l2 < 0L) {
            bl = true;
        }
        if (l < 0L) {
            l = -l;
        }
        if (l2 < 0L) {
            l2 = -l2;
        }
        while ((l > l2 ? l : l2) >= 1L << 63 - n) {
            l >>= 1;
            l2 >>= 1;
            --n;
        }
        long l3 = (l << n) / l2 << 24 - n;
        return bl ? -l3 : l3;
    }

    public static long sqrt(long l, int n) {
        if (l < 0L) {
            throw new ArithmeticException("Wrong argument in SQRT()");
        }
        if (l == 0L) {
            return 0L;
        }
        long l2 = l + 0x1000000L >> 1;
        for (int i = 0; i < n; ++i) {
            l2 = l2 + MathFP.div(l, l2) >> 1;
        }
        if (l2 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return l2;
    }

    public static long sqrt(long l) {
        return MathFP.sqrt(l, 24);
    }

    public static long sin(long l) {
        long l2 = MathFP.mul(l, MathFP.div(MathFP.toFP(180L), 52707178L));
        if ((l2 %= MathFP.toFP(360L)) < 0L) {
            l2 = MathFP.toFP(360L) + l2;
        }
        long l3 = l2;
        if (l2 >= MathFP.toFP(90L) && l2 < MathFP.toFP(270L)) {
            l3 = MathFP.toFP(180L) - l2;
        } else if (l2 >= MathFP.toFP(270L) && l2 < MathFP.toFP(360L)) {
            l3 = -(MathFP.toFP(360L) - l2);
        }
        long l4 = l3 / 90L;
        long l5 = MathFP.mul(l4, l4);
        long l6 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(-73190L, l5) + 1333581L, l5) - 10836755L, l5) + 26353564L, l4);
        return l6;
    }

    public static long asin(long l) {
        if ((l < 0L ? -l : l) > 0x1000000L) {
            throw new ArithmeticException("Wrong ASIN()/ACOS() arguments");
        }
        boolean bl = l < 0L;
        l = l < 0L ? -l : l;
        long l2 = MathFP.mul(MathFP.mul(MathFP.mul(MathFP.mul(145103L, l) - 599880L, l) + 1420468L, l) - 3592413L, l) + 26353447L;
        long l3 = 26353589L - MathFP.mul(MathFP.sqrt(0x1000000L - l), l2);
        return bl ? -l3 : l3;
    }

    public static long cos(long l) {
        return MathFP.sin(26353589L - l);
    }

    public static long acos(long l) {
        return 26353589L - MathFP.asin(l);
    }

    public static long tan(long l) {
        return MathFP.div(MathFP.sin(l), MathFP.cos(l));
    }

    public static long cot(long l) {
        return MathFP.div(MathFP.cos(l), MathFP.sin(l));
    }

    public static long atan(long l) {
        return MathFP.asin(MathFP.div(l, MathFP.sqrt(0x1000000L + MathFP.mul(l, l))));
    }

    public static long exp(long l) {
        if (l == 0L) {
            return 0x1000000L;
        }
        boolean bl = l < 0L;
        l = l < 0L ? -l : l;
        int n = (int)(l >> 24);
        long l2 = 0x1000000L;
        for (int i = 0; i < n / 4; ++i) {
            l2 = MathFP.mul(l2, e[4] >> 0);
        }
        if (n % 4 > 0) {
            l2 = MathFP.mul(l2, e[n % 4] >> 0);
        }
        if ((l &= 0xFFFFFFL) > 0L) {
            long l3 = 0x1000000L;
            long l4 = 0L;
            long l5 = 1L;
            for (int i = 0; i < 16; ++i) {
                l4 += l3 / l5;
                if ((l5 *= (long)(i + 1)) > (l3 = MathFP.mul(l3, l)) || l3 <= 0L || l5 <= 0L) break;
            }
            l2 = MathFP.mul(l2, l4);
        }
        if (bl) {
            l2 = MathFP.div(0x1000000L, l2);
        }
        return l2;
    }

    public static long log(long l) {
        if (l <= 0L) {
            throw new ArithmeticException("Negative argument in LOG()");
        }
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        while (l >= 0x2000000L) {
            l >>= 1;
            ++n;
        }
        long l4 = (long)n * 11629080L;
        long l5 = 0L;
        if (l < 0x1000000L) {
            return -MathFP.log(MathFP.div(0x1000000L, l));
        }
        l -= 0x1000000L;
        for (int i = 1; i < 20 && (l3 = l2 == 0L ? l : MathFP.mul(l2, l)) != 0L; ++i) {
            l5 += (i % 2 == 0 ? -1L : 1L) * l3 / (long)i;
            l2 = l3;
        }
        return l4 + l5;
    }

    public static long pow(long l, long l2) {
        if (l < 0L) {
            l = -l;
        }
        boolean bl = l2 < 0L;
        long l3 = 0x1000000L;
        l2 = l2 < 0L ? -l2 : l2;
        int n = (int)(l2 >> 24);
        while (n-- > 0) {
            l3 = MathFP.mul(l3, l);
        }
        if (l3 < 0L) {
            throw new ArithmeticException("Overflow");
        }
        l3 = l != 0L ? MathFP.mul(l3, MathFP.exp(MathFP.mul(MathFP.log(l), l2 & 0xFFFFFFL))) : 0L;
        if (bl) {
            return MathFP.div(0x1000000L, l3);
        }
        return l3;
    }

    public static long atan2(long l, long l2) {
        long l3 = 0L;
        if (l2 > 0L) {
            l3 = MathFP.atan(MathFP.div(l, l2));
        } else if (l2 < 0L) {
            long l4 = MathFP.div(l, l2);
            l4 = l4 < 0L ? -l4 : l4;
            l3 = (l2 < 0L ? -52707178L : 52707178L) - MathFP.atan(l4);
        } else {
            if (l2 == 0L && l == 0L) {
                throw new ArithmeticException("Zero operands in ATAN2()");
            }
            l3 = (l < 0L ? -52707178L : 52707178L) / 2L;
        }
        return l3;
    }
}

