/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FloatAtom;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.LongAtom;
import com.wapindustrial.calc.ShortAtom;

abstract class StringAtomBase
extends LispObject {
    StringAtomBase() {
    }

    public abstract String getValue();

    public int typeNumber() {
        return 10;
    }

    public void toBuffer(StringBuffer stringBuffer) {
        stringBuffer.append('\"');
        stringBuffer.append(this.getValue());
        stringBuffer.append('\"');
    }

    public void toValueBuffer(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.getValue());
    }

    public LispObject convertToType(int n) throws EvaluateException {
        LispObject lispObject = this;
        switch (n) {
            case 7: {
                lispObject = ShortAtom.createShortAtom(Short.parseShort(this.getValue()));
                break;
            }
            case 8: {
                lispObject = new LongAtom(Long.parseLong(this.getValue()));
                break;
            }
            case 9: {
                lispObject = new FloatAtom(this.getValue());
                break;
            }
            case 10: {
                break;
            }
            default: {
                return super.convertToType(n);
            }
        }
        return lispObject;
    }
}

