/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.Bfunc;
import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.Cell;
import com.wapindustrial.calc.CircularReferenceException;
import com.wapindustrial.calc.Dependency;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FormulaError;
import com.wapindustrial.calc.FormulaParseException;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.FunctorListN;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.Operator;
import com.wapindustrial.calc.ParseException;
import com.wapindustrial.calc.QuotedList;
import com.wapindustrial.calc.Reference;
import com.wapindustrial.calc.RowColumn;
import com.wapindustrial.calc.ShortAtom;
import com.wapindustrial.calc.StringAtom;
import com.wapindustrial.calc.StringAtomBase;
import com.wapindustrial.calc.WaveCell;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public final class Sheet
extends LispObject {
    static final int AXIS_X = 0;
    static final int AXIS_Y = 1;
    public boolean isChanged = false;
    Hashtable cells;
    Hashtable[] rows_columns;
    Hashtable changedCells;
    Vector refTable;
    static final int fontDivider = 64;
    int[] defaultWidthHeight = new int[]{384, 64};
    public String name = "untitled";
    Hashtable waveCells;
    Hashtable pathCells;

    public Sheet() {
        this.clearSheet();
    }

    public int typeNumber() {
        return 15;
    }

    public FunctorList toList() {
        return new FunctorListN(Bfunc.BFUNC.table[30], new LispObject[]{new StringAtom(this.name), new QuotedList(this.rows_columns[0]), new QuotedList(this.rows_columns[1]), new QuotedList(this.cells), new QuotedList(new LispObject[]{new ShortAtom(this.defaultWidthHeight[0]), new ShortAtom(this.defaultWidthHeight[1])})});
    }

    public static Sheet sheetFromList(FunctorList functorList) throws EvaluateException {
        Sheet sheet = new Sheet();
        sheet.name = ((StringAtomBase)functorList.getArgumentN(1)).getValue();
        sheet.rows_columns[0] = ((QuotedList)functorList.evaluateArgN(2)).toHashtable();
        sheet.rows_columns[1] = ((QuotedList)functorList.evaluateArgN(3)).toHashtable();
        Hashtable hashtable = ((QuotedList)functorList.evaluateArgN(4)).toHashtable();
        Object object = hashtable.elements();
        while (object.hasMoreElements()) {
            Cell cell = (Cell)object.nextElement();
            sheet.putCell(cell);
        }
        if (functorList.listSize() > 5) {
            object = (QuotedList)functorList.getArgumentN(5);
            sheet.defaultWidthHeight[0] = ((ShortAtom)((QuotedList)object).value[0]).value;
            sheet.defaultWidthHeight[1] = ((ShortAtom)((QuotedList)object).value[1]).value;
        }
        sheet.isChanged = false;
        return sheet;
    }

    public void clearSheet() {
        this.cells = new Hashtable();
        this.changedCells = new Hashtable();
        this.rows_columns = new Hashtable[]{new Hashtable(), new Hashtable()};
        this.refTable = new Vector();
    }

    public final boolean isEmpty(int n, int n2) {
        return this.getCell(n, n2).isEmpty();
    }

    public int coord(int n, int n2) {
        int n3 = 0;
        Hashtable hashtable = this.rows_columns[n];
        int n4 = this.defaultWidthHeight[n];
        for (int i = 0; i < n2; ++i) {
            RowColumn rowColumn = (RowColumn)hashtable.get(new Integer(i));
            if (rowColumn != null) {
                n3 += rowColumn.width_height;
                continue;
            }
            n3 += n4;
        }
        return n3;
    }

    private void addReference(int n, int n2, int n3, int n4, int n5, int n6) {
        for (int i = this.refTable.size() - 1; i >= 0; --i) {
            Dependency dependency = (Dependency)this.refTable.elementAt(i);
            if (dependency.i1 != n || dependency.j1 != n2 || dependency.i2 != n3 || dependency.j2 != n4 || dependency.i3 != n5 || dependency.j3 != n6) continue;
            return;
        }
        this.refTable.addElement(new Dependency(n, n2, n3, n4, n5, n6));
    }

    public Cell clearCell(int n, int n2) {
        for (int i = this.refTable.size() - 1; i >= 0; --i) {
            Dependency dependency = (Dependency)this.refTable.elementAt(i);
            if (dependency.i3 != n || dependency.j3 != n2) continue;
            this.refTable.removeElementAt(i);
        }
        Cell cell = this.getCell(n, n2);
        this.cells.remove(cell);
        this.changedCells.put(cell, cell);
        return cell;
    }

    public void setFormula(int n, int n2, String string) throws ParseException, EvaluateException {
        LispObject lispObject = LispObject.parseSExp(string);
        lispObject = Sheet.evaluateRef(lispObject, n, n2);
        Cell cell = this.getCell(n, n2);
        Cell cell2 = new Cell(n, n2, lispObject, cell.format);
        this.putCell(cell2);
    }

    void putCell(Cell cell) {
        this.clearCell(cell.i, cell.j);
        if (cell.formula != LispObject.NIL) {
            this.addRef(cell.formula, cell.i, cell.j);
            this.cells.put(cell, cell);
            this.changedCells.put(cell, cell);
        }
        this.isChanged = true;
    }

    public void setWSFormula(int n, int n2, String string) throws FormulaParseException, EvaluateException {
        LispObject lispObject;
        if (string.length() == 0) {
            lispObject = LispObject.NIL;
        } else {
            lispObject = Operator.OPERATOR.parseFormula(string);
            lispObject = Sheet.evaluateRef(lispObject, n, n2);
        }
        Cell cell = this.getCell(n, n2);
        Cell cell2 = new Cell(n, n2, lispObject, cell.format);
        this.putCell(cell2);
    }

    public void setFormula1(int n, int n2, String string) {
        try {
            this.setFormula(n, n2, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static LispObject evaluateRef(LispObject lispObject, int n, int n2) throws EvaluateException {
        if (lispObject.typeNumber() == 4) {
            FunctorList functorList = (FunctorList)lispObject;
            if (functorList.functor == Bfunc.BFUNC.table[32] || functorList.functor == Bfunc.BFUNC.table[47]) {
                return LispObject.fromList(functorList);
            }
            int n3 = functorList.listSize();
            if (functorList.functor == Bfunc.BFUNC.table[132]) {
                LispObject[] lispObjectArray = new LispObject[n3 - 1];
                for (int i = 1; i < n3; ++i) {
                    LispObject lispObject2 = functorList.getArgumentN(i);
                    lispObjectArray[i - 1] = Sheet.evaluateRef(lispObject2, n, n2);
                }
                return new QuotedList(lispObjectArray);
            }
            LispObject[] lispObjectArray = new LispObject[n3];
            boolean bl = false;
            lispObjectArray[0] = functorList.functor;
            for (int i = 1; i < n3; ++i) {
                LispObject lispObject3;
                LispObject lispObject4 = functorList.getArgumentN(i);
                if (lispObject4 == (lispObject3 = (lispObjectArray[i] = Sheet.evaluateRef(lispObject4, n, n2)))) continue;
                bl = true;
            }
            if (bl) {
                return LispObject.createFunctorList(lispObjectArray);
            }
        }
        return lispObject;
    }

    void addRef(LispObject lispObject, int n, int n2) {
        int n3;
        LispObject lispObject2;
        int n4 = lispObject.typeNumber();
        if (lispObject instanceof Reference) {
            Reference reference = (Reference)lispObject;
            if ((reference.absFlags & 0x10) == 0) {
                this.addReference(reference.i1, reference.j1, reference.i2, reference.j2, n, n2);
            }
            return;
        }
        if (lispObject instanceof FunctorList) {
            lispObject2 = (FunctorList)lispObject;
            n3 = lispObject2.listSize();
            for (int i = 1; i < n3; ++i) {
                this.addRef(((FunctorList)lispObject2).getArgumentN(i), n, n2);
            }
        }
        if (lispObject instanceof QuotedList) {
            lispObject2 = (QuotedList)lispObject;
            for (n3 = 0; n3 < ((QuotedList)lispObject2).value.length; ++n3) {
                this.addRef(((QuotedList)lispObject2).value[n3], n, n2);
            }
        }
    }

    void recalculateChangedCells(CanvasHandler1 canvasHandler1) throws CircularReferenceException {
        Enumeration enumeration;
        this.waveCells = LispObject.createHashtable(this.changedCells.size());
        this.pathCells = new Hashtable(10);
        while ((enumeration = this.changedCells.elements()).hasMoreElements()) {
            Cell cell = (Cell)enumeration.nextElement();
            enumeration = null;
            this.markDepended(cell, 0);
        }
        this.pathCells = null;
        int n = 0;
        while (this.waveCells.size() > 0) {
            enumeration = this.waveCells.elements();
            while (enumeration.hasMoreElements()) {
                WaveCell waveCell = (WaveCell)enumeration.nextElement();
                if (waveCell.level != n) continue;
                LispObject lispObject = FormulaError.ERROR;
                LispObject.debug("recalculating cell: " + waveCell.cell.toString());
                try {
                    lispObject = waveCell.cell.formula.evaluateSExp();
                }
                catch (EvaluateException evaluateException) {
                    LispObject.debug("error while recalculating cells: " + evaluateException.getMessage());
                }
                LispObject.debug("new value: " + lispObject.toString());
                waveCell.cell.value = lispObject;
                this.waveCells.remove(waveCell.cell);
                if (canvasHandler1 == null) continue;
                canvasHandler1.repaintCell(waveCell.cell.i, waveCell.cell.j);
            }
            ++n;
        }
        this.waveCells = null;
    }

    void markDepended(Cell cell, int n) throws CircularReferenceException {
        if (this.pathCells.containsKey(cell)) {
            throw new CircularReferenceException();
        }
        this.pathCells.put(cell, cell);
        this.changedCells.remove(cell);
        WaveCell waveCell = (WaveCell)this.waveCells.get(cell);
        if (waveCell == null || waveCell != null && waveCell.level < n) {
            waveCell = new WaveCell(cell, n);
            this.waveCells.put(cell, waveCell);
            for (int i = this.refTable.size() - 1; i >= 0; --i) {
                Dependency dependency = (Dependency)this.refTable.elementAt(i);
                if (cell.i < dependency.i1 || cell.i > dependency.i2 || cell.j < dependency.j1 || cell.j > dependency.j2) continue;
                this.markDepended(this.getCell(dependency.i3, dependency.j3), n + 1);
            }
        }
        this.pathCells.remove(cell);
    }

    public void insertCells(int n, int n2, int n3, int n4) {
        Enumeration enumeration;
        Hashtable hashtable = LispObject.createHashtable(this.cells.size());
        this.refTable.removeAllElements();
        this.changedCells.clear();
        Object object = this.cells.elements();
        while (object.hasMoreElements()) {
            enumeration = (Cell)object.nextElement();
            boolean bl = false;
            if (((Cell)((Object)enumeration)).i >= n) {
                if (n3 < 0 && ((Cell)((Object)enumeration)).i + n3 < n) {
                    bl = true;
                } else {
                    ((Cell)((Object)enumeration)).i = (short)(((Cell)((Object)enumeration)).i + n3);
                }
            }
            if (((Cell)((Object)enumeration)).j >= n2) {
                if (n4 < 0 && ((Cell)((Object)enumeration)).j + n4 < n2) {
                    bl = true;
                } else {
                    ((Cell)((Object)enumeration)).j = (short)(((Cell)((Object)enumeration)).j + n4);
                }
            }
            if (bl) continue;
            LispObject lispObject = ((Cell)((Object)enumeration)).formula.shiftReferences(n, n2, n3, n4);
            if (((Cell)((Object)enumeration)).formula != lispObject) {
                ((Cell)((Object)enumeration)).formula = lispObject;
                this.changedCells.put(enumeration, enumeration);
            }
            hashtable.put(enumeration, enumeration);
            this.addRef(((Cell)((Object)enumeration)).formula, ((Cell)((Object)enumeration)).i, ((Cell)((Object)enumeration)).j);
        }
        this.cells = hashtable;
        object = this.rows_columns[1];
        enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            RowColumn rowColumn = (RowColumn)enumeration.nextElement();
            if (n3 > 0 && rowColumn.index >= n) {
                ((Hashtable)object).remove(rowColumn);
                rowColumn.index = (short)(rowColumn.index + n3);
                ((Hashtable)object).put(rowColumn, rowColumn);
                continue;
            }
            if (n3 >= 0) continue;
            if (rowColumn.index >= n) {
                ((Hashtable)object).remove(rowColumn);
                rowColumn.index = (short)(rowColumn.index + n3);
                ((Hashtable)object).put(rowColumn, rowColumn);
                continue;
            }
            if (rowColumn.index < n - n3) continue;
            ((Hashtable)object).remove(rowColumn);
        }
        object = this.rows_columns[0];
        enumeration = ((Hashtable)object).elements();
        while (enumeration.hasMoreElements()) {
            RowColumn rowColumn = (RowColumn)enumeration.nextElement();
            if (n4 > 0 && rowColumn.index >= n2) {
                ((Hashtable)object).remove(rowColumn);
                rowColumn.index = (short)(rowColumn.index + n4);
                ((Hashtable)object).put(rowColumn, rowColumn);
                continue;
            }
            if (n4 >= 0) continue;
            if (rowColumn.index >= n2) {
                ((Hashtable)object).remove(rowColumn);
                rowColumn.index = (short)(rowColumn.index + n4);
                ((Hashtable)object).put(rowColumn, rowColumn);
                continue;
            }
            if (rowColumn.index < n2 - n4) continue;
            ((Hashtable)object).remove(rowColumn);
        }
    }

    public void copyCell1(int n, int n2, int n3, int n4) {
        if (n3 == 0 && n4 == 0) {
            return;
        }
        int n5 = n + n3;
        int n6 = n2 + n4;
        Cell cell = this.getCell(n, n2);
        LispObject lispObject = cell.formula.moveReferences(n3, n4);
        Cell cell2 = new Cell(n5, n6, lispObject, cell.format);
        this.putCell(cell2);
    }

    public Cell getCell(int n, int n2) {
        Cell cell = (Cell)this.cells.get(new Integer(n << 16 | n2));
        if (cell == null) {
            cell = new Cell(n, n2, LispObject.NIL, 0);
        }
        return cell;
    }

    public LispObject getCellValue(int n, int n2) {
        return this.getCell((int)n, (int)n2).value;
    }

    public RowColumn getRowColumn(int n, int n2) {
        RowColumn rowColumn = (RowColumn)this.rows_columns[n].get(new Integer(n2));
        if (rowColumn == null) {
            return new RowColumn(n2, this.defaultWidthHeight[n]);
        }
        return rowColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToRecordStore(String string) throws RecordStoreException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        DataOutputStream dataOutputStream = null;
        byte[] byArray = null;
        String string2 = null;
        try {
            string2 = this.toString();
            byteArrayOutputStream = new ByteArrayOutputStream(string2.length());
            dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(string2);
            }
            catch (IOException iOException) {
                throw new RecordStoreException("writeUTF() error");
            }
        }
        finally {
            string2 = null;
            if (dataOutputStream != null) {
                try {
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                catch (IOException iOException) {
                    LispObject.debug("exception when closing DataOutputStream");
                }
                dataOutputStream = null;
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.flush();
                    byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    LispObject.debug("exception when closing ByteArrayOutputStream");
                }
                byteArrayOutputStream = null;
            }
        }
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
        try {
            recordStore.addRecord(byArray, 0, byArray.length);
        }
        finally {
            if (recordStore != null) {
                recordStore.closeRecordStore();
                recordStore = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Sheet readFromRecordStore(String string) throws RecordStoreException, ParseException, EvaluateException {
        RecordStore recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
        byte[] byArray = null;
        try {
            byArray = recordStore.getRecord(1);
        }
        finally {
            if (recordStore != null) {
                recordStore.closeRecordStore();
                recordStore = null;
            }
        }
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        String string2 = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            filterInputStream = new DataInputStream(byteArrayInputStream);
            try {
                string2 = ((DataInputStream)filterInputStream).readUTF();
            }
            catch (IOException iOException) {
                throw new RecordStoreException("readUTF() error");
            }
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Sheet.sheetFromList((FunctorList)LispObject.parseSExp(string2));
    }

    public static void deleteFromRecordStore(String string) throws RecordStoreException {
        RecordStore.deleteRecordStore((String)string);
    }

    static QuotedList listSheets() {
        String[] stringArray = RecordStore.listRecordStores();
        int n = stringArray == null ? 0 : stringArray.length;
        LispObject[] lispObjectArray = new LispObject[n];
        for (int i = 0; i < n; ++i) {
            lispObjectArray[i] = new StringAtom(stringArray[i]);
        }
        return new QuotedList(lispObjectArray);
    }
}

