/*
 * Decompiled with CFR 0.152.
 */
package com.wapindustrial.calc;

import com.wapindustrial.calc.CanvasHandler1;
import com.wapindustrial.calc.EvaluateException;
import com.wapindustrial.calc.FunctionModule;
import com.wapindustrial.calc.FunctorList;
import com.wapindustrial.calc.LispObject;
import com.wapindustrial.calc.ParseException;
import com.wapindustrial.calc.StringAtom;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class ServerUploader
extends FunctionModule {
    public static final ServerUploader SERVERUPLOADER = new ServerUploader();
    static final byte[] _namesArray = new byte[]{9, 104, 116, 116, 112, 45, 108, 111, 97, 100, 11, 104, 116, 116, 112, 45, 117, 112, 108, 111, 97, 100};
    public static final int NAME_HTTP_LOAD = 0;
    public static final int NAME_HTTP_UPLOAD = 10;
    public static final int INDEX_HTTP_LOAD = 0;
    public static final int INDEX_HTTP_UPLOAD = 1;

    public void initializeNames() {
        this.namesArray = _namesArray;
        this.namesArrayCount = this.namesArray.length;
        this.table = new FunctionModule.ModuleName[]{(FunctionModule)this.new FunctionModule.ModuleName(0), (FunctionModule)this.new FunctionModule.ModuleName(10)};
        this.namesCount = this.table.length;
    }

    protected String getModuleClassName() {
        return "ServerUploader";
    }

    public LispObject evaluate(FunctionModule.ModuleName moduleName, FunctorList functorList) throws EvaluateException {
        int n = functorList.listSize();
        short s = moduleName.offset;
        try {
            switch (s) {
                case 0: {
                    return new StringAtom(ServerUploader.processGetRequest(functorList.getString1()));
                }
                case 10: {
                    try {
                        return LispObject.parseSExp(ServerUploader.processPostRequest(functorList.getString1(), functorList.getString2(), functorList.getString3(), functorList.getString(4))).evaluateSExp();
                    }
                    catch (ParseException parseException) {
                        throw new EvaluateException("Can't parse server reply: " + parseException.getMessage());
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new EvaluateException("Error processing HTTP request: " + iOException.getMessage());
        }
        return LispObject.NIL;
    }

    private static void setConnectionProperties(HttpConnection httpConnection, int n) throws IOException {
        CanvasHandler1 canvasHandler1 = CanvasHandler1.canvasHandler;
        httpConnection.setRequestProperty("User-Agent", canvasHandler1.getAppProperty("MIDlet-Name") + ' ' + canvasHandler1.getAppProperty("MIDlet-Version") + " (" + System.getProperty("microedition.platform") + ")");
        httpConnection.setRequestProperty("Content-Language", "en-US");
        httpConnection.setRequestProperty("Connection", "close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processPostRequest(String string, String string2, String string3, String string4) throws IOException {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            stringBuffer.append("USR=");
            ServerUploader.appendUrlEncoded(stringBuffer, string2);
            stringBuffer.append("&PWD=");
            ServerUploader.appendUrlEncoded(stringBuffer, string3);
            stringBuffer.append("&CODE=");
            ServerUploader.appendUrlEncoded(stringBuffer, string4);
            httpConnection = (HttpConnection)Connector.open((String)string);
            httpConnection.setRequestMethod("POST");
            ServerUploader.setConnectionProperties(httpConnection, stringBuffer.length());
            httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpConnection.setRequestProperty("Content-Length", String.valueOf(stringBuffer.length()));
            outputStream = httpConnection.openOutputStream();
            outputStream.write(stringBuffer.toString().getBytes());
            outputStream.close();
            outputStream = null;
            inputStream = httpConnection.openInputStream();
            stringBuffer.setLength(0);
            int n2 = (int)httpConnection.getLength();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        LispObject.debug("server reply: " + stringBuffer.toString());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String processGetRequest(String string) throws IOException {
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        CanvasHandler1 canvasHandler1 = CanvasHandler1.canvasHandler;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            int n;
            httpConnection = (HttpConnection)Connector.open((String)string);
            httpConnection.setRequestMethod("GET");
            ServerUploader.setConnectionProperties(httpConnection, stringBuffer.length());
            inputStream = httpConnection.openInputStream();
            int n2 = (int)httpConnection.getLength();
            while ((n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return stringBuffer.toString();
    }

    private static void appendUrlEncoded(StringBuffer stringBuffer, String string) {
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '%': 
                case '&': 
                case '+': 
                case '=': {
                    stringBuffer.append('%');
                    if (c < '\u0010') {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(Integer.toHexString(c));
                    continue block3;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
    }
}

